/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;

public class ResourceContent {
    private static String scrollElementJavaScript;
    private static String searchElementsJavaScript;
    private static String searchShadowElementsJavaScript;
    private static String documentSizeJavaScript;
    private static String elementAttributesJavaScript;
    private static String elementTextDataJavaScript;
    private static String parentElementJavaScript;
    private static String atsLogo;
    private static String pageStyle;

    private static String getScript(String ressourceName) {
        try {
            String javaScript = Resources.toString((URL)ResourceContent.class.getResource("/javascript/" + ressourceName + ".js"), (Charset)Charsets.UTF_8);
            return javaScript.replaceAll("[\n\t\r]", "");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] getAtsByteLogo() {
        try {
            return Resources.toByteArray((URL)ResourceContent.class.getResource("/icons/ats_power.png"));
        }
        catch (IOException e1) {
            return new byte[0];
        }
    }

    public static String getData(String name) {
        try {
            return Resources.toString((URL)ResourceContent.class.getResource("/" + name), (Charset)Charsets.UTF_8);
        }
        catch (IOException e1) {
            return "";
        }
    }

    public static String getPageStyle() {
        return pageStyle;
    }

    public static String getAtsLogo() {
        return atsLogo;
    }

    public static String getScrollElementJavaScript() {
        return scrollElementJavaScript;
    }

    public static String getSearchElementsJavaScript() {
        return searchElementsJavaScript;
    }

    public static String getSearchShadowElementsJavaScript() {
        return searchShadowElementsJavaScript;
    }

    public static String getDocumentSizeJavaScript() {
        return documentSizeJavaScript;
    }

    public static String getElementAttributesJavaScript() {
        return elementAttributesJavaScript;
    }

    public static String getElementTextDataJavaScript() {
        return elementTextDataJavaScript;
    }

    public static String getParentElementJavaScript() {
        return parentElementJavaScript;
    }

    static {
        documentSizeJavaScript = ResourceContent.getScript("documentSize");
        elementAttributesJavaScript = ResourceContent.getScript("elementAttributes");
        parentElementJavaScript = ResourceContent.getScript("parentElement");
        scrollElementJavaScript = ResourceContent.getScript("scrollElement");
        searchElementsJavaScript = ResourceContent.getScript("searchElements");
        elementTextDataJavaScript = ResourceContent.getScript("elementTextData");
        searchShadowElementsJavaScript = ResourceContent.getScript("searchShadowElements");
        atsLogo = Base64.getEncoder().encodeToString(ResourceContent.getAtsByteLogo());
        pageStyle = ResourceContent.getData("jsStyle");
    }
}

