/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

import com.ats.executor.ActionStatus;
import com.ats.generator.variables.parameter.ParameterDataFile;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.module.ModuleDescriptor;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.MediaType;

public class Utils {
    private static final String WHITE_PIXEL = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAACXBIWXMAAC4jAAAuIwF4pT92AAAAB3RJTUUH5wYKDCwDjkpXLgAAABl0RVh0Q29tbWVudABDcmVhdGVkIHdpdGggR0lNUFeBDhcAAAAMSURBVAjXY/j//z8ABf4C/tzMWecAAAAASUVORK5CYII=";
    public static final MediaType JSON_MEDIA = MediaType.get((String)"application/json; charset=utf-8");
    public static final MediaType TEXT_MEDIA = MediaType.get((String)"text/plain");
    private static final Pattern SYS_VERSION_PATTERN = Pattern.compile("<a href\\s?=\\s?\"([^\"]+\\.(zip|tgz))\">");

    public static String unescapeAts(String data) {
        return data.replaceAll("&sp;", " ").replaceAll("&co;", ",").replaceAll("&eq;", "=").replaceAll("&rb;", "]").replaceAll("&lb;", "[");
    }

    public static boolean isNumeric(String numString) {
        if (numString == null) {
            return false;
        }
        try {
            Double.parseDouble(numString);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int string2Int(String value) {
        return Utils.string2Int(value, 0);
    }

    public static int string2Int(String value, int defaultValue) {
        try {
            return Integer.parseInt(value.replaceAll("\\s", ""));
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long string2Long(String value) {
        try {
            return Long.parseLong(value.replaceAll("\\s", ""));
        }
        catch (NullPointerException | NumberFormatException e) {
            return 0L;
        }
    }

    public static boolean isNotEmpty(String value) {
        return value != null && !value.isBlank();
    }

    public static double string2Double(String value) {
        try {
            return Double.parseDouble(value.replaceAll("\\s", ""));
        }
        catch (NullPointerException | NumberFormatException e) {
            return 0.0;
        }
    }

    public static String truncateString(String value, int length) {
        if (value != null && value.length() > length) {
            value = value.substring(0, length);
        }
        return value;
    }

    public static JsonArray string2JsonArray(String value) {
        char[] letters = value.toCharArray();
        JsonArray array = new JsonArray();
        for (char ch : letters) {
            array.add((JsonElement)new JsonPrimitive((Number)ch));
        }
        return array;
    }

    public static String getShortUid() {
        char[] chars = "ABSDEFGHIJKLMNOPQRSTUVWXYZ1234567890".toCharArray();
        Random r = new Random(System.currentTimeMillis());
        char[] id = new char[8];
        for (int i = 0; i < 8; ++i) {
            id[i] = chars[r.nextInt(chars.length)];
        }
        return new String(id);
    }

    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                ret = ret && Utils.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }

    public static void deleteRecursiveFiles(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        if (f.isDirectory()) {
            for (File f0 : f.listFiles()) {
                if (f0.isDirectory()) {
                    Utils.deleteRecursiveFiles(f0);
                    if (f0.listFiles().length != 0) continue;
                    f0.delete();
                    continue;
                }
                if (!f0.isFile()) continue;
                f0.delete();
            }
        }
    }

    public static void deleteRecursiveJavaFiles(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        if (f.isDirectory()) {
            for (File f0 : f.listFiles()) {
                if (f0.isDirectory()) {
                    Utils.deleteRecursiveJavaFiles(f0);
                    if (f0.listFiles().length != 0) continue;
                    f0.delete();
                    continue;
                }
                if (!f0.isFile() || !f0.getName().toLowerCase().endsWith(".java")) continue;
                f0.delete();
            }
        }
    }

    public static void copyDir(String src, String dest, boolean overwrite) {
        try {
            Files.walk(Paths.get(src, new String[0]), new FileVisitOption[0]).forEach(a -> {
                Path b = Paths.get(dest, a.toString().substring(src.length()));
                try {
                    if (!a.toString().equals(src)) {
                        CopyOption[] copyOptionArray;
                        if (overwrite) {
                            CopyOption[] copyOptionArray2 = new CopyOption[1];
                            copyOptionArray = copyOptionArray2;
                            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                        } else {
                            copyOptionArray = new CopyOption[]{};
                        }
                        Files.copy(a, b, copyOptionArray);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkUrl(ActionStatus status, String urlPath) {
        int responseCode;
        URL url = null;
        try {
            url = new URI(urlPath).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            status.setPassed(false);
            status.setCode(-10);
            status.setData(urlPath);
            return false;
        }
        try {
            if (urlPath.startsWith("https")) {
                HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                con.setRequestMethod("HEAD");
                responseCode = con.getResponseCode();
            } else {
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("HEAD");
                responseCode = con.getResponseCode();
            }
        }
        catch (IOException e) {
            status.setPassed(false);
            status.setCode(-12);
            status.setData(e.getMessage());
            return false;
        }
        if (responseCode == 200) {
            return true;
        }
        status.setPassed(false);
        status.setCode(-11);
        status.setData(urlPath);
        return false;
    }

    public static String removeExtension(String s) {
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = s.lastIndexOf(separator);
        String filename = lastSeparatorIndex == -1 ? s : s.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    public static String leftString(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String getCauseStackTraceString(Throwable e, String indent) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = e.getCause();
        if (cause != null) {
            sb.append(indent);
            sb.append("Java exception caused by -> ");
            sb.append(Utils.getCauseStackTraceString(cause, indent));
        } else {
            Throwable[] suppressedExceptions;
            sb.append(e.toString());
            sb.append("\n");
            StackTraceElement[] stack = e.getStackTrace();
            if (stack != null) {
                for (StackTraceElement stackTraceElement : stack) {
                    sb.append(indent);
                    sb.append("\tat ");
                    sb.append(stackTraceElement.toString());
                    sb.append("\n");
                }
            }
            if ((suppressedExceptions = e.getSuppressed()) != null) {
                for (Throwable throwable : suppressedExceptions) {
                    sb.append(indent);
                    sb.append("\tSuppressed: ");
                    sb.append(Utils.getCauseStackTraceString(throwable, indent + "\t"));
                }
            }
        }
        return sb.toString();
    }

    public static byte[] loadImage(URL url) {
        byte[] byArray;
        block9: {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            InputStream inputStream = url.openStream();
            try {
                int n = 0;
                byte[] buffer = new byte[1024];
                while (-1 != (n = inputStream.read(buffer))) {
                    output.write(buffer, 0, n);
                }
                byArray = output.toByteArray();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public static byte[] getWhitePixel() {
        return Base64.getDecoder().decode(WHITE_PIXEL);
    }

    public static ParameterDataFile loadData(String url) throws MalformedURLException, URISyntaxException {
        return Utils.loadData(new ActionStatus(), new URI(url).toURL());
    }

    public static ParameterDataFile loadData(ActionStatus status, String url) throws MalformedURLException, URISyntaxException {
        return Utils.loadData(status, new URI(url).toURL());
    }

    public static ParameterDataFile loadData(ActionStatus status, URL url) {
        return new ParameterDataFile(status, url);
    }

    public static String getArtifactLastVersion(String folderUrl) {
        String version = null;
        try {
            HttpURLConnection con = (HttpURLConnection)new URI(folderUrl).toURL().openConnection();
            if (con.getResponseCode() == 200) {
                ModuleDescriptor.Version v;
                InputStream inputStream = con.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder builder = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                inputStream.close();
                ArrayList<String> versions = new ArrayList<String>();
                Matcher matcher = SYS_VERSION_PATTERN.matcher(builder.toString());
                int index = 0;
                while (matcher.find(index)) {
                    versions.add(matcher.group(1));
                    index = matcher.end();
                }
                if (versions.size() > 0 && (v = versions.stream().map(ModuleDescriptor.Version::parse).sorted(Collections.reverseOrder()).findFirst().get()) != null) {
                    version = v.toString().replace(".zip", "").replace(".tgz", "");
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return version;
    }
}

