/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.performance.external;

import com.ats.executor.channels.Channel;
import com.ats.script.actions.performance.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.Utils;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.zip.GZIPOutputStream;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class OctoperfApi {
    private static final int BUFFER = 2048;
    private static final String WORKSPACES_API = "workspaces";
    private static final String MEMBER_OF_API = "workspaces/member-of";
    private static final String USERS_CURRENT_API = "users/current";
    private static final String DESIGN_API = "design";
    private static final String VIRTUAL_USER_API = "design/virtual-users";
    private static final String PROJECT_API = "design/projects";
    private static final String VIRTUAL_USER_PROJECT_API = "design/virtual-users/by-project/";
    private static final String PROJECT_WORKSPACE_API = "design/projects/by-workspace/";
    private static final String IMPORT_HAR_API = "design/imports/har/";
    private final String MIME_TYPE = "multipart/form-data";
    private final String JSON_CONTENT_TYPE = "application/json";
    private String host;
    private String apiKey;
    private String userId;
    private String workspaceId;
    private String projectId;
    private boolean serverEnabled = false;

    public OctoperfApi(String host, String apiKey, String workspaceName, String projectName) {
        if (!((String)host).endsWith("/")) {
            host = (String)host + "/";
        }
        if (workspaceName == null) {
            workspaceName = "AtsWorkspace";
        }
        if (projectName == null) {
            projectName = "AtsCaptureProject";
        }
        this.host = host;
        this.apiKey = apiKey;
        this.checkProjectData(workspaceName, projectName);
    }

    private void checkProjectData(String workspaceName, String projectName) {
        this.userId = this.getCurrentUserId();
        if (this.userId != null && this.checkWorkspaceExists(workspaceName)) {
            this.serverEnabled = this.checkProjectExists(projectName);
        }
    }

    public void sendHarFileToUser(Channel channel, ActionOctoperfVirtualUser action, Path currentFile) {
        if (this.serverEnabled) {
            File gzipFile = null;
            Path tempFolder = null;
            try {
                tempFolder = Files.createTempDirectory("ats-octoperf_", new FileAttribute[0]);
                tempFolder.toFile().mkdirs();
                gzipFile = OctoperfApi.createGZipFile(tempFolder, currentFile.toFile());
            }
            catch (IOException e) {
                action.getStatus().setError(-30, e.getMessage());
            }
            if (gzipFile != null) {
                String[] tags = action.getTags().split(",");
                JsonArray tagsArray = new JsonArray();
                for (String tag : tags) {
                    tagsArray.add(tag.trim());
                }
                String virtualUserId = this.getVirtualUser(action.getUser().getCalculated(), action.getComment().getCalculated(), tagsArray, action.isAppend());
                if (virtualUserId != null) {
                    this.executeRequest(this.getMultiPartRequest(channel, gzipFile, IMPORT_HAR_API, this.projectId, "?containers=PAGE_REF&resources=KEEP_ALL&virtualUserId=", virtualUserId));
                }
                gzipFile.delete();
            }
            if (tempFolder != null) {
                tempFolder.toFile().delete();
            }
        }
    }

    private String getCurrentUserId() {
        String id;
        JsonElement response = this.executeRequest(this.getGetRequest(USERS_CURRENT_API));
        if (response != null && response.isJsonObject() && response.getAsJsonObject().has("id") && (id = response.getAsJsonObject().get("id").getAsString()) != null && id.length() > 0) {
            return id;
        }
        return null;
    }

    private String getVirtualUser(String name, String comment, JsonArray tags, boolean append) {
        JsonElement response = this.executeRequest(this.getGetRequest(VIRTUAL_USER_PROJECT_API, this.projectId));
        if (response != null && response.isJsonArray()) {
            JsonArray virtualUsers = response.getAsJsonArray();
            for (int i = 0; i < virtualUsers.size(); ++i) {
                JsonElement virtualUser = virtualUsers.get(i);
                if (!virtualUser.isJsonObject() || !virtualUser.getAsJsonObject().has("name") || !virtualUser.getAsJsonObject().get("name").getAsString().equals(name)) continue;
                JsonObject virtualUserObject = virtualUser.getAsJsonObject();
                String virtualUserId = virtualUser.getAsJsonObject().get("id").getAsString();
                virtualUserObject.remove("tags");
                virtualUserObject.add("tags", (JsonElement)tags);
                virtualUserObject.remove("description");
                virtualUserObject.addProperty("description", comment);
                if (!append) {
                    virtualUserObject.remove("children");
                    virtualUserObject.add("children", (JsonElement)new JsonArray());
                }
                this.executeRequest(this.getPutRequest(virtualUser, VIRTUAL_USER_API, "/", virtualUserId));
                return virtualUserId;
            }
        }
        return this.createVirtualUser(name, comment, tags);
    }

    private String createVirtualUser(String name, String comment, JsonArray tags) {
        JsonObject createdUser;
        JsonObject virtualUser = OctoperfApi.createJsonDataWithTag(this.userId, name, comment, "JMETER", tags);
        virtualUser.addProperty("projectId", this.projectId);
        virtualUser.addProperty("@type", "VirtualUser");
        virtualUser.add("children", (JsonElement)new JsonArray());
        JsonElement response = this.executeRequest(this.getPostRequest((JsonElement)virtualUser, VIRTUAL_USER_API));
        if (response != null && response.isJsonObject() && (createdUser = response.getAsJsonObject()).has("id")) {
            return createdUser.get("id").getAsString();
        }
        return null;
    }

    private boolean createWorkspace(String name) {
        JsonObject obj;
        JsonObject newWorkspace = OctoperfApi.createJsonData(this.userId, name, "New Workspace created by ATS framework");
        JsonElement createWorskpace = this.executeRequest(this.getPostRequest((JsonElement)newWorkspace, WORKSPACES_API));
        if (createWorskpace != null && createWorskpace.isJsonObject() && (obj = createWorskpace.getAsJsonObject()).has("id")) {
            this.workspaceId = obj.get("id").getAsString();
            return true;
        }
        return false;
    }

    private boolean createProject(String name) {
        JsonObject obj;
        JsonArray tags = new JsonArray();
        tags.add("ats");
        JsonObject newProject = OctoperfApi.createJsonDataWithTag(this.userId, name, "New Project created by ATS framework", "DESIGN", tags);
        newProject.addProperty("workspaceId", this.workspaceId);
        JsonElement createProject = this.executeRequest(this.getPostRequest((JsonElement)newProject, PROJECT_API));
        if (createProject != null && createProject.isJsonObject() && (obj = createProject.getAsJsonObject()).has("id")) {
            this.projectId = obj.get("id").getAsString();
            return true;
        }
        return false;
    }

    private boolean checkWorkspaceExists(String workspaceName) {
        JsonElement response = this.executeRequest(this.getGetRequest(MEMBER_OF_API));
        if (response != null && response.isJsonArray()) {
            JsonArray workspaces = response.getAsJsonArray();
            for (int i = 0; i < workspaces.size(); ++i) {
                JsonElement item = workspaces.get(i);
                if (!item.isJsonObject() || !item.getAsJsonObject().has("name") || !item.getAsJsonObject().get("name").getAsString().equals(workspaceName)) continue;
                this.workspaceId = item.getAsJsonObject().get("id").getAsString();
                return true;
            }
        }
        return this.createWorkspace(workspaceName);
    }

    private boolean checkProjectExists(String projectName) {
        JsonElement response = this.executeRequest(this.getGetRequest(PROJECT_WORKSPACE_API, this.workspaceId, "/DESIGN"));
        if (response != null && response.isJsonArray()) {
            JsonArray projects = response.getAsJsonArray();
            for (int i = 0; i < projects.size(); ++i) {
                JsonElement item = projects.get(i);
                if (!item.isJsonObject() || !item.getAsJsonObject().has("name") || !item.getAsJsonObject().get("name").getAsString().equals(projectName)) continue;
                this.projectId = item.getAsJsonObject().get("id").getAsString();
                return true;
            }
        }
        return this.createProject(projectName);
    }

    private static JsonObject createJsonDataWithTag(String userId, String name, String description, String type, JsonArray tags) {
        JsonObject obj = OctoperfApi.createJsonData(userId, name, description);
        obj.addProperty("type", type);
        obj.add("tags", (JsonElement)tags);
        return obj;
    }

    private static JsonObject createJsonData(String userId, String name, String description) {
        String currentDate = Instant.now().toString();
        JsonObject obj = new JsonObject();
        obj.addProperty("created", currentDate);
        obj.addProperty("description", description);
        obj.addProperty("id", "");
        obj.addProperty("lastModified", currentDate);
        obj.addProperty("name", name);
        obj.addProperty("userId", userId);
        return obj;
    }

    private static File createGZipFile(Path tempFolder, File harFile) throws IOException {
        if (harFile.exists()) {
            String harFileName = harFile.getName();
            File gzipFile = tempFolder.resolve(harFileName + ".gzip").toFile();
            try {
                int len;
                FileInputStream fis = new FileInputStream(harFile);
                FileOutputStream fos = new FileOutputStream(gzipFile);
                GZIPOutputStream gzipOS = new GZIPOutputStream(fos);
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) != -1) {
                    gzipOS.write(buffer, 0, len);
                }
                gzipOS.close();
                fos.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return gzipFile;
        }
        return null;
    }

    private Request.Builder getRequest(String ... queryParts) {
        StringBuilder urlBuilder = new StringBuilder(this.host);
        for (String str : queryParts) {
            urlBuilder.append(str);
        }
        Request.Builder request = new Request.Builder().url(urlBuilder.toString()).addHeader("User-Agent", "ats").addHeader("Authorization", this.apiKey);
        return request;
    }

    private Request getPostRequest(JsonElement element, String ... queryParts) {
        Request request = this.getRequest(queryParts).addHeader("Content-Type", "application/json").post(RequestBody.Companion.create(element.toString(), Utils.JSON_MEDIA)).build();
        return request;
    }

    private Request getPutRequest(JsonElement element, String ... queryParts) {
        Request request = this.getRequest(queryParts).addHeader("Content-Type", "application/json").put(RequestBody.Companion.create(element.toString(), Utils.JSON_MEDIA)).build();
        return request;
    }

    private Request getGetRequest(String ... queryParts) {
        Request request = this.getRequest(queryParts).get().build();
        return request;
    }

    public Request getMultiPartRequest(Channel channel, File f, String ... queryParts) {
        String fileType = "";
        if (f.getName().endsWith(".gzip")) {
            fileType = "application/x-gzip";
        }
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", f.getName(), (RequestBody)new RequestBodyWithUploadProgress(f, fileType, channel)).build();
        Request request = this.getRequest(queryParts).addHeader("Content-Type", "application/json").addHeader("MimeType", "multipart/form-data").post((RequestBody)requestBody).build();
        return request;
    }

    private JsonElement executeRequest(Request request) {
        OkHttpClient client = new OkHttpClient.Builder().build();
        try {
            Response response = client.newCall(request).execute();
            String responseData = CharStreams.toString((Readable)new InputStreamReader(response.body().byteStream(), Charsets.UTF_8));
            response.close();
            return JsonParser.parseString((String)responseData);
        }
        catch (JsonSyntaxException | IOException e) {
            return null;
        }
    }

    public class RequestBodyWithUploadProgress
    extends RequestBody {
        private final File file;
        private final String contentType;
        private final long fileLength;
        private final Channel channel;

        public RequestBodyWithUploadProgress(File file, String contentType, Channel channel) {
            this.file = file;
            this.contentType = contentType;
            this.fileLength = file.length();
            this.channel = channel;
        }

        public long contentLength() {
            return this.fileLength;
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.contentType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(BufferedSink sink) throws IOException {
            Source source = null;
            try {
                source = Okio.source((File)this.file);
                long total = 0L;
                if (this.fileLength > 2048L) {
                    long read;
                    int threshold = 0;
                    while ((read = source.read(sink.buffer(), 2048L)) != -1L) {
                        sink.flush();
                        int percent = (int)((float)(total += read) / (float)this.fileLength * 100.0f);
                        if (percent <= threshold) continue;
                        threshold += 10;
                        this.channel.sendLog(54, "Uploading HAR file, remaining bytes percent to upload", 100 - percent + 1);
                    }
                    this.channel.sendLog(54, "Uploading HAR file done", 0);
                } else {
                    source.read(sink.buffer(), this.fileLength);
                    sink.flush();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                Util.closeQuietly((Closeable)source);
            }
        }
    }
}

