/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.executor.ActionTestScript;
import com.ats.recorder.IVisualData;
import com.ats.recorder.ShadowScript;
import com.ats.recorder.VisualReport;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.tools.Utils;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.report.analytics.ActionsDuration;
import com.ats.tools.report.analytics.ActionsType;
import com.exadel.flamingo.flex.messaging.amf.io.AMF3Deserializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlReport {
    public static String ATS_JSON_SUITES = "ats-suites.json";
    private static ExecutionLogger insideLogger = new ExecutionLogger();
    public static String REPORT_FILE = "actions.xml";

    public static void main(String[] args) {
        String output = null;
        String testName = null;
        List<String> listArgs = Arrays.asList(args);
        if (listArgs.contains("--help") || listArgs.contains("-h") || listArgs.contains("--h") || listArgs.contains("/?") || listArgs.contains("\\?")) {
            XmlReport.usage();
            return;
        }
        block10: for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            if (!string.startsWith("--") || i + 1 >= args.length) continue;
            switch (string.substring(2)) {
                case "outputFolder": 
                case "output": 
                case "reportFolder": {
                    output = args[i + 1].replaceAll("\"", "");
                    continue block10;
                }
                case "testName": {
                    testName = args[i + 1].replaceAll("\"", "");
                }
            }
        }
        if (output == null) {
            System.out.println("Error, output folder not defined !");
            return;
        }
        if (testName == null) {
            System.out.println("Error, testName not defined !");
            return;
        }
        Path outputFolderPath = Paths.get(output, new String[0]).toAbsolutePath();
        if (!outputFolderPath.toFile().exists()) {
            System.out.println("Error, output folder path not found : " + output);
            return;
        }
    }

    private static void usage() {
        System.out.print("Usage : Experiment dev\nThis class is use to extract data action from ATSV, convert and generate to actions.xml\n\nParameters usage :\n\t--output\t\t\t(mandatory)(absolute or relative path) : parameter used to\n\t  outputFolder\t\tspecify the input and output folder of generated folder\n\t  reportFolder\t\t\n\t--testName\t\t\t(mandatory) :\n\n\n\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createReport(ActionTestScript topScript, Path output, ScriptHeader header, ExecutionLogger execLogger, boolean savePic) {
        ShadowScript shadowScript = topScript.getShadowScript();
        String summaryText = topScript.getSummaryText();
        boolean addCharts = true;
        String qualifiedName = header.getQualifiedName();
        File atsvFile = output.resolve(qualifiedName + ".atsv").toFile();
        System.getProperty("ats-report");
        if (execLogger == null) {
            execLogger = insideLogger;
        }
        ExecutionLogger logger = execLogger;
        if (atsvFile.exists()) {
            File xmlFolder = output.resolve(qualifiedName + "_xml").toFile();
            logger.sendInfo("Create XML report", xmlFolder.getAbsolutePath());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                Utils.deleteRecursive(xmlFolder);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            xmlFolder.mkdirs();
            Path xmlFolderPath = xmlFolder.toPath();
            try {
                Document document;
                block47: {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    document = builder.newDocument();
                    FileInputStream fis = null;
                    AMF3Deserializer amf3 = null;
                    int loopAction = 0;
                    try {
                        fis = new FileInputStream(atsvFile);
                        amf3 = new AMF3Deserializer((InputStream)fis);
                        Element atsRoot = document.createElement("ats");
                        document.appendChild(atsRoot);
                        VisualReport report = null;
                        try {
                            report = (VisualReport)amf3.readObject();
                        }
                        catch (Exception e) {
                            logger.sendError("Unable to read the report header ->", e.getMessage());
                        }
                        if (report == null) break block47;
                        Element script = document.createElement("script");
                        atsRoot.appendChild(script);
                        script.setAttribute("testId", report.getId());
                        script.setAttribute("testName", report.getScript());
                        script.setAttribute("externalId", report.getExternalId());
                        script.setAttribute("cpuSpeed", String.valueOf(report.getCpuSpeed()));
                        script.setAttribute("cpuCount", String.valueOf(report.getCpuCount()));
                        script.setAttribute("totalMemory", String.valueOf(report.getTotalMemory()));
                        script.setAttribute("osInfo", report.getOsInfo());
                        Element description = document.createElement("description");
                        description.setTextContent(report.getDescription());
                        script.appendChild(description);
                        Element author = document.createElement("author");
                        author.setTextContent(report.getAuthor());
                        script.appendChild(author);
                        Element prerequisite = document.createElement("prerequisite");
                        prerequisite.setTextContent(report.getPrerequisite());
                        script.appendChild(prerequisite);
                        Element started = document.createElement("started");
                        started.setTextContent(report.getStarted());
                        script.appendChild(started);
                        Element startedFormated = document.createElement("startedFormated");
                        startedFormated.setTextContent(OffsetDateTime.ofInstant(Instant.ofEpochMilli(Utils.string2Long(report.getStarted())), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd 'at' HH:mm:ss")));
                        script.appendChild(startedFormated);
                        Element quality = document.createElement("quality");
                        quality.setTextContent(String.valueOf(report.getQuality()));
                        script.appendChild(quality);
                        Element groups = document.createElement("groups");
                        for (String gr : report.getGroupsList()) {
                            Element group = document.createElement("group");
                            group.setTextContent(gr);
                            groups.appendChild(group);
                        }
                        script.appendChild(groups);
                        Element project = document.createElement("project");
                        Element projectId = document.createElement("id");
                        projectId.setTextContent(header.getProjectUuid());
                        project.appendChild(projectId);
                        Element projectName = document.createElement("name");
                        projectName.setTextContent(header.getProjectId());
                        project.appendChild(projectName);
                        script.appendChild(project);
                        Element actions = document.createElement("actions");
                        atsRoot.appendChild(actions);
                        try {
                            amf3.readObject();
                        }
                        catch (Exception e) {
                            logger.sendError("StartScript action exception ->", e.getMessage());
                        }
                        ArrayList<IVisualData> visualActions = new ArrayList<IVisualData>();
                        if (shadowScript != null) {
                            for (Action action : shadowScript.getActions()) {
                                visualActions.add(action.getVisualAction());
                            }
                        }
                        while (amf3.available() > 0) {
                            try {
                                IVisualData data = (IVisualData)amf3.readObject();
                                visualActions.add(data);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ActionsDuration durationChart = new ActionsDuration();
                        ActionsType actionsTypeChart = new ActionsType();
                        visualActions.sort(Comparator.comparing(IVisualData::getTimeLine, Comparator.nullsLast(Comparator.naturalOrder())));
                        for (IVisualData action : visualActions) {
                            Element elem = action.getAction(logger, script, summaryText, document, xmlFolderPath, durationChart, actionsTypeChart, savePic, addCharts);
                            if (elem == null) continue;
                            elem.setAttribute("index", String.valueOf(loopAction));
                            actions.appendChild(elem);
                            ++loopAction;
                        }
                    }
                    catch (IOException e1) {
                        logger.sendError("XML report file error ->", e1.getMessage());
                    }
                    catch (Exception e2) {
                        logger.sendError("XML report exception at action #" + loopAction + " ->", e2.getMessage());
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException e) {
                            logger.sendError("XML report close stream error ->", e.getMessage());
                        }
                    }
                }
                try {
                    BufferedWriter writer = Files.newBufferedWriter(xmlFolder.toPath().resolve(REPORT_FILE), StandardCharsets.UTF_8, new OpenOption[0]);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.transform(new DOMSource(document), new StreamResult(writer));
                }
                catch (TransformerConfigurationException e2) {
                    logger.sendError("XML report config error ->", e2.getMessage());
                }
                catch (TransformerException e3) {
                    logger.sendError("XML report transform error ->", e3.getMessage());
                }
                catch (FileNotFoundException e4) {
                    logger.sendError("XML report write file error ->", e4.getMessage());
                }
                catch (IOException e5) {
                    logger.sendError("XML report IO write file error ->", e5.getMessage());
                }
            }
            catch (ParserConfigurationException e4) {
                logger.sendError("XML report parser error ->", e4.getMessage());
            }
            logger.sendInfo("XML report generated", xmlFolder.getAbsolutePath());
        } else {
            File xmlFolder = output.resolve(qualifiedName + "_xml").toFile();
            logger.sendInfo("Create empty XML report because no ATSV file found", xmlFolder.getAbsolutePath());
            try {
                Utils.deleteRecursive(xmlFolder);
            }
            catch (FileNotFoundException factory) {
                // empty catch block
            }
            xmlFolder.mkdirs();
            if (shadowScript != null) {
                try {
                    BufferedWriter writer = Files.newBufferedWriter(xmlFolder.toPath().resolve(REPORT_FILE), StandardCharsets.UTF_8, new OpenOption[0]);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.transform(new DOMSource(shadowScript.getScriptXmlResult(summaryText)), new StreamResult(writer));
                }
                catch (TransformerConfigurationException e2) {
                    logger.sendError("XML report config error ->", e2.getMessage());
                }
                catch (TransformerException e3) {
                    logger.sendError("XML report transform error ->", e3.getMessage());
                }
                catch (FileNotFoundException e4) {
                    logger.sendError("XML report write file error ->", e4.getMessage());
                }
                catch (IOException e5) {
                    logger.sendError("XML report IO write file error ->", e5.getMessage());
                }
            }
            logger.sendInfo("XML report generated", xmlFolder.getAbsolutePath());
        }
    }

    public static Element readSummaryFile(DocumentBuilder builder, Path file) throws SAXException, IOException, ParserConfigurationException {
        Document document = builder.parse(file.toFile());
        document.getDocumentElement().normalize();
        return document.getDocumentElement();
    }
}

