/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.analytics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.util.UnitType;
import org.jfree.data.general.PieDataset;

public class AtsPieChart
implements JRChartCustomizer {
    private static final String FAIL = "fail";
    private static final String PASS = "pass";
    private static final String SKIP = "skip";
    private static final String EMPTY = "empty";
    private static final Color FAIL_COLOR = Color.decode("#35535E");
    private static final Color PASS_COLOR = Color.decode("#9CBF3F");
    private static final Color SKIP_COLOR = Color.decode("#ECF0DF");
    private static final Color EMPTY_COLOR = Color.decode("#d4d0d8");
    private static StandardPieSectionLabelGenerator labelGen = new StandardPieSectionLabelGenerator("{0} ({2})", new DecimalFormat("0"), new DecimalFormat("0%")){

        public String generateSectionLabel(PieDataset dataset, Comparable key) {
            if (dataset.getValue(key).intValue() == 0) {
                return null;
            }
            return super.generateSectionLabel(dataset, key);
        }
    };

    public void customize(JFreeChart chart, JRChart jasperChart) {
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelBackgroundPaint(null);
        plot.setLabelOutlinePaint(null);
        plot.setLabelShadowPaint(null);
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        plot.setOutlineVisible(false);
        plot.setSimpleLabels(false);
        plot.setOutlinePaint((Paint)Color.WHITE);
        plot.setStartAngle(90.0);
        plot.setInteriorGap(0.0);
        plot.setDefaultSectionOutlinePaint((Paint)Color.WHITE);
        plot.setMaximumLabelWidth(0.2);
        plot.setInsets(new RectangleInsets(UnitType.ABSOLUTE, 0.0, 0.0, 1.0, 1.0));
        plot.setLegendItemShape((Shape)new Rectangle2D.Double(1.0, 2.0, 30.0, 6.0));
        PieDataset dataSet = plot.getDataset();
        Iterator iterator = plot.getLegendItems().iterator();
        while (iterator.hasNext()) {
            LegendItem item = (LegendItem)iterator.next();
            if (dataSet.getValue(item.getSeriesIndex()).intValue() != 0) continue;
            iterator.remove();
        }
        plot.setLabelGenerator((PieSectionLabelGenerator)labelGen);
        plot.setSectionPaint((Comparable)((Object)FAIL), (Paint)FAIL_COLOR);
        plot.setSectionPaint((Comparable)((Object)PASS), (Paint)PASS_COLOR);
        plot.setSectionPaint((Comparable)((Object)SKIP), (Paint)SKIP_COLOR);
        plot.setSectionPaint((Comparable)((Object)EMPTY), (Paint)EMPTY_COLOR);
        plot.setShadowGenerator(null);
    }
}

