/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element.test;

import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.recorder.IVisualRecorder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.openqa.selenium.NoAlertPresentException;

public class TestElementDialog
extends TestElement {
    private static final String ID_CRITERIA = "id";
    private static final String TEXT_CRITERIA = "text";
    private static final String TYPE_CRITERIA = "type";
    private static final String INDEX_CRITERIA = "index";
    private static final String TITLE = "title";
    public static final String DIALOG = "dialog";
    public static final String ACCEPT = "accept";
    public static final String DISMISS = "dismiss";
    public static final String DIALOG_NOT_FOUND = "Dialog box not found";
    private DialogBox alert = null;
    private String alertAction = null;
    private String alertCriteria = null;

    public TestElementDialog() {
    }

    public TestElementDialog(ActionTestScript script, Channel channel) {
        super(script, channel);
    }

    public TestElementDialog(ActionTestScript script, Channel channel, int maxTry, SearchedElement searchElement, Predicate<Integer> predicate) {
        super(script, channel, maxTry, predicate);
        this.initSearch(searchElement.getCriterias());
    }

    public TestElementDialog(ActionTestScript script, Channel channel, int maxTry, List<CalculatedProperty> criterias) {
        super(script, channel, maxTry);
        this.initSearch(criterias);
    }

    public TestElementDialog(ActionTestScript script, FoundElement element, Channel currentChannel) {
        super(script, element, currentChannel);
    }

    public String getAlertAction() {
        return this.alertAction;
    }

    private void initSearch(List<CalculatedProperty> properties) {
        if (properties.size() > 0) {
            this.alertAction = properties.get(0).getValue().getDataListItem();
            this.alertCriteria = properties.get(0).getName();
        }
        try {
            this.alert = this.getChannel().switchToAlert();
            this.setFoundElements(new ArrayList<FoundElement>(Arrays.asList(new FoundElement())));
            this.setCount(1);
        }
        catch (NoAlertPresentException ex) {
            this.getChannel().sleep(500);
            this.setCount(0);
        }
    }

    @Override
    public void updateScreen() {
        this.recorder.updateScreen(true);
    }

    @Override
    public FoundElement getFoundElement() {
        return null;
    }

    @Override
    public void over(ActionStatus status, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
    }

    @Override
    public String enterText(ActionStatus status, CalculatedValue text, ActionTestScript script, int waitChar) {
        this.sendText(script, status, text, waitChar);
        return text.getCalculated();
    }

    @Override
    public void clearText(ActionStatus status, MouseDirection md) {
    }

    @Override
    public String sendText(ActionTestScript script, ActionStatus status, CalculatedValue text, int waitChar) {
        String enterText = text.getCalculated();
        this.getChannel().sleep(this.alert.getWaitBox());
        if (this.alertCriteria != null) {
            switch (this.alertCriteria) {
                case "index": {
                    try {
                        this.alert.sendKeys(enterText, Integer.parseInt(this.alertAction));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "id": {
                    this.alert.sendKeys(enterText, this.alertAction);
                    break;
                }
                case "text": 
                case "type": {
                    this.alert.sendKeys(enterText);
                }
            }
        } else {
            this.alert.sendKeys(enterText);
        }
        if (ACCEPT.equals(this.alertAction)) {
            this.alert.accept(status);
        } else if (DISMISS.equals(this.alertAction)) {
            this.alert.dismiss(status);
        }
        return enterText;
    }

    @Override
    public String getAttribute(ActionStatus status, String name) {
        if (this.alert == null) {
            return "";
        }
        this.getChannel().sleep(this.alert.getWaitBox());
        if (TITLE.equals(name.toLowerCase())) {
            return this.alert.getTitle();
        }
        return this.alert.getText();
    }

    @Override
    public void click(ActionStatus status, MouseDirection position) {
        this.getChannel().sleep(this.alert.getWaitBox());
        status.setPassed(true);
        if (this.alertCriteria != null) {
            switch (this.alertCriteria) {
                case "index": {
                    try {
                        this.alert.clickButtonAtIndex(Integer.parseInt(this.alertAction), status);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "id": {
                    this.alert.clickButtonId(this.alertAction, status);
                    break;
                }
                case "text": {
                    this.alert.clickButtonText(this.alertAction, status);
                    break;
                }
                case "type": {
                    if (DISMISS.equals(this.alertAction)) {
                        this.alert.dismiss(status);
                        break;
                    }
                    if (ACCEPT.equals(this.alertAction)) {
                        this.alert.accept(status);
                        break;
                    }
                    this.alert.defaultButton(status);
                }
            }
        } else {
            this.alert.defaultButton(status);
        }
        this.getChannel().sleep(this.alert.getWaitBox());
        this.getChannel().switchToDefaultContent(true);
    }

    @Override
    public CalculatedProperty[] getHtmlAttributes() {
        return this.getAttributes(true);
    }

    @Override
    public CalculatedProperty[] getAttributes(boolean reload) {
        if (this.alert == null) {
            return new CalculatedProperty[0];
        }
        return this.alert.getAttributes();
    }

    @Override
    public void updateScreen(ActionStatus status, IVisualRecorder rec) {
        rec.updateScreen(status, this.getAlertAction());
    }

    @Override
    public String getNotFoundDescription() {
        return DIALOG_NOT_FOUND;
    }
}

