/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.AtsSingleton;
import com.ats.data.Dimension;
import com.ats.data.Rectangle;
import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsManager;
import com.ats.driver.AtsRemoteWebDriver;
import com.ats.element.AtsBaseElement;
import com.ats.element.AtsElement;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.executor.SendTextException;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.DriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.SystemDriverEngine;
import com.ats.generator.ATS;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.transform.DateTransformer;
import com.ats.script.actions.ActionApi;
import com.ats.tools.ResourceContent;
import com.ats.tools.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Pdf;
import org.openqa.selenium.Point;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.print.PrintOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.support.ui.Select;

public class WebDriverEngine
extends DriverEngine
implements IDriverEngine {
    protected static final String WEB_ELEMENT_REF = "element-6066-11e4-a52e-4f735466cecf";
    private static final int DEFAULT_WAIT = 150;
    private static final int DEFAULT_PROPERTY_WAIT = 200;
    private static final String ANGULAR_OPTION = "mat-option";
    private static final String LAST_WINDOW = "LAST_WINDOW";
    protected String JS_SCROLL_IF_NEEDED = "var e=arguments[0], result=[], r=e.getBoundingClientRect(), top0=r.top, left0=r.left; e.scrollIntoView({behavior:'instant',block:'center',inline:'nearest'});r=e.getBoundingClientRect();if(r.left!=left0 || r.top!=top0) {result=[r.left+0.0001, r.top+0.0001];}";
    protected String JS_ELEMENT_FROM_POINT = "var result=null;var parent=document;if(arguments[0]!=null){parent=arguments[0].shadowRoot};var e=parent.elementFromPoint(arguments[1],arguments[2]);if(e && e!=arguments[0]){var r=e.getBoundingClientRect();result=[e, e.tagName, e.getAttribute('inputmode')=='numeric', e.getAttribute('type')=='password', r.x+0.0001, r.y+0.0001, r.width+0.0001, r.height+0.0001, r.left+0.0001, r.top+0.0001, 0.0001, 0.0001, {},e.shadowRoot!=null];};";
    protected String JS_ELEMENT_PARENTS = ResourceContent.getParentElementJavaScript();
    protected final String JS_ELEMENT_PARENTS_HTML = ResourceContent.getParentElementHtmlCode();
    protected static final String JS_ELEMENT_SCROLL = "var e=arguments[0];var d=arguments[1];e.scrollTop += d;var r=e.getBoundingClientRect();var result=[r.left+0.0001, r.top+0.0001]";
    protected static final String JS_WINDOW_SCROLL = "window.scrollBy(0,arguments[0]);var result=[0.0001, 0.0001]";
    protected static final String JS_ELEMENT_FROM_RECT = "let parent=document, x1=arguments[1],y1=arguments[2],w=arguments[3],h=arguments[4];if(arguments[0]!=null){parent=arguments[0].shadowRoot};let x2=x1+w,y2=y1+h;var e=parent.elementFromPoint(x1+(w/2), y1+(h/2)),result=null;while(e != null && e!=arguments[0]){var r=e.getBoundingClientRect();if(x1 >= r.x && x2 <= r.x+r.width && y1 >= r.y && y2 <= r.y+r.height){result=[e,e.tagName,e.getAttribute('inputmode')=='numeric',e.getAttribute('type')=='password',r.x+0.0001,r.y+0.0001,r.width+0.0001,r.height+0.0001,r.left+0.0001,r.top+0.0001,0.0001,0.0001,{},e.shadowRoot!=null];e=null;}else{e=e.parentElement;}};";
    protected static final String JS_ELEMENT_BOUNDING = "var rect=arguments[0].getBoundingClientRect();var result=[rect.left+0.0001, rect.top+0.0001];";
    protected static final String JS_MIDDLE_CLICK = "var evt=new MouseEvent('click', {bubbles: true,cancelable: true,view: window, button: 1}),result={};arguments[0].dispatchEvent(evt);";
    protected static final String JS_ELEMENT_CSS = "var result={};var o=getComputedStyle(arguments[0]);for(var i=0, len=o.length; i < len; i++){result[o[i]]=o.getPropertyValue(o[i]);};";
    protected static final String JS_SEARCH_ELEMENT = ResourceContent.getSearchElementsJavaScript();
    protected static final String JS_SEARCH_SHADOW_ELEMENT = ResourceContent.getSearchShadowElementsJavaScript();
    protected static final String JS_ELEMENT_AUTOSCROLL = ResourceContent.getScrollElementJavaScript();
    protected static final String JS_ELEMENT_ATTRIBUTES = ResourceContent.getElementAttributesJavaScript();
    protected static final String JS_ELEMENT_TEXT_DATA = ResourceContent.getElementTextDataJavaScript();
    protected static final String JS_ELEMENT_TEXT = ResourceContent.getElementTextJavaScript();
    protected static final String JS_ELEMENT_VALUE = ResourceContent.getElementValueJavaScript();
    protected static final String JS_ELEMENT_CHECKED = ResourceContent.getElementCheckedJavaScript();
    protected static final String JS_DOCUMENT_SIZE = ResourceContent.getDocumentSizeJavaScript();
    protected static final String JS_ELEMENT_HTML = ResourceContent.getElementKeysAndAttributesJavaScript();
    protected static final String JS_ELEMENT_FUNCTIONS = ResourceContent.getElementFunctionsJavaScript();
    protected Double initElementX = 0.0;
    protected Double initElementY = 0.0;
    protected Actions actions;
    private LinkedList<RemoteWebElement> shadowList;
    protected String searchElementScript = JS_SEARCH_ELEMENT;
    private Set<String> windowsHandleList = Collections.emptySet();
    private ArrayList<String> iframesDom;
    private WebElement iframe = null;
    private double offsetIframeX = 0.0;
    private double offsetIframeY = 0.0;

    public WebDriverEngine(Channel channel, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, int defaultWait, int defaultPropertyWait, boolean enableLearning) {
        super(channel, driverInfo, systemDriver, props, defaultWait, defaultPropertyWait, enableLearning);
    }

    public WebDriverEngine(Channel channel, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, boolean enableLearning) {
        this(channel, driverInfo, systemDriver, props, 150, 200, enableLearning);
    }

    public WebDriverEngine(Channel channel, SystemDriver desktopDriver, IDriverInfo driverInfo, String application, ApplicationProperties props, int defaultWait, int defaultCheck, boolean enableLearning) {
        super(channel, driverInfo, desktopDriver, props, defaultWait, defaultCheck, enableLearning);
    }

    protected boolean isHeadless() {
        return this.getDriverInfo().isHeadless();
    }

    private AtsRemoteWebDriver getRemoteDriver(ActionStatus status, Capabilities cap) {
        Object errorMessage = "";
        AtsRemoteWebDriver rwd = null;
        try {
            rwd = this.getDriverInfo().getAtsRemoteWebDriver(cap);
            return rwd;
        }
        catch (InvalidArgumentException ex0) {
            if (rwd != null) {
                rwd.close();
            }
            status.setTechnicalError(-19, "Unable to start remote driver:\n" + ex0.getMessage());
            return null;
        }
        catch (SessionNotCreatedException ex0) {
            rwd = null;
            this.channel.sleep(500);
            errorMessage = ex0.getMessage();
        }
        catch (UnsupportedCommandException ex1) {
            status.setTechnicalError(-19, "Unable to create Selenium remote session:\n" + ex1.getMessage());
            return null;
        }
        catch (Exception ex2) {
            if (rwd != null) {
                rwd.close();
            }
            this.channel.sleep(500);
            errorMessage = ex2.getMessage();
        }
        if (this.getDriverInfo().getDriverLoopback() != null) {
            try {
                return new AtsRemoteWebDriver(this.getDriverInfo().getDriverLoopback().toURL(), cap);
            }
            catch (Exception ex) {
                errorMessage = (String)errorMessage + "\n" + ex.getMessage();
            }
        }
        status.setTechnicalError(-19, "Unable to start remote driver:\n" + (String)errorMessage);
        return null;
    }

    protected void launchDriver(ActionStatus status, MutableCapabilities cap) {
        AtsManager ats = AtsSingleton.getInstance().getAts();
        int maxTrySearch = ats.getMaxTrySearch();
        int maxTryProperty = ats.getMaxTryProperty();
        int scriptTimeout = ats.getScriptTimeOut();
        int pageLoadTimeout = ats.getPageloadTimeOut();
        int watchdog = ats.getWatchDogTimeOut();
        cap.setCapability("pageLoadStrategy", (Object)PageLoadStrategy.NONE);
        this.driver = this.getRemoteDriver(status, (Capabilities)cap);
        if (this.driver == null) {
            this.getDriverInfo().close();
            this.driver = null;
            return;
        }
        status.setNoError();
        status.startDuration();
        this.actions = new Actions((WebDriver)this.driver);
        this.driver.manage().timeouts().scriptTimeout(Duration.ofSeconds(scriptTimeout));
        try {
            this.driver.manage().timeouts().pageLoadTimeout(Duration.ofSeconds(pageLoadTimeout));
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
        if (this.getDriverInfo().isGrid()) {
            this.driver.navigate().to("chrome://version/");
        } else {
            int maxTry;
            String applicationVersion = null;
            String driverVersion = this.getDriverInfo().getDriverVersion();
            String profileDir = "";
            Map infos = this.driver.getCapabilities().asMap();
            for (Map.Entry entry : infos.entrySet()) {
                if ("browserVersion".equals(entry.getKey()) || "version".equals(entry.getKey())) {
                    applicationVersion = entry.getValue().toString();
                    continue;
                }
                if ("chrome".equals(entry.getKey())) {
                    Map chromeData = (Map)entry.getValue();
                    driverVersion = this.getDriverVersion((String)chromeData.get("chromedriverVersion"));
                    profileDir = (String)chromeData.get("userDataDir");
                    continue;
                }
                if ("opera".equals(entry.getKey())) {
                    Map operaData = (Map)entry.getValue();
                    driverVersion = this.getDriverVersion((String)operaData.get("operadriverVersion"));
                    profileDir = (String)operaData.get("userDataDir");
                    continue;
                }
                if ("msedge".equals(entry.getKey())) {
                    Map msedgeData = (Map)entry.getValue();
                    driverVersion = this.getDriverVersion((String)msedgeData.get("msedgedriverVersion"));
                    profileDir = (String)msedgeData.get("userDataDir");
                    continue;
                }
                if ("moz:geckodriverVersion".equals(entry.getKey())) {
                    driverVersion = entry.getValue().toString();
                    continue;
                }
                if (!"moz:profile".equals(entry.getKey())) continue;
                profileDir = entry.getValue().toString();
            }
            String titleUid = UUID.randomUUID().toString();
            StringBuilder sb = this.getSystemDriver().getLocalhostAndPort().append("/start?tt=").append(titleUid).append("&av=").append(ATS.getAtsVersion()).append("&et=").append(maxTrySearch).append("&pt=").append(maxTryProperty).append("&js=").append(scriptTimeout).append("&to=").append(pageLoadTimeout).append("&wd=").append(watchdog).append("&dv=").append(driverVersion).append("&bn=").append(this.channel.getApplication()).append("&bv=").append(applicationVersion).append("&px=").append(this.channel.getDimension().getX().intValue()).append("&py=").append(this.channel.getDimension().getY().intValue()).append("&pw=").append(this.channel.getDimension().getWidth().intValue()).append("&ph=").append(this.channel.getDimension().getHeight().intValue()).append("&wa=").append(this.getActionWait()).append("&dc=").append(this.getPropertyWait()).append("&pd=").append(profileDir);
            String startUrl = sb.toString();
            this.driver.navigate().to(startUrl);
            String winTitle = this.driver.getTitle();
            for (maxTry = 30; maxTry > 0 && !titleUid.equals(winTitle); --maxTry) {
                this.channel.sleep(500);
                this.driver.navigate().to(startUrl);
                winTitle = this.driver.getTitle();
            }
            if (maxTry == 0) {
                status.setTechnicalError(-19, "Unable to start web channel driver:\ntimeout when loading start page");
            } else {
                String osVersion = this.getSystemDriver().getOsName() + " (" + this.getSystemDriver().getOsVersion() + ")";
                DesktopWindow window = this.getSystemDriver().getWindowByTitle(titleUid, this.getDriverInfo().getName());
                this.getSystemDriver().setEngine(new SystemDriverEngine(this.channel, window, this.isAtsLearningEnabled()));
                this.channel.setApplicationData("html", osVersion, applicationVersion, driverVersion, (long)window.getPid(), this.getBrowserIcon(window));
            }
        }
        this.getDriverInfo().setSessionId(this.driver.getSessionId().toString());
        Dimension channelSize = this.channel.getDimension().getSize();
        try {
            if (channelSize.getWidth() == -1 && channelSize.getWidth() == -1) {
                ArrayList screen = (ArrayList)this.runJavaScript("var result=[screen.width, screen.height]", new Object[0]);
                this.channel.setFullScreenSize((Long)screen.get(0), (Long)screen.get(1));
            }
            this.driver.setWindowSize(this.channel.getDimension().getSize());
            this.driver.setWindowPosition(this.channel.getDimension().getPoint());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.channel.setZoom((Double)this.runJavaScript("var result=window.devicePixelRatio/100", new Object[0]) * 10000.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] getBrowserIcon(DesktopWindow window) {
        try {
            return Resources.toByteArray((URL)ResourceContent.class.getResource("/icons/" + this.getDriverInfo().getName() + ".png"));
        }
        catch (Exception exception) {
            return window.getAppIcon();
        }
    }

    private String getDriverVersion(String value) {
        if (value != null) {
            return value.replaceFirst("\\(.*\\)", "").trim();
        }
        return null;
    }

    @Override
    public void waitAfterAction(ActionStatus status) {
        this.actionWait();
    }

    protected String[] getWindowsHandle(int index, int tries) {
        Set<String> list = this.getDriverWindowsList();
        for (int maxTry = 1 + tries; index >= list.size() && maxTry > 0; --maxTry) {
            this.channel.sleep(1000);
            list = this.getDriverWindowsList();
        }
        return list.toArray(new String[list.size()]);
    }

    protected Set<String> getDriverWindowsList() {
        this.getWindowsData();
        return this.windowsHandleList;
    }

    protected Set<String> getWindowsList() {
        try {
            return this.driver.getWindowHandles();
        }
        catch (WebDriverException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public void scroll(int delta) {
        this.runJavaScript(JS_WINDOW_SCROLL, delta);
    }

    @Override
    public void scroll(FoundElement element, int delta) {
        if (delta == 0) {
            this.scroll(element);
        } else {
            ArrayList newPosition = (ArrayList)this.runJavaScript(JS_ELEMENT_SCROLL, element.getValue(), delta);
            this.updatePosition(newPosition, element);
        }
    }

    @Override
    public void scroll(FoundElement element) {
        this.updatePosition((ArrayList)this.runJavaScript(this.JS_SCROLL_IF_NEEDED, element.getValue()), element);
    }

    private void updatePosition(ArrayList<Double> position, FoundElement element) {
        if (position != null && position.size() > 1) {
            element.updatePosition(position.get(0), position.get(1), this.channel, 0.0, 0.0);
            this.channel.sleep(500);
        }
    }

    @Override
    public List<FoundElement> findElementByXpath(String xpath) {
        WebElement element = this.driver.findElement(By.xpath((String)xpath));
        return Arrays.asList(new FoundElement(this.channel, element.getTagName(), (RemoteWebElement)element));
    }

    @Override
    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        if (syscomp.booleanValue()) {
            return this.getSystemDriver().getElementFromPoint(x, y);
        }
        this.switchToDefaultContent(false);
        x = x - this.channel.getSubDimension().getX();
        y = y - this.channel.getSubDimension().getY();
        this.shadowList = new LinkedList();
        return this.loadElement(new ArrayList<AtsElement>(), null, x, y, this.initElementX, this.initElementY);
    }

    protected FoundElement loadElement(ArrayList<AtsElement> iframes, RemoteWebElement shadowRoot, Double x, Double y, Double offsetX, Double offsetY) {
        Object obj = this.runJavaScript(this.JS_ELEMENT_FROM_POINT, shadowRoot, x - offsetX, y - offsetY);
        ArrayList objectData = (ArrayList)obj;
        if (objectData != null) {
            AtsElement element = new AtsElement(this, objectData, false);
            if (element.isIframe()) {
                iframes.add(0, element);
                this.switchToFrame((WebElement)element.getElement());
                offsetX = offsetX + element.getX();
                offsetY = offsetY + element.getY();
                return this.loadElement(iframes, null, x, y, offsetX, offsetY);
            }
            if (element.isShadowRoot()) {
                this.shadowList.add(0, element.getElement());
                return this.loadElement(iframes, element.getElement(), x, y, 0.0, 0.0);
            }
            return new FoundElement(element, iframes, this.channel, offsetX, offsetY);
        }
        return null;
    }

    private FoundElement getShadowElements(ArrayList<AtsElement> iframes, RemoteWebElement element, Double x, Double y, Double w, Double h) {
        this.shadowList.add(0, element);
        return this.loadElement(iframes, element, x, y, w, h, 0.0, 0.0);
    }

    @Override
    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        if (syscomp.booleanValue()) {
            return this.getSystemDriver().getElementFromRect(x, y, w, y);
        }
        this.switchToDefaultContent(false);
        x = x - this.channel.getSubDimension().getX() - this.channel.getDimension().getX();
        y = y - this.channel.getSubDimension().getY() - this.channel.getDimension().getY();
        return this.loadElement(new ArrayList<AtsElement>(), null, x, y, w, h, this.initElementX, this.initElementY);
    }

    private FoundElement loadElement(ArrayList<AtsElement> iframes, RemoteWebElement shadow, Double x, Double y, Double w, Double h, Double offsetX, Double offsetY) {
        ArrayList objectData = (ArrayList)this.runJavaScript(JS_ELEMENT_FROM_RECT, shadow, x - offsetX, y - offsetY, w, h);
        if (objectData != null) {
            AtsElement element = new AtsElement(this, objectData, false);
            if (element.isIframe()) {
                iframes.add(0, element);
                this.switchToFrame((WebElement)element.getElement());
                offsetX = offsetX + element.getX();
                offsetY = offsetY + element.getY();
                return this.loadElement(iframes, shadow, x, y, w, h, offsetX, offsetY);
            }
            if (element.isShadowRoot()) {
                return this.getShadowElements(iframes, element.getElement(), x, y, w, h);
            }
            return new FoundElement(element, iframes, this.channel, offsetX, offsetY);
        }
        return null;
    }

    @Override
    public void loadParents(FoundElement hoverElement) {
        if (hoverElement.isDesktop()) {
            hoverElement.setParent(this.getSystemDriver().getTestElementParent(hoverElement.getId(), this.channel));
        } else {
            hoverElement.setParent(this.getTestElementParent(hoverElement));
        }
    }

    @Override
    public String getParentsDomCode(WebElement element) {
        StringBuilder html = new StringBuilder();
        StringBuilder closeHtml = new StringBuilder();
        while (this.iframesDom != null && this.iframesDom.size() > 0) {
            String iframeDom = this.iframesDom.remove(this.iframesDom.size() - 1);
            int lastIndex = iframeDom.indexOf("</iframe>");
            if (lastIndex <= -1) continue;
            html.append(iframeDom.substring(0, lastIndex));
            closeHtml.append(iframeDom.substring(lastIndex));
        }
        return html.append((String)this.runJavaScript(this.JS_ELEMENT_PARENTS_HTML, element)).append((CharSequence)closeHtml).toString();
    }

    @Override
    public WebElement getRootElement(Channel cnl) {
        WebElement body = this.getHtmlView();
        for (int maxTry = 20; body == null && maxTry > 0; --maxTry) {
            cnl.sleep(200);
            body = this.getHtmlView();
        }
        return body;
    }

    @Override
    public String getCookies() {
        StringJoiner joiner = new StringJoiner("\n");
        for (Cookie cookie : this.driver.manage().getCookies()) {
            joiner.add(cookie.getName() + "=" + cookie.getValue());
        }
        return joiner.toString();
    }

    @Override
    public String getHeaders(ActionStatus status) {
        try {
            Object obj = this.driver.executeScript("var req = new XMLHttpRequest();req.open('HEAD', document.location, false);req.send(null);var result = req.getAllResponseHeaders();delete req;return result;", new Object[0]);
            return obj.toString();
        }
        catch (InvalidSelectorException e) {
            status.setError(-13, e.getStackTrace().toString());
        }
        catch (Exception e) {
            status.setError(-13, e.getMessage());
        }
        return "";
    }

    private WebElement getHtmlView() {
        return (WebElement)this.driver.executeScript("return window.document.getElementsByTagName(\"html\")[0];", new Object[0]);
    }

    protected RemoteWebElement getWebElement(FoundElement element) {
        return element.getRemoteWebElement(this.driver);
    }

    @Override
    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        String result = this.getAttribute(status, element, attributeName);
        if (result != null && this.doubleCheckAttribute(status, result, element, attributeName)) {
            return result;
        }
        return null;
    }

    @Override
    public List<String[]> loadSelectOptions(TestElement element) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (element.isAngularSelect()) {
            element.getWebElement().sendKeys(new CharSequence[]{Keys.TAB});
            element.click(this.channel.newActionStatus(), new MouseDirection());
            List<FoundElement> options = this.findMatSelectOptions(element);
            if (options != null && options.size() > 0) {
                options.stream().forEachOrdered(e -> result.add(new String[]{e.getValue().getText(), e.getValue().getText()}));
            }
        } else {
            List<FoundElement> options = this.findSelectOptions(null, element);
            if (options != null && options.size() > 0) {
                options.stream().forEachOrdered(e -> result.add(new String[]{e.getValue().getDomAttribute("value"), e.getValue().getDomProperty("text")}));
            }
        }
        return result;
    }

    @Override
    public List<FoundElement> findSelectOptions(TestBound dimension, TestElement element) {
        return this.listElementsFound(this.runJavaScript(this.searchElementScript, element.getWebElement(), "OPTION", new String[0], 0), Objects::nonNull, false);
    }

    public List<FoundElement> findMatSelectOptions(TestElement element) {
        this.switchToDefaultContent(false);
        return this.findElements(false, element, ANGULAR_OPTION, new String[0], new String[0], Objects::nonNull, null);
    }

    @Override
    public void selectOptionsItem(ActionStatus status, TestElement element, CalculatedProperty selectProperty, boolean keepSelect) {
        block34: {
            if (element.isAngularSelect()) {
                element.getWebElement().sendKeys(new CharSequence[]{Keys.TAB});
                element.click(status, new MouseDirection());
                List<FoundElement> items = this.findMatSelectOptions(element);
                if (items != null && items.size() > 0) {
                    if ("index".equals(selectProperty.getName())) {
                        int index = Utils.string2Int(selectProperty.getValue().getCalculated());
                        if (items.size() > index) {
                            try {
                                items.get(index).getValue().click();
                            }
                            catch (Exception e2) {
                                status.setError(-3, e2.getMessage());
                            }
                        } else {
                            status.setError(-3, "index not found, max length options: " + items.size());
                        }
                    } else {
                        String searchedValue = selectProperty.getValue().getCalculated();
                        try {
                            if (selectProperty.isRegexp()) {
                                items.stream().filter(e -> e.getValue().getText().matches(searchedValue)).findFirst().get().getValue().click();
                                break block34;
                            }
                            items.stream().filter(e -> e.getValue().getText().equals(searchedValue)).findFirst().get().getValue().click();
                        }
                        catch (NoSuchElementException e3) {
                            status.setError(-3, "mat-option not found: " + searchedValue);
                        }
                    }
                }
            } else {
                List<FoundElement> items = this.findSelectOptions(null, element);
                if (items != null && items.size() > 0) {
                    boolean expanded;
                    block35: {
                        expanded = false;
                        WebElement webElem = element.getFoundElement().getValue();
                        String tagName = this.getElementTag(webElem);
                        if (!"SELECT".equalsIgnoreCase(tagName)) {
                            status.setError(-26, "element is not a 'select' element: " + tagName);
                            return;
                        }
                        Select select = new Select(webElem);
                        if (select.isMultiple()) {
                            if (!keepSelect) {
                                select.deselectAll();
                            }
                        } else {
                            expanded = true;
                            element.click(status, new MouseDirection());
                        }
                        if ("index".equals(selectProperty.getName())) {
                            int index = 0;
                            String calculated = selectProperty.getValue().getCalculated();
                            try {
                                index = Integer.parseInt(calculated);
                            }
                            catch (NumberFormatException e4) {
                                this.channel.sendWarningLog("select using index", "'" + calculated + "' cannot be parsed as integer, using default value 0");
                            }
                            if (items.size() > index) {
                                try {
                                    items.get(index).getValue().click();
                                }
                                catch (Exception e5) {
                                    WebElement we = items.get(index).getValue();
                                    tagName = this.getElementTag(we);
                                    if ("OPTION".equalsIgnoreCase(tagName)) {
                                        we = we.findElement(By.xpath((String)"./.."));
                                    }
                                    if ("SELECT".equalsIgnoreCase(tagName = this.getElementTag(we))) {
                                        new Select(we).selectByIndex(index);
                                        break block35;
                                    }
                                    status.setError(-26, "element is not a 'select' element: " + tagName);
                                }
                            } else {
                                status.setError(-3, "index not found, max length options: " + items.size());
                            }
                        } else {
                            String attribute = selectProperty.getName();
                            String searchedValue = selectProperty.getValue().getCalculated();
                            Optional<FoundElement> foundOption = null;
                            foundOption = selectProperty.isRegexp() ? items.stream().filter(e -> e.getDomAttributeOrProperty(attribute).matches(searchedValue)).findFirst() : items.stream().filter(e -> e.getDomAttributeOrProperty(attribute).equals(searchedValue)).findFirst();
                            if (foundOption.isEmpty()) {
                                status.setError(-1, "option not found: " + searchedValue);
                            } else {
                                try {
                                    foundOption.get().getValue().click();
                                }
                                catch (NoSuchElementException e6) {
                                    status.setError(-3, "option not found: " + searchedValue);
                                }
                            }
                        }
                    }
                    if (expanded) {
                        try {
                            this.driver.executeScript("arguments[0].blur();", new Object[]{element.getWebElement()});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private boolean doubleCheckAttribute(ActionStatus status, String verify, FoundElement element, String attributeName) {
        this.channel.sleep(this.getPropertyWait());
        String current = this.getAttribute(status, element, attributeName);
        return current != null && current.equals(verify);
    }

    @Override
    public void setSysProperty(String propertyName, String propertyValue) {
    }

    private String getAttribute(ActionStatus status, FoundElement element, String attributeName) {
        RemoteWebElement elem = this.getWebElement(element);
        String result = null;
        if ("text".equals(attributeName)) {
            result = this.getSpecialAttribute(JS_ELEMENT_TEXT, elem);
        } else if ("value".equals(attributeName)) {
            result = this.getSpecialAttribute(JS_ELEMENT_VALUE, elem);
        } else if ("checked".equals(attributeName)) {
            if ("input".equals(elem.getTagName().toLowerCase())) {
                result = this.getSpecialAttribute(JS_ELEMENT_CHECKED, elem);
            }
        } else {
            Object obj;
            result = elem.getDomAttribute(attributeName);
            if (result == null && (result = elem.getDomProperty(attributeName)) == null && (result = this.getCssAttributeValueByName(element, attributeName)) == null && (obj = this.executeJavaScript(status, attributeName, true)) != null) {
                result = obj.toString();
            }
        }
        return result;
    }

    private String getSpecialAttribute(String jsCode, RemoteWebElement element) {
        Object obj = this.runJavaScript(jsCode, element);
        if (obj != null) {
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof Boolean) {
                return ((Boolean)obj).toString();
            }
            return "";
        }
        return null;
    }

    private String getCssAttributeValueByName(FoundElement element, String name) {
        return this.foundAttributeValue(name, this.getCssAttributes(element));
    }

    private String foundAttributeValue(String name, CalculatedProperty[] properties) {
        Stream<CalculatedProperty> stream = Arrays.stream(properties);
        Optional<CalculatedProperty> calc = ((Stream)stream.parallel()).filter(c -> c.getName().equals(name)).findFirst();
        if (calc.isPresent()) {
            return calc.get().getValue().getCalculated();
        }
        return null;
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        if (element.isDesktop()) {
            return this.getSystemDriver().getElementAttributes(element.getId());
        }
        return this.getAttributes(this.getWebElement(element));
    }

    @Override
    public String getTextData(FoundElement element) {
        if (element.isDesktop()) {
            return this.getSystemDriver().getTextData(element.getId());
        }
        Object result = this.runJavaScript(JS_ELEMENT_TEXT_DATA, this.getWebElement(element));
        if (result != null && result instanceof String) {
            return result.toString();
        }
        return "";
    }

    @Override
    public String getSelectedText(TestElement element) {
        List<FoundElement> items = null;
        items = element.isAngularSelect() ? this.findMatSelectOptions(element) : this.findSelectOptions(null, element);
        StringJoiner sj = new StringJoiner("|");
        items.stream().filter(e -> e.isSelected()).forEach(e -> sj.add(e.getTextContent()));
        return sj.toString();
    }

    @Override
    public CalculatedProperty[] getCssAttributes(FoundElement element) {
        return this.getCssAttributes(this.getWebElement(element));
    }

    @Override
    public CalculatedProperty[] getHtmlAttributes(FoundElement element) {
        return this.getHtmlAttributes(this.getWebElement(element));
    }

    @Override
    public CalculatedProperty[] getFunctions(FoundElement element) {
        Object result = this.runJavaScript(JS_ELEMENT_FUNCTIONS, this.getWebElement(element));
        if (result != null && result instanceof Map) {
            return (CalculatedProperty[])((Stream)((Map)result).entrySet().stream().parallel()).filter(e -> !(e.getValue() instanceof Map)).map(e -> new CalculatedProperty((String)e.getKey(), this.getFunctionSignature((Long)e.getValue()))).toArray(CalculatedProperty[]::new);
        }
        return new CalculatedProperty[0];
    }

    private String getFunctionSignature(long length) {
        StringJoiner sj = new StringJoiner(", ");
        int i = 0;
        while ((long)i < length) {
            sj.add("'param" + i + "'");
            ++i;
        }
        return sj.toString();
    }

    private CalculatedProperty[] getCssAttributes(RemoteWebElement element) {
        return this.getAttributesList(element, JS_ELEMENT_CSS);
    }

    private CalculatedProperty[] getHtmlAttributes(RemoteWebElement element) {
        Object result = this.runJavaScript(JS_ELEMENT_HTML, element);
        if (result != null && result instanceof ArrayList) {
            ArrayList props = new ArrayList();
            ((ArrayList)result).forEach(s -> this.addProperty(props, (String)s, element));
            return props.toArray(new CalculatedProperty[props.size()]);
        }
        return new CalculatedProperty[0];
    }

    private void addProperty(ArrayList<CalculatedProperty> props, String attribute, RemoteWebElement element) {
        String attributeValue = element.getDomAttribute(attribute);
        if (attributeValue == null) {
            attributeValue = element.getDomProperty(attribute);
        }
        props.add(new CalculatedProperty(attribute, attributeValue));
    }

    protected CalculatedProperty[] getAttributes(RemoteWebElement element) {
        return this.getAttributesList(element, JS_ELEMENT_ATTRIBUTES);
    }

    private CalculatedProperty[] getAttributesList(RemoteWebElement element, String script) {
        Object result = this.runJavaScript(script, element);
        if (result != null && result instanceof Map) {
            return (CalculatedProperty[])((Stream)((Map)result).entrySet().stream().parallel()).filter(e -> !(e.getValue() instanceof Map)).map(e -> new CalculatedProperty((String)e.getKey(), e.getValue().toString())).toArray(CalculatedProperty[]::new);
        }
        return new CalculatedProperty[0];
    }

    public FoundElement getTestElementParent(FoundElement element) {
        ArrayList listElements = (ArrayList)this.runJavaScript(this.JS_ELEMENT_PARENTS, element.getValue());
        FoundElement found = null;
        if (listElements != null && listElements.size() > 0) {
            found = new FoundElement(this.channel, element.getIframes(), listElements.stream().map(e -> new AtsElement(this, (List<Object>)e, false)).collect(Collectors.toCollection(ArrayList::new)), this.initElementX, this.initElementY);
        }
        if (this.shadowList != null && this.shadowList.size() > 0) {
            this.switchToDefaultContent(false);
            FoundElement shadow = new FoundElement(this, this.shadowList.pop());
            while (this.shadowList.size() > 0) {
                shadow.addShadowParent(new FoundElement(this, this.shadowList.pop()));
            }
            if (found == null) {
                found = shadow;
            } else {
                found.addShadowParent(shadow);
            }
        }
        return found;
    }

    @Override
    public void updateDimensions() {
        ArrayList response = (ArrayList)this.runJavaScript(JS_DOCUMENT_SIZE, new Object[0]);
        if (response != null && response.size() == 8) {
            if (this.isHeadless()) {
                this.channel.getDimension().update((Double)response.get(4), (Double)response.get(5), (Double)response.get(6), (Double)response.get(7));
            } else {
                this.channel.getDimension().update((Double)response.get(0), (Double)response.get(1), (Double)response.get(2), (Double)response.get(3));
            }
            this.channel.getSubDimension().update((Double)response.get(4), (Double)response.get(5), (Double)response.get(6), (Double)response.get(7));
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isHeadless() && this.channel.isDesktopDriverEnabled()) {
            this.getSystemDriver().closeDialogBoxes(this.channel.getProcessId());
        }
        this.closeWindows();
        this.getDriverInfo().close();
    }

    @Override
    public void quit() {
    }

    protected void closeWindows() {
        this.channel.sendLog(51, "close web browser", this.channel.getApplication());
        if (this.driver != null) {
            List wins = this.driver.getWindowHandles().stream().collect(Collectors.toList());
            while (wins.size() > 0) {
                this.closeWindowHandler((String)wins.removeLast());
            }
            this.driver = null;
        }
    }

    @Override
    protected double getCartesianOffset(double value, MouseDirectionData direction, Cartesian cart1, Cartesian cart2, Cartesian cart3) {
        return super.getCartesianOffset(value, direction, cart1, cart2, cart3) - value / 2.0;
    }

    @Override
    public void mouseMoveToElement(FoundElement element) {
        try {
            this.move(element, 0.0, 0.0);
        }
        catch (ElementNotInteractableException e0) {
            throw e0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position, boolean withDesktop, int offsetX, int offsetY) {
        this.channel.waitBeforeMouseMoveToElement(this);
        if (withDesktop) {
            this.desktopMoveToElement(foundElement, position, offsetX, offsetY);
        } else {
            int maxTry = 10;
            while (maxTry > 0) {
                status.setNoError();
                try {
                    this.scrollAndMove(foundElement, position, offsetX, offsetY);
                    maxTry = 0;
                }
                catch (StaleElementReferenceException e0) {
                    throw e0;
                }
                catch (JavascriptException e1) {
                    this.switchToDefaultContent(false);
                    status.setException(-13, (Exception)((Object)e1));
                    throw e1;
                }
                catch (MoveTargetOutOfBoundsException e2) {
                    this.driver.executeScript("arguments[0].scrollIntoView();", new Object[]{foundElement.getValue()});
                    maxTry = 0;
                }
                catch (ElementNotInteractableException e5) {
                    maxTry = 0;
                    throw e5;
                }
                catch (WebDriverException e3) {
                    status.setException(-16, (Exception)((Object)e3));
                    this.channel.sleep(500);
                    --maxTry;
                }
            }
        }
    }

    private void scrollAndMove(FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.scroll(element);
        this.channel.sleep(100);
        Rectangle rect = element.getRectangle();
        this.move(element, (int)this.getOffsetX(rect, position) + offsetX, (int)this.getOffsetY(rect, position) + offsetY);
    }

    protected void move(FoundElement element, double offsetX, double offsetY) {
        block2: {
            try {
                this.actions.moveToElement(element.getValue(), (int)offsetX, (int)offsetY).perform();
            }
            catch (JavascriptException e) {
                if (e.getMessage().contains("elementsFromPoint")) break block2;
                throw e;
            }
        }
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        Rectangle rect = element.getRectangle();
        try {
            this.click(element, this.getOffsetX(rect, position) + (double)offsetX, this.getOffsetY(rect, position) + (double)offsetY);
            status.setPassed(true);
        }
        catch (StaleElementReferenceException e1) {
            throw e1;
        }
        catch (MoveTargetOutOfBoundsException e) {
            this.driver.executeScript("arguments[0].click();", new Object[]{element.getValue()});
        }
        catch (Exception e) {
            status.setException(-3, e);
        }
    }

    protected void click(FoundElement element, double offsetX, double offsetY) {
        this.actions.moveToElement(element.getValue(), (int)offsetX, (int)offsetY).click().build().perform();
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY, boolean offset) {
        Rectangle rect = element.getRectangle();
        try {
            Actions a = this.actions.moveToElement(element.getValue(), (int)this.getOffsetX(rect, position) + offsetX, (int)this.getOffsetY(rect, position) + offsetY).pause(Duration.ofMillis(200L)).clickAndHold(element.getValue()).pause(Duration.ofMillis(200L));
            if (offset) {
                a.moveByOffset(20, -20).pause(Duration.ofMillis(200L));
            }
            a.build().perform();
            status.setPassed(true);
        }
        catch (StaleElementReferenceException e1) {
            throw e1;
        }
        catch (Exception e) {
            status.setException(-3, e);
        }
    }

    @Override
    public void drop(FoundElement element, MouseDirection md, boolean desktopDragDrop) {
        if (desktopDragDrop) {
            this.getSystemDriver().mouseRelease();
        } else {
            this.actions.moveToElement(element.getValue()).pause(Duration.ofMillis(200L)).release(element.getValue()).build().perform();
            this.actions.release().perform();
            this.actions.moveToElement(element.getValue()).perform();
        }
    }

    @Override
    public void swipe(ActionStatus status, FoundElement element, MouseDirection position, MouseDirection direction) {
        this.drag(status, element, position, 0, 0, false);
        this.moveByOffset(direction.getHorizontalDirection(), direction.getVerticalDirection());
        this.actions.release().perform();
    }

    @Override
    public void keyDown(Keys key) {
        this.actions.keyDown((CharSequence)key).perform();
    }

    @Override
    public void keyUp(Keys key) {
        this.actions.keyUp((CharSequence)key).perform();
    }

    @Override
    public void moveByOffset(int hDirection, int vDirection) {
        this.actions.moveByOffset(hDirection, vDirection).perform();
    }

    @Override
    public void doubleClick() {
        this.actions.doubleClick().perform();
    }

    @Override
    public void rightClick() {
        this.actions.contextClick().perform();
    }

    @Override
    public boolean switchToDefaultContent(boolean dialog) {
        if (this.driver != null) {
            if (dialog) {
                try {
                    this.driver.switchTo().alert();
                    return true;
                }
                catch (NoAlertPresentException | NoSuchWindowException throwable) {
                    // empty catch block
                }
            }
            try {
                this.driver.switchTo().defaultContent();
                return true;
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void switchToFrameId(String id) {
        RemoteWebElement rwe = new RemoteWebElement();
        rwe.setId(id);
        rwe.setParent((RemoteWebDriver)this.driver);
        this.switchToFrame((WebElement)rwe);
    }

    protected void switchToFrame(WebElement we) {
        this.driver.switchTo().frame(we);
    }

    @Override
    public List<String[]> getWindowsData() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        this.windowsHandleList = new LinkedHashSet<String>();
        String currentWin = this.driver.getWindowHandle();
        for (String handle : this.getWindowsList()) {
            this.driver.switchTo().window(handle);
            if (this.driver.getCurrentUrl().startsWith("chrome-extension://")) continue;
            list.add(new String[]{this.getTitle(), this.driver.getCurrentUrl()});
            this.windowsHandleList.add(handle);
        }
        this.driver.switchTo().window(currentWin);
        return ImmutableList.copyOf(list);
    }

    protected boolean switchToWindowHandle(String handle) {
        try {
            this.driver.switchTo().window(handle);
            this.channel.sleep(500);
            return this.switchToDefaultContent(false);
        }
        catch (NoSuchWindowException ex) {
            return false;
        }
    }

    protected void switchToWindowIndex(String[] wins, int index, boolean refresh) {
        int maxTry = 10;
        boolean switched = this.switchToWindowHandle(wins[index]);
        while (!switched && maxTry > 0) {
            this.channel.sleep(1000);
            wins = this.getWindowsHandle(index, 0);
            switched = this.switchToWindowHandle(wins[index]);
        }
        if (switched && refresh) {
            this.channel.sleep(300);
            this.driver.navigate().refresh();
        }
    }

    @Override
    public String getTitle() {
        String title = this.driver.getTitle();
        if (title == null || title.isBlank()) {
            String url = this.driver.getCurrentUrl();
            this.driver.executeScript("document.title='" + url + "'", new Object[0]);
        }
        return this.driver.getTitle();
    }

    @Override
    public void setWindowToFront() {
        if (!this.isHeadless() && this.channel.isDesktopDriverEnabled()) {
            this.channel.toFront();
        }
    }

    @Override
    public void newWindow(ActionStatus status, WindowType type, CalculatedValue url) {
        this.driver.switchTo().newWindow(type);
        this.switchToWindowHandler(status, this.driver.getWindowHandle(), false);
        if (url != null && !url.getCalculated().isBlank()) {
            this.goToUrl(status, url.getCalculated());
        }
    }

    private boolean switchToWindowHandler(ActionStatus status, String handler, boolean refresh) {
        try {
            this.driver.switchTo().window(handler);
            if (refresh) {
                this.channel.sleep(300);
                this.driver.navigate().refresh();
            }
            this.getSystemDriver().updateWindowHandle(this.channel);
            status.setNoError();
            return true;
        }
        catch (Exception e) {
            status.setError(-16, e.getMessage());
            return false;
        }
    }

    @Override
    public boolean switchWindow(ActionStatus status, String type, String data, boolean regexp, boolean refresh) {
        this.channel.waitBeforeSwitchWindow(this);
        List wins = this.driver.getWindowHandles().stream().collect(Collectors.toList());
        String handleFound = null;
        String handleCurrent = null;
        try {
            handleCurrent = this.driver.getWindowHandle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("index".equals(type)) {
            int idx = Utils.string2Int(data);
            if (wins.size() > 0) {
                if (idx == -1) {
                    handleFound = (String)wins.getLast();
                } else {
                    if (idx >= wins.size()) {
                        status.setError(-15, "cannot switch to window index '" + idx + "', only " + wins.size() + " window(s) found");
                        return false;
                    }
                    handleFound = (String)wins.get(idx);
                }
            }
        } else {
            Pattern pattern = Pattern.compile(data, 2);
            if ("name".equals(type)) {
                if (regexp) {
                    for (String handle : wins) {
                        this.driver.switchTo().window(handle);
                        Matcher matcher = pattern.matcher(this.getTitle());
                        if (!matcher.find()) continue;
                        handleFound = handle;
                        break;
                    }
                } else {
                    for (String handle : wins) {
                        this.driver.switchTo().window(handle);
                        String title = this.getTitle();
                        if (!title.equals(data)) continue;
                        handleFound = handle;
                        break;
                    }
                }
            } else if ("url".equals(type)) {
                if (regexp) {
                    for (String handle : wins) {
                        this.driver.switchTo().window(handle);
                        Matcher matcher = pattern.matcher(this.driver.getCurrentUrl());
                        if (!matcher.find()) continue;
                        handleFound = handle;
                        break;
                    }
                } else {
                    for (String handle : wins) {
                        this.driver.switchTo().window(handle);
                        if (!this.driver.getCurrentUrl().equals(data)) continue;
                        handleFound = handle;
                        break;
                    }
                }
            }
        }
        if (handleFound != null) {
            if (handleCurrent != null) {
                this.driver.switchTo().window(handleCurrent);
            }
            return this.switchToWindowHandler(status, handleFound, refresh);
        }
        status.setError(-14, "cannot switch to window with title or name matching '" + data + "'");
        return false;
    }

    @Override
    public void resetToDefaultWindow() {
        try {
            List wins = this.driver.getWindowHandles().stream().collect(Collectors.toList());
            if (wins.size() > 0) {
                this.driver.switchTo().window((String)wins.get(0));
                this.driver.switchTo().defaultContent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean switchWindow(ActionStatus status, int index, int tries, boolean refresh) {
        this.channel.waitBeforeSwitchWindow(this);
        if (index >= 0) {
            String[] wins = this.getWindowsHandle(index, tries);
            if (wins.length > index) {
                this.switchToWindowIndex(wins, index, refresh);
                this.channel.cleanHandle();
                this.getSystemDriver().updateWindowHandle(this.channel);
            } else {
                status.setError(-14, "cannot switch to window index '" + index + "', only " + wins.length + " window(s) found");
            }
        }
        return true;
    }

    @Override
    protected void setPosition(com.ats.data.Point pt) {
        this.channel.sleep(500);
        this.driver.setWindowPosition(pt);
    }

    @Override
    protected void setSize(Dimension dim) {
        this.channel.sleep(500);
        this.driver.setWindowSize(dim);
    }

    protected void closeWindowHandler(String windowHandle) {
        this.switchToWindowHandle(windowHandle);
        try {
            Alert alert = this.driver.switchTo().alert();
            alert.dismiss();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeCurrentWindow();
    }

    protected void closeCurrentWindow() {
        try {
            this.driver.close();
            this.channel.sleep(200);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void closeWindow(ActionStatus status) {
        Set wins = this.driver.getWindowHandles();
        if (wins.size() > 1) {
            String currentWin = this.driver.getWindowHandle();
            wins.removeIf(s -> s.equals(currentWin));
            this.closeCurrentWindow();
            this.channel.setWinHandle(-1);
            wins = this.driver.getWindowHandles();
            if (wins.size() > 0) {
                this.driver.switchTo().window((String)wins.iterator().next());
            }
        } else {
            this.channel.setType(LAST_WINDOW);
            AtsSingleton.getInstance().closeChannel(status, this.channel.getName());
        }
    }

    @Override
    public String getCurrentHandle() {
        return this.driver.getWindowHandle();
    }

    @Override
    public Object executeScript(ActionStatus status, String javaScript, Object ... params) {
        Object result = this.runJavaScript(status, "var result={};" + javaScript + ";", params);
        if (status.isPassed() && result != null) {
            status.setMessage(result.toString());
        }
        return result;
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String javaScript, boolean returnValue) {
        try {
            if (returnValue) {
                Object result = this.driver.executeAsyncScript("var callback=arguments[arguments.length-1];var result=" + javaScript + ";callback(result);", new Object[0]);
                status.setMessage(result.toString());
                return result;
            }
            this.driver.executeScript(javaScript, new Object[0]);
            status.setPassed(true);
        }
        catch (StaleElementReferenceException e0) {
            throw e0;
        }
        catch (Exception e1) {
            status.setException(-13, e1);
        }
        return null;
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String javaScript, TestElement element) {
        return this.executeJavaScript(status, javaScript, element.getWebElement());
    }

    public Object executeJavaScript(ActionStatus status, String javaScript, WebElement element) {
        Object result = this.runJavaScript(status, "var e=arguments[0];var result=e." + javaScript.replaceAll("this", "e") + ";", element);
        if (status.isPassed() && result != null) {
            status.setMessage(result.toString());
        }
        return result;
    }

    public Object runJavaScript(String javaScript, Object ... params) {
        return this.runJavaScript(this.channel.newActionStatus(), javaScript, params);
    }

    public Object runJavaScriptResult(String javaScript) {
        try {
            return this.driver.executeAsyncScript("var result=" + javaScript + ";arguments[arguments.length-1](result);", new Object[0]);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    protected Object runJavaScript(ActionStatus status, String javaScript, Object ... params) {
        status.setPassed(true);
        try {
            return this.driver.executeAsyncScript(javaScript + ";arguments[arguments.length-1](result);", params);
        }
        catch (StaleElementReferenceException e0) {
            status.setPassed(false);
            throw e0;
        }
        catch (JavascriptException e1) {
            if (!e1.getMessage().contains("document unloaded while waiting for result")) {
                status.setException(-13, (Exception)((Object)e1));
            }
        }
        catch (Exception e2) {
            status.setException(-13, e2);
        }
        return null;
    }

    public List<Double> getBoundingClientRect(RemoteWebElement element) {
        try {
            return (List)this.driver.executeAsyncScript("var callback=arguments[arguments.length-1], rect=arguments[0].getBoundingClientRect();var result=[rect.x+0.0001, rect.y+0.0001, rect.width+0.0001, rect.height+0.0001];callback(result);", new Object[]{element});
        }
        catch (Exception e) {
            return List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.0), Double.valueOf(1.0));
        }
    }

    private String getTagName(WebElement element) {
        try {
            return element.getTagName();
        }
        catch (UnreachableBrowserException e) {
            this.channel.sleep(200);
            return null;
        }
    }

    public String getElementTag(WebElement element) {
        String tagName = this.getTagName(element);
        for (int maxTry = 10; tagName == null && maxTry > 0; --maxTry) {
            tagName = this.getTagName(element);
        }
        return tagName;
    }

    @Override
    public String getColName(WebElement element) {
        String tagName = this.getElementTag(element);
        if ("TD".equalsIgnoreCase(tagName)) {
            WebElement td;
            WebElement parent = element.findElement(By.xpath((String)"./.."));
            int index = 0;
            List nestedElements = parent.findElements(By.tagName((String)"TD"));
            Iterator iterator = nestedElements.iterator();
            while (iterator.hasNext() && !(td = (WebElement)iterator.next()).equals((Object)element)) {
                ++index;
            }
            while (parent != null) {
                if ("TABLE".equalsIgnoreCase(parent.getTagName())) {
                    List list = parent.findElements(By.tagName((String)"TH"));
                    if (list.size() <= index) break;
                    WebElement header = (WebElement)list.get(index);
                    return header.getDomProperty("innerText");
                }
                parent = parent.findElement(By.xpath((String)"./.."));
            }
        }
        return null;
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
        this.channel.waitBeforeGotoUrl(this);
        if ("refresh".equals(url)) {
            this.driver.navigate().refresh();
        } else if ("next".equals(url)) {
            this.driver.navigate().forward();
        } else if ("back".equals(url)) {
            this.driver.navigate().back();
        } else {
            this.switchToDefaultContent(false);
            if (!(((String)url).contains("://") || ((String)url).startsWith("https://") || ((String)url).startsWith("http://") || ((String)url).startsWith("file://"))) {
                url = "http://" + (String)url;
            }
            this.loadUrl(status, (String)url);
        }
        status.setPassed(true);
        status.setData(url);
        this.actionWait();
    }

    protected void loadUrl(ActionStatus status, String url) {
        if (this.driver == null) {
            status.setError(-11, "driver is null ! (channel may be closed)");
        } else {
            this.driver.get(url);
        }
    }

    @Override
    public List<FoundElement> findElements(boolean sysComp, TestElement testObject, String tagName, String[] attributes, String[] attributesValues, Predicate<AtsBaseElement> predicate, WebElement startElement) {
        String script = this.searchElementScript;
        this.iframesDom = new ArrayList();
        if (testObject.getParent() != null) {
            if (testObject.getParent().isIframe()) {
                this.iframe = testObject.getParent().getWebElement();
                if (this.isAtsLearningEnabled()) {
                    this.iframesDom.add((String)this.runJavaScript(this.JS_ELEMENT_PARENTS_HTML, this.iframe));
                }
                try {
                    Point pt = this.iframe.getLocation();
                    this.offsetIframeX += (double)pt.getX();
                    this.offsetIframeY += (double)pt.getY();
                    this.switchToFrame(this.iframe);
                }
                catch (WebDriverException e) {
                    return Collections.emptyList();
                }
            } else if (testObject.getParent().isShadowRoot()) {
                script = JS_SEARCH_SHADOW_ELEMENT;
                startElement = testObject.getParent().getWebElement();
            } else if (startElement == null) {
                startElement = testObject.getParent().getWebElement();
            }
        } else {
            if (this.iframe != null) {
                this.iframe = null;
                this.offsetIframeX = 0.0;
                this.offsetIframeY = 0.0;
            }
            if (!this.switchToDefaultContent(false)) {
                return Collections.emptyList();
            }
        }
        this.channel.waitBeforeSearchElement(this);
        return this.listElementsFound(this.runJavaScript(script, startElement, tagName, attributes, attributes.length), predicate, Arrays.asList(attributes).contains("-ats-col-name"));
    }

    private List<FoundElement> listElementsFound(Object maps, Predicate<AtsBaseElement> predicate, boolean colName) {
        List objects = (List)maps;
        if (objects != null && objects.size() > 0) {
            List elements = objects.parallelStream().filter(Objects::nonNull).map(e -> new AtsElement(this, (List<Object>)e, colName)).collect(Collectors.toCollection(ArrayList::new));
            Stream<FoundElement> st = elements.parallelStream().filter(predicate).map(e -> new FoundElement(this, (AtsElement)e, this.channel, this.initElementX + this.offsetIframeX, this.initElementY + this.offsetIframeY, false));
            List result = st.collect(Collectors.toCollection(ArrayList::new));
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
        this.runJavaScript(status, JS_MIDDLE_CLICK, element.getWebElement());
    }

    protected void middleClickSimulation(ActionStatus status, MouseDirection position, TestElement element) {
        element.click(status, position, Keys.CONTROL);
    }

    @Override
    public DialogBox switchToAlert() {
        this.channel.sleep(500);
        return new DialogBox(this.driver.switchTo().alert());
    }

    @Override
    public void clearText(ActionStatus status, TestElement te, MouseDirection md) {
        if (!te.isPreElement()) {
            te.click(status, md);
        }
        if (status.isPassed()) {
            FoundElement element = te.getFoundElement();
            try {
                this.executeScript(status, "arguments[0].value='';", element.getValue());
                status.setMessage("");
                return;
            }
            catch (StaleElementReferenceException staleElementReferenceException) {
                try {
                    element.getValue().clear();
                    status.setMessage("");
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        status.setError(-4, "clear text failed on this element");
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList, int waitChar, ActionTestScript topScript) {
        this.channel.waitBeforeEnterText(this);
        WebElement we = element.getWebElement();
        if (element.isPreElement()) {
            StringBuilder seq = new StringBuilder();
            for (SendKeyData sequence : textActionList) {
                seq.append(this.getSequenceData(sequence));
            }
            this.executeScript(status, "arguments[0].textContent='" + seq.toString() + "';", we);
        } else if (element.isMuiDateTimeInput()) {
            StringBuilder seq = new StringBuilder();
            for (SendKeyData sequence : textActionList) {
                seq.append(this.getCharSequenceData(sequence));
            }
            this.driver.executeScript("navigator.clipboard.writeText(arguments[0]);", new Object[]{seq.toString()});
            this.driver.executeScript("arguments[0].click();", new Object[]{we});
            this.driver.executeScript("arguments[0].focus();", new Object[]{we});
            this.channel.sleep(200);
            we.sendKeys(new CharSequence[]{String.valueOf(Keys.CONTROL) + "v"});
        } else if (element.hasKeyPressEvent()) {
            Object value = "";
            for (SendKeyData sequence : textActionList) {
                if (sequence.getDownKey() != null) {
                    we.sendKeys(new CharSequence[]{sequence.getDownKey(), sequence.getData()});
                    continue;
                }
                if (!sequence.getData().isEmpty()) {
                    value = (String)value + String.valueOf(this.getCharSequenceData(sequence));
                    value = ((String)value).replace("\\\\", "\\");
                    this.executeJavaScript(status, "value=\"" + ((String)value).replace("\\", "\"+String.fromCharCode(92)+\"") + "\"", we);
                    this.channel.sleep(10);
                    continue;
                }
                if (sequence.getSpecialKey() == null) continue;
                we.sendKeys(new CharSequence[]{sequence.getSpecialKey()});
            }
        } else {
            if (element.isInputDate() && textActionList.size() > 0) {
                Object verif;
                Object dateOrder = System.getProperty("ats.date.order");
                if (dateOrder == null) {
                    dateOrder = topScript.getDateOrder();
                }
                DateTransformer dtr = new DateTransformer();
                dtr.setDateOrder((String)dateOrder);
                String localDate = dtr.format(textActionList.get(0).getData());
                if (localDate != null && dtr.getError() == null && (verif = this.executeJavaScript(status, "value='" + localDate + "'", we)) != null && verif.toString().equals(localDate)) {
                    return;
                }
            }
            try {
                if (waitChar > 0) {
                    for (SendKeyData sequence : textActionList) {
                        if (sequence.getDownKey() != null) {
                            we.sendKeys(new CharSequence[]{sequence.getDownKey(), sequence.getData()});
                            continue;
                        }
                        if (!sequence.getData().isEmpty()) {
                            we.sendKeys(new CharSequence[]{this.getCharSequenceData(sequence)});
                            this.channel.sleep(waitChar);
                            continue;
                        }
                        if (sequence.getSpecialKey() == null) continue;
                        we.sendKeys(new CharSequence[]{sequence.getSpecialKey()});
                    }
                }
                for (SendKeyData sequence : textActionList) {
                    if (sequence.getSpecialKeyString() != null) {
                        this.channel.sleep(20);
                        this.channel.updateVisualAction(false);
                    }
                    we.sendKeys(new CharSequence[]{this.getSequenceData(sequence)});
                }
            }
            catch (StaleElementReferenceException e) {
                throw new SendTextException();
            }
        }
    }

    protected CharSequence getCharSequenceData(SendKeyData seq) {
        return seq.getSequenceWeb(false);
    }

    protected CharSequence getSequenceData(SendKeyData seq) {
        return seq.getSequenceWeb(true);
    }

    @Override
    public void refreshElementMapLocation() {
        this.getSystemDriver().refreshElementMapLocation(this.channel);
    }

    @Override
    public String getSource() {
        return this.driver.getPageSource();
    }

    @Override
    public void api(ActionStatus status, ActionApi api) {
    }

    @Override
    public void buttonClick(ActionStatus status, String id) {
    }

    @Override
    public void tap(int count, FoundElement element) {
    }

    @Override
    public void press(int duration, ArrayList<String> paths, FoundElement element) {
    }

    @Override
    public void windowState(ActionStatus status, Channel channel, String state) {
        if ("maximize".equals(state)) {
            List screenSize = (List)this.runJavaScript(status, "result=[screen.width+0.0001, screen.height+0.0001];", new Object[0]);
            this.setPosition(new com.ats.data.Point(0, 0));
            this.setSize(new Dimension(((Double)screenSize.get(0)).intValue(), ((Double)screenSize.get(1)).intValue()));
        } else {
            this.getSystemDriver().windowState(status, channel, state);
        }
    }

    @Override
    public int getNumWindows() {
        try {
            return this.getDriverWindowsList().size();
        }
        catch (WebDriverException e) {
            return 1;
        }
    }

    @Override
    public String getUrl() {
        return this.driver.getCurrentUrl();
    }

    @Override
    public Rectangle getBoundRect(TestElement element) {
        org.openqa.selenium.Rectangle rect = null;
        for (int maxTry = 10; rect == null && maxTry > 0; --maxTry) {
            try {
                rect = element.getWebElement().getRect();
                return new Rectangle(rect.x, rect.y, rect.width, rect.height);
            }
            catch (Exception exception) {
                this.channel.sleep(100);
                continue;
            }
        }
        return new Rectangle(0.0, 0.0, 1.0, 1.0);
    }

    @Override
    public byte[] getScreenshot(WebElement element, TestBound bound) {
        if (element == null) {
            return (byte[])this.driver.getScreenshotAs(OutputType.BYTES);
        }
        return (byte[])element.getScreenshotAs(OutputType.BYTES);
    }

    @Override
    public File saveCurrentPage() {
        PrintOptions printOptions = new PrintOptions();
        printOptions.setBackground(true);
        printOptions.setShrinkToFit(true);
        Pdf print = this.driver.print(printOptions);
        try {
            File tempFile = File.createTempFile("ats-ai-", "");
            tempFile.deleteOnExit();
            Files.write(tempFile.toPath(), (byte[])OutputType.BYTES.convertFromBase64Png(print.getContent()), new OpenOption[0]);
            return tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

