/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import java.util.regex.Matcher;
import org.apache.commons.text.StringEscapeUtils;

public class BaseValue {
    protected String value;
    protected String codeValue;
    private String replace = "";
    protected String defaultValue;

    public BaseValue(Matcher m) {
        this(StringEscapeUtils.escapeJava((String)m.group(1).trim()), m.group(2).trim());
        if (m.group(0) != null) {
            this.replace = StringEscapeUtils.escapeJava((String)m.group(0));
        }
    }

    public BaseValue(String value, String defaultValue) {
        this.value = value;
        this.codeValue = value;
        this.defaultValue = defaultValue;
    }

    public String getReplace() {
        return this.replace;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getNoComma() {
        return this.replace.replace(",", "\n");
    }

    public String getCode() {
        StringBuilder codeBuilder = new StringBuilder("(");
        codeBuilder.append(this.codeValue);
        if (this.defaultValue.length() > 0) {
            codeBuilder.append(", \"");
            codeBuilder.append(this.defaultValue);
            codeBuilder.append("\"");
        }
        codeBuilder.append(")");
        return codeBuilder.toString();
    }
}

