/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.condition;

import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.transform.code.JavaScriptCodeEval;
import com.ats.script.Script;
import com.ats.script.actions.condition.IExecuteCondition;
import com.google.gson.JsonObject;

public class ExecuteCondition
implements IExecuteCondition {
    private CalculatedValue code;

    public ExecuteCondition() {
    }

    public ExecuteCondition(Script script, String code) {
        this.code = new CalculatedValue(script, code);
    }

    public ExecuteCondition(CalculatedValue code) {
        this.code = code;
    }

    @Override
    public void updateLegacy() {
        String separator;
        String codeData = this.code.getData();
        String[] data = codeData.split(separator = "==");
        if (data.length != 2) {
            separator = "!=";
            data = codeData.split(separator);
        }
        if (data.length == 2) {
            String varName = data[0].trim();
            if (this.code.getScript().getVariable(varName) != null) {
                this.code.updateData("'$var(" + varName + ")' " + separator + " '" + data[1].trim() + "'");
            }
        }
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder sb = new StringBuilder("opt").append("(").append(this.code.getJavaCode()).append("), ");
        return sb;
    }

    @Override
    public JsonObject getLog(JsonObject jsonObject) {
        return jsonObject;
    }

    @Override
    public boolean isPassed() {
        String eval = new JavaScriptCodeEval(this.code.getCalculated()).eval();
        return "true".equals(eval);
    }

    @Override
    public void setPassed(boolean value) {
    }

    public void setCode(CalculatedValue code) {
        this.code = code;
    }

    public CalculatedValue getCode() {
        return this.code;
    }
}

