/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.condition;

import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.objects.TryAndDelay;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionMouseKey;
import com.ats.script.actions.condition.ExecuteCondition;
import com.ats.script.actions.condition.ExecuteConditionNone;
import com.ats.script.actions.condition.IExecuteCondition;
import com.ats.script.actions.performance.ActionPerformanceStart;
import com.ats.tools.Utils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ExecuteOptions {
    private static final String TRY = "try";
    private static final String DELAY = "delay";
    private static final String WAITCHAR = "waitchar";
    private static final String CACHE = "cache";
    private static final String PORT = "port";
    private static final String SCRIPT = "script";
    public static final String ATTACH = "attach";
    public static final String USE_COOKIE = "use-cookie";
    public static final String UPLOAD = "upload";
    public static final String DOWNLOAD = "download";
    public static final String IDLE = "idle";
    public static final String LATENCY = "latency";
    private static final String APPEND_OPTION = "append";
    private static final String REFRESH_AFTER_SWITCH = "refresh";
    private static final String KEEP_SELECT = "keep-select";
    public static final String RANDOM_LABEL = "rnd";
    private static final String RANDOM2_LABEL = "random";
    public static final String SUITE_LABEL = "suite";
    private static final Pattern IF_PATTERN = Pattern.compile("if\\((.*)\\)");
    private static final String REPLACE = "[ =\\(\\)]";
    private List<String> options = Collections.emptyList();
    private IExecuteCondition condition = new ExecuteConditionNone();

    public ExecuteOptions() {
    }

    public ExecuteOptions(CalculatedValue calc) {
        this.condition = new ExecuteCondition(calc);
    }

    public ExecuteOptions(Script script, String[] opt) {
        this.setOptions(script, Arrays.asList(opt));
    }

    private void setOptions(Script script, List<String> value) {
        ArrayList<String> list = new ArrayList<String>();
        for (String o : value) {
            Matcher ifMatch = IF_PATTERN.matcher(o);
            if (ifMatch.find()) {
                this.condition = new ExecuteCondition(script, ifMatch.group(1));
                continue;
            }
            list.add(o);
        }
        this.options = ImmutableList.copyOf(list);
    }

    public String init(Script script, String actionType, Pattern pattern) {
        Matcher matcher = pattern.matcher(actionType);
        if (matcher.find()) {
            actionType = matcher.group(1).trim().toLowerCase();
            String data = matcher.group(2).trim();
            this.setOptions(script, Arrays.stream(data.split(",")).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return actionType;
    }

    public ExecuteOptions add(String[] value) {
        this.options = Stream.concat(this.options.stream(), Arrays.asList(value).stream()).collect(Collectors.toUnmodifiableList());
        return this;
    }

    public int getPort() {
        for (String o : this.options) {
            if (!o.startsWith(PORT)) continue;
            return Utils.string2Int(this.replaceData(4, o));
        }
        for (String o : this.options) {
            if (!StringUtils.isNumeric((CharSequence)o)) continue;
            return Utils.string2Int(o, -1);
        }
        return -1;
    }

    public boolean hasCache() {
        return this.options.contains(CACHE);
    }

    public boolean hasKeepSelect() {
        return this.options.contains(KEEP_SELECT);
    }

    public boolean hasRefresh() {
        return this.options.contains(REFRESH_AFTER_SWITCH);
    }

    public boolean hasScript() {
        return this.options.contains(SCRIPT);
    }

    public boolean hasAppend() {
        return this.options.contains(APPEND_OPTION);
    }

    public boolean hasNoStopLabel() {
        return this.options.contains("nostop");
    }

    public int getWaitChar() {
        for (String o : this.options) {
            if (!o.startsWith(WAITCHAR)) continue;
            return Utils.string2Int(this.replaceData(8, o));
        }
        return -1;
    }

    public void updateMouseDirections(MouseDirection direction, Script script) {
        for (String o : this.options) {
            if (Cartesian.RIGHT.isPresent(o)) {
                direction.setHorizontalPos(new MouseDirectionData(Cartesian.RIGHT.toString(), new CalculatedValue(script, this.replaceData(5, o))));
                continue;
            }
            if (Cartesian.LEFT.isPresent(o)) {
                direction.setHorizontalPos(new MouseDirectionData(Cartesian.LEFT.toString(), new CalculatedValue(script, this.replaceData(4, o))));
                continue;
            }
            if (Cartesian.CENTER.isPresent(o)) {
                direction.setHorizontalPos(new MouseDirectionData(Cartesian.CENTER.toString(), new CalculatedValue(script, this.replaceData(6, o))));
                continue;
            }
            if (Cartesian.TOP.isPresent(o)) {
                direction.setVerticalPos(new MouseDirectionData(Cartesian.TOP.toString(), new CalculatedValue(script, this.replaceData(3, o))));
                continue;
            }
            if (Cartesian.BOTTOM.isPresent(o)) {
                direction.setVerticalPos(new MouseDirectionData(Cartesian.BOTTOM.toString(), new CalculatedValue(script, this.replaceData(6, o))));
                continue;
            }
            if (!Cartesian.MIDDLE.isPresent(o)) continue;
            direction.setVerticalPos(new MouseDirectionData(Cartesian.MIDDLE.toString(), new CalculatedValue(script, this.replaceData(6, o))));
        }
    }

    private String replaceData(int l, String s) {
        return s.substring(l).replaceAll(REPLACE, "");
    }

    public void updateMousKeys(ActionMouseKey action) {
        for (String o : this.options) {
            action.setKey(o);
        }
    }

    public IExecuteCondition getCondition(Script script) {
        return this.condition;
    }

    public TryAndDelay getTryAndDelay() {
        int tryExec = 0;
        int delayExec = 0;
        for (String o : this.options) {
            if (o.startsWith(TRY)) {
                tryExec = Utils.string2Int(this.replaceData(3, o));
                continue;
            }
            if (!o.startsWith(DELAY)) continue;
            delayExec = Utils.string2Int(this.replaceData(5, o));
        }
        return new TryAndDelay(tryExec, delayExec);
    }

    public int getStopPolicy() {
        for (String o : this.options) {
            if ("nofail".equalsIgnoreCase(o)) {
                return 1;
            }
            if (!"testfail".equalsIgnoreCase(o)) continue;
            return 2;
        }
        return 0;
    }

    public void updateChannelStart(ActionChannelStart action, List<String> dataArray, Script script) {
        this.checkOption(action, dataArray, script);
        this.checkOption(action, this.options, script);
    }

    private void checkOption(ActionChannelStart action, List<String> data, Script script) {
        for (String o : data) {
            if ("neoload".equalsIgnoreCase(o = o.trim())) {
                action.setPerformance(2);
                continue;
            }
            if (ATTACH.equalsIgnoreCase(o)) {
                action.setAttach(true);
                continue;
            }
            if (USE_COOKIE.equalsIgnoreCase(o)) {
                action.setUseCookie(true);
                continue;
            }
            if ("perf".equalsIgnoreCase(o)) {
                action.setPerformance(1);
                continue;
            }
            if ("Basic".equalsIgnoreCase(o) || "Bearer".equalsIgnoreCase(o)) {
                action.setAuthentication(o);
                continue;
            }
            if (!Strings.isNullOrEmpty((String)action.getAuthentication()) && Strings.isNullOrEmpty((String)action.getAuthenticationValue())) {
                action.setAuthenticationValue(o);
                continue;
            }
            action.getArguments().add(new CalculatedValue(script, o));
        }
    }

    public void updateBandWidth(ActionPerformanceStart action) {
        for (String o : this.options) {
            if (o.startsWith(UPLOAD)) {
                action.setSendBandWidth(Utils.string2Long(this.replaceData(6, o)));
                continue;
            }
            if (o.startsWith(DOWNLOAD)) {
                action.setReceiveBandWidth(Utils.string2Long(this.replaceData(8, o)));
                continue;
            }
            if (o.startsWith(LATENCY)) {
                action.setLatency(Utils.string2Int(this.replaceData(7, o)));
                continue;
            }
            if (!o.startsWith(IDLE)) continue;
            action.setTrafficIdle(Utils.string2Int(this.replaceData(4, o)));
        }
    }

    public void updateCallScript(ActionCallscript action, List<String> dataArray, AtsScript script) {
        if (dataArray != null) {
            dataArray.addAll(this.options);
        } else {
            dataArray = this.options;
        }
        for (String o : dataArray) {
            if (RANDOM_LABEL.equalsIgnoreCase(o = o.trim()) || RANDOM2_LABEL.equalsIgnoreCase(o)) {
                action.setRandom(true);
                continue;
            }
            if (SUITE_LABEL.equalsIgnoreCase(o)) {
                action.setSuite(true);
                continue;
            }
            if (o.startsWith("range")) {
                action.setRange(this.replaceData(5, o));
                continue;
            }
            if (o.startsWith("loop")) {
                action.setLoop(Utils.string2Int(this.replaceData(4, o)));
                continue;
            }
            if (!o.startsWith("table")) continue;
            action.updateTableSplit(this.replaceData(5, o));
        }
        action.callscriptLegacy();
    }

    public void checkLegacy(AtsScript script) {
        if (this.options != null && this.options.size() == 1 && this.condition instanceof ExecuteConditionNone) {
            String data = this.options.get(0);
            String[] arr = data.split("<>");
            String operator = "!=";
            if (arr.length != 2) {
                operator = "==";
                arr = data.split("=");
            }
            if (arr.length == 2) {
                this.condition = new ExecuteCondition(script, "'$var(" + arr[0].trim() + ")' " + operator + " '" + arr[1].trim() + "'");
            }
        }
    }
}

