/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.utils;

import com.ats.tools.ResourceContent;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.SuiteInfo;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HtmlSummaryGenerator {
    private static final String summarySuiteTemplate = ResourceContent.getHtmlReportSummarySuiteTemplate();
    private static final String summaryTestTemplate = "<div class='header'>\n                    <div class='status-line test-details-header-test-case-name font-weight-100 no-bottom-border ${background-color} ${border-radius}'>\n                        <div style='display: flex; align-items: center; margin-left: 60px;'><div class='test-name-prefix ${tcp-border-radius}'>test case</div> <div style='display: flex;flex-direction: column;'>\n                           <div style='font-size: 13px;font-style: italic;'>${testPath}</div>\n                           <div style='word-wrap: break-word;max-width: 770px;'>${testName}</div>\n                           </div></div>\n                        <div style='display: flex; align-items: center;'>                        <div class='details-header-action-details-item'>\n<div style='display: flex; align-items: center;'>\n    <div style='padding-right: 25px;display: flex;flex-direction: column;align-items: flex-start;'>\n        <div style='display: flex; justify-content: flex-start;'>${actionsCount} action${teem}</div>\n        <div style='font-size: 14px;'>executed in ${testExecutionTime}</div>\n    </div>\n</div>                            <div class='${resultIcon}'></div></div>\n                        </div>\n                    </div>\n                </div>";

    /*
     * Exception decompiling
     */
    public static void generateHtmlSummary(String htmlSummaryTemplate, HtmlReportProject project, String outputDirectory, int devReportLevel, Map<String, Integer> testSuiteActionsCount, Results results, List<Script> scripts, Map<String, Long> testDurations) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int getExecutedTestsCount(Results results) {
        return results.getSuites().stream().mapToInt(suiteInfo -> suiteInfo.getTestsPassed() + suiteInfo.getTestsFailed()).sum();
    }

    private static String buildSuites(Results results, List<Script> scripts, Map<String, Integer> testSuiteActionsCount, Map<String, Long> testDurations) {
        return results.getSuites().stream().sorted((suiteInfo, t1) -> Math.toIntExact(suiteInfo.getStarted() - t1.getStarted())).map(suite -> HtmlSummaryGenerator.buildSuite(suite, scripts, testSuiteActionsCount, testDurations)).collect(Collectors.joining());
    }

    private static String buildSuite(SuiteInfo suite, List<Script> scripts, Map<String, Integer> testSuiteActionsCount, Map<String, Long> testDurations) {
        String result = summarySuiteTemplate.replace("${playlistName}", suite.getName());
        int testCount = suite.getTestsFailed() + suite.getTestsPassed() + suite.getTestsFiltered();
        int actionsCountForSuite = HtmlSummaryGenerator.getActionsCountForSuite(suite.getName(), testSuiteActionsCount);
        result = result.replaceAll(Pattern.quote("${suiteTestCount}"), String.valueOf(testCount));
        result = result.replace("${suiteTestsPassed}", String.valueOf(suite.getTestsPassed()));
        result = result.replace("${suiteTestsFailed}", String.valueOf(suite.getTestsFailed()));
        result = result.replace("${suiteTestsSkipped}", String.valueOf(suite.getTestsFiltered()));
        result = result.replace("${suiteActionsCount}", String.valueOf(actionsCountForSuite));
        result = result.replace("${suiteExecutionTime}", HtmlSummaryGenerator.buildDuration(suite.getDuration()));
        result = result.replace("${resultClass}", HtmlSummaryGenerator.getResultClass(suite.getStatus()));
        result = result.replace("${idSuiteName}", suite.getName());
        result = result.replace("${tests}", HtmlSummaryGenerator.buildTests(suite, scripts, testDurations, testSuiteActionsCount));
        result = result.replace("${stem}", testCount > 1 ? "s" : "");
        result = result.replace("${eem}", actionsCountForSuite > 1 ? "s" : "");
        return result;
    }

    private static String buildTests(SuiteInfo suite, List<Script> scripts, Map<String, Long> testDurations, Map<String, Integer> testSuiteActionsCount) {
        StringBuilder result = new StringBuilder();
        int counter = 0;
        int totalPlaylistScripts = (int)scripts.stream().filter(script -> script.getSuite().equals(suite.getName())).count();
        for (Script script2 : scripts) {
            if (!script2.getSuite().equals(suite.getName())) continue;
            boolean darkBackground = ++counter % 2 == 0;
            boolean isLast = counter == totalPlaylistScripts;
            boolean isFirst = counter == 1;
            result.append(HtmlSummaryGenerator.buildTest(script2, testDurations, testSuiteActionsCount, isFirst, isLast, darkBackground));
        }
        return result.toString();
    }

    private static String buildTest(Script script, Map<String, Long> testDurations, Map<String, Integer> testSuiteActionsCount, boolean isFirst, boolean isLast, boolean darkBackground) {
        Integer actionsCount = testSuiteActionsCount.entrySet().stream().filter(entry -> script.getName().equals(((String)entry.getKey()).split("\\|")[0])).map(Map.Entry::getValue).findFirst().orElse(0);
        String testPath = "";
        String testName = "";
        int lastDotIndex = script.getName().lastIndexOf(46);
        if (lastDotIndex != -1) {
            testPath = script.getName().substring(0, lastDotIndex);
            testName = script.getName().substring(lastDotIndex + 1);
        } else {
            testPath = "...";
            testName = script.getName();
        }
        String testInfo = summaryTestTemplate.replace("${actionsCount}", String.valueOf(actionsCount)).replace("${testExecutionTime}", HtmlSummaryGenerator.buildDuration(HtmlSummaryGenerator.geDurationForTest(script.getName(), testDurations))).replace("${resultIcon}", HtmlSummaryGenerator.getResultClass(script.isPassed() ? "PASS" : "FAIL")).replace("${teem}", actionsCount > 1 ? "s" : "").replace("${testPath}", testPath).replace("${testName}", testName);
        if (isFirst && isLast) {
            testInfo = testInfo.replace("${border-radius}", "full-border-radius");
        }
        if (isLast) {
            testInfo = testInfo.replace("no-bottom-border", "");
            testInfo = testInfo.replace("${border-radius}", "bottom-border-radius");
        }
        if (isFirst) {
            testInfo = testInfo.replace("${tcp-border-radius}", "test-name-prefix-br");
            testInfo = testInfo.replace("${border-radius}", "top-border-radius");
        }
        if (darkBackground) {
            testInfo = testInfo.replace("${background-color}", "test-background-color");
        }
        return testInfo;
    }

    private static Long geDurationForTest(String name, Map<String, Long> testDurations) {
        return testDurations.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(name)).map(Map.Entry::getValue).findFirst().orElse(0L);
    }

    private static String getResultClass(String status) {
        return status.equals("PASS") ? "result-pass-icon-transparent" : "result-failed-icon";
    }

    private static int getActionsCountForSuite(String name, Map<String, Integer> testSuiteActionsCount) {
        return testSuiteActionsCount.entrySet().stream().filter(stringIntegerEntry -> name.equals(((String)stringIntegerEntry.getKey()).split("\\|")[1])).mapToInt(Map.Entry::getValue).sum();
    }

    private static int getTestsPassed(Results results) {
        return results.getSuites().stream().mapToInt(SuiteInfo::getTestsPassed).sum();
    }

    private static int getTestsFailed(Results results) {
        return results.getSuites().stream().mapToInt(SuiteInfo::getTestsFailed).sum();
    }

    private static String buildDuration(long durationInMillis) {
        Duration duration = Duration.ofMillis(durationInMillis);
        long hours = duration.toHours();
        long minutes = duration.toMinutesPart();
        long seconds = duration.toSecondsPart();
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }
}

