/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.element.AtsBaseElement;
import com.ats.element.FoundElement;
import com.ats.generator.variables.CalculatedProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AtsSapElement
extends AtsBaseElement {
    public static final String X = "X";
    public static final String Y = "Y";
    public static final String SCREEN_X = "ScreenX";
    public static final String SCREEN_Y = "ScreenY";
    public static final String WIDTH = "Width";
    public static final String HEIGHT = "Height";
    public static final String ID = "Id";
    public static final String TAG = "Tag";
    private static final String ROOT = "root";
    private static final String INNER_TEXT = "innerText";
    private static final String TEXT = "Text";
    public static final String ELEMENT_ID = "ElementId";
    private static final String PATH = "Path";
    private static final String ATTRIBUTES = "Attributes";
    private AtsSapElement parent;
    private String innerText;
    private double screenX;
    private double screenY;

    public AtsSapElement(ObjectMapper mapper, JsonNode node) {
        this.setId(node.findValue(ID).asText());
        this.setTag(node.findValue(TAG).asText());
        this.setWidth(node.findValue(WIDTH).asDouble(0.0));
        this.setHeight(node.findValue(HEIGHT).asDouble(0.0));
        this.setX(node.findValue(X).asDouble(0.0));
        this.setY(node.findValue(Y).asDouble(0.0));
        this.screenX = node.findValue(SCREEN_X).asDouble(0.0);
        this.screenY = node.findValue(SCREEN_Y).asDouble(0.0);
        Map attributes = (Map)mapper.convertValue((Object)node.findValue(ATTRIBUTES), (TypeReference)new TypeReference<Map<String, String>>(this){});
        attributes.put(TEXT, node.findValue(TEXT).asText());
        attributes.put(ELEMENT_ID, node.findValue(ELEMENT_ID).asText());
        attributes.put(PATH, node.findValue(PATH).asText());
        JsonNode itNode = node.findValue(INNER_TEXT);
        if (itNode != null) {
            this.innerText = itNode.asText();
            attributes.put(INNER_TEXT, this.innerText);
        }
        this.setAttributes(attributes);
    }

    public AtsSapElement(JsonNode node, ObjectMapper mapper) {
        this.setId(node.findValue(ID).asText());
        this.setTag(node.findValue(TAG).asText());
        this.setWidth(node.findValue(WIDTH).asDouble(0.0));
        this.setHeight(node.findValue(HEIGHT).asDouble(0.0));
        this.setX(node.findValue(X).asDouble(0.0));
        this.setY(node.findValue(Y).asDouble(0.0));
    }

    public AtsSapElement(FoundElement element) {
        this.setId(element.getId());
        this.setTag(element.getTag());
        this.setWidth(element.getWidth());
        this.setHeight(element.getHeight());
        this.setX(element.getX());
        this.setY(element.getY());
        this.setScreenX(element.getScreenX());
        this.setScreenY(element.getScreenY());
        this.setAttributes(element.getAttribute());
    }

    public String getInnerText() {
        return this.innerText;
    }

    public double getScreenX() {
        return this.screenX;
    }

    public double getScreenY() {
        return this.screenY;
    }

    public void setScreenX(double x) {
        this.screenX = x;
    }

    public void setScreenY(double y) {
        this.screenY = y;
    }

    public CalculatedProperty[] getAttributes() {
        List<CalculatedProperty> properties = this.getProperties();
        return properties.toArray(new CalculatedProperty[properties.size()]);
    }

    public boolean isRoot() {
        return ROOT.equals(this.getTag());
    }

    public FoundElement getFoundElement() {
        return new FoundElement(this);
    }

    public AtsSapElement getParent() {
        return this.parent;
    }

    public void setParent(AtsSapElement parent) {
        this.parent = parent;
    }
}

