/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element.test;

import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.engines.SapDriverEngine;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestElementSap
extends TestElement {
    public TestElementSap(ActionTestScript script, Channel channel, int actionMaxTry, Predicate<Integer> predicate, SearchedElement searchElement) {
        super(script, channel, actionMaxTry, predicate, searchElement);
    }

    private SapDriverEngine getSapEngine() {
        return (SapDriverEngine)this.engine;
    }

    @Override
    public String getAttribute(ActionStatus status, String name) {
        if ("NetworkOption".equalsIgnoreCase(name)) {
            return this.getSapEngine().getNetworkOption();
        }
        return super.getAttribute(status, name);
    }

    @Override
    public String getNotFoundDescription() {
        StringBuilder messageBuilder = new StringBuilder(super.getNotFoundDescription());
        if (this.getSelector().contains("ElementId")) {
            String networkOption = this.getAttribute(null, "NetworkOption");
            String regExStr = "ElementId:([a-zA-Z]+\\[\\d+\\])";
            Pattern pattern = Pattern.compile("ElementId:([a-zA-Z]+\\[\\d+\\])", 8);
            Matcher matcher = pattern.matcher(this.getSelector());
            if (matcher.find()) {
                if ("fast".equalsIgnoreCase(networkOption)) {
                    messageBuilder.append(this.getNotFoundDescription_FastConn());
                }
            } else if ("slow".equalsIgnoreCase(networkOption)) {
                messageBuilder.append(this.getNotFoundDescription_SlowConn());
            }
        }
        return messageBuilder.toString();
    }

    private String getNotFoundDescription_FastConn() {
        StringBuilder builder = new StringBuilder("\nINFO: You are looking for an indexed elementId, while your connection is in \"Fast Connection\" and will therefore not produce indexed elementIds.\n");
        builder.append("This indicates that the script designer had a connection with the \"Slow connect\" network option.\n");
        builder.append("You can try setting your network option of your connection to \"Slow connection\".\n");
        builder.append("WARNING: This will modify the Ids created by SAP and therefore may impact your other scripts");
        return builder.toString();
    }

    private String getNotFoundDescription_SlowConn() {
        StringBuilder builder = new StringBuilder("\nINFO: It is possible that the element was not found because your connection is configured in \"Slow Connection\", which produces indexed elements of form obj[idx], whereas your looking for an unindexed elementId.\n");
        builder.append("This indicates that the script designer had a connection with the \"Fast connect\" network option.\n");
        builder.append("You can try setting your network option of your connection to \"Fast connection\".\n");
        builder.append("WARNING: This will modify the Ids created by SAP and therefore may impact your other scripts");
        return builder.toString();
    }
}

