/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.generator.variables.CalculatedValue;
import java.util.ArrayList;

public class BrowserArgumentsParser {
    private static final String INCOGNITO_OPTION = "incognito";
    private static final String PRIVATE_OPTION = "private";
    private static final String IN_PRIVATE_OPTION = "inprivate";
    private static final String HEADLESS_OPTION = "headless";
    private static final String PROFILE_OPTION = "profile";
    private static final String LANG_OPTION = "lang";
    private static final String MAC_BRAVE_BROWSER_PATH = "/Applications/Brave Browser.app/Contents/MacOS/Brave Browser";
    private String userDataPath;
    private String binaryPath;
    private boolean incognito = false;
    private boolean headless = false;
    private String lang;
    private String[] moreOptions = null;

    public BrowserArgumentsParser(IDriverInfo driverInfo, ArrayList<CalculatedValue> arguments, ApplicationProperties props, String browserName, String binary, SystemDriver systemDriver) {
        ArrayList<String> args = new ArrayList<String>();
        boolean firefoxLinux = false;
        boolean braveMacOs = false;
        if ("firefox".equals(browserName)) {
            if (binary == null && driverInfo.getApplicationPath() != null) {
                binary = driverInfo.getApplicationPath();
            }
            if (systemDriver.isLinux()) {
                firefoxLinux = true;
            }
        } else if ("msedge".equals(browserName)) {
            args.add("edge-skip-compat-layer-relaunch");
        } else if ("brave".equals(browserName) && systemDriver.getOsName().toLowerCase().contains("mac")) {
            braveMacOs = true;
        }
        for (CalculatedValue calcv : arguments) {
            String arg = calcv.getCalculated();
            if (arg.startsWith(PROFILE_OPTION)) {
                String profile = arg.replace(PROFILE_OPTION, "").replace("=", "").trim();
                this.userDataPath = ApplicationProperties.getUserDataPath(profile, browserName, systemDriver);
                continue;
            }
            if (arg.startsWith(LANG_OPTION)) {
                this.lang = arg.replace(LANG_OPTION, "").replace("=", "").trim();
                continue;
            }
            if (arg.contains(HEADLESS_OPTION)) {
                this.headless = true;
                continue;
            }
            if (arg.contains(INCOGNITO_OPTION) || arg.contains(PRIVATE_OPTION) || arg.contains(IN_PRIVATE_OPTION)) {
                this.incognito = true;
                continue;
            }
            args.add(arg);
        }
        if (props.getLang() != null) {
            this.lang = props.getLang();
        }
        if (this.userDataPath == null) {
            this.userDataPath = firefoxLinux ? ApplicationProperties.getUserDataPath("default", browserName, systemDriver) : ApplicationProperties.getUserDataPath(props.getUserDataDir(), browserName, systemDriver);
        }
        this.binaryPath = binary == null ? driverInfo.getApplicationPath() : binary;
        if (braveMacOs) {
            this.binaryPath = MAC_BRAVE_BROWSER_PATH;
        }
        if (!this.headless && !systemDriver.isInteractive()) {
            this.headless = true;
        }
        if (props.getOptions() != null) {
            for (String s : props.getOptions()) {
                if (s.length() <= 0) continue;
                if (INCOGNITO_OPTION.equals(s) || PRIVATE_OPTION.equals(s)) {
                    this.incognito = true;
                    continue;
                }
                if (s.contains(HEADLESS_OPTION)) {
                    this.headless = true;
                    continue;
                }
                if (s.length() <= 0) continue;
                args.add(s);
            }
        }
        if (args.size() > 0) {
            this.moreOptions = args.toArray(new String[args.size()]);
        }
        driverInfo.setHeadless(this.headless);
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public String[] getMoreOptions() {
        if (this.moreOptions == null) {
            return new String[0];
        }
        return this.moreOptions;
    }

    public String getUserDataPath() {
        return this.userDataPath;
    }

    public boolean isIncognito() {
        return this.incognito;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public String getLang() {
        return this.lang;
    }
}

