/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.AtsSingleton;
import com.ats.crypto.Passwords;
import com.ats.executor.channels.Channel;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.EnvironmentValue;
import com.ats.generator.variables.ScriptValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.generator.variables.transform.DateTransformer;
import com.ats.generator.variables.transform.TimeTransformer;
import com.ats.generator.variables.transform.Transformer;
import com.ats.recorder.ShadowScript;
import com.ats.recorder.TestError;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.tools.logger.ExecutionLogger;
import com.google.common.collect.ImmutableMap;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.testng.ITest;
import org.testng.collections.Maps;

public class Script
implements ITest {
    public static final Pattern OBJECT_PATTERN = Pattern.compile("(.*)\\[(.*)\\]", 2);
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String ATS_EXTENSION = "ats";
    public static final String ATS_FILE_EXTENSION = ".ats";
    public static final String ATS_VISUAL_EXTENSION = "atsv";
    public static final String ATS_VISUAL_FILE_EXTENSION = ".atsv";
    public static final String ATS_VISUAL_FOLDER = "visual";
    public static final String SCRIPT_LOG = "SCRIPT";
    protected static final String TEST_NAME = "ATS_TEST_NAME";
    protected ScriptHeader scriptHeader = new ScriptHeader();
    private ParameterList parameterList;
    private List<Variable> variables = new ArrayList<Variable>();
    private ArrayList<List<Variable>> iterVariables = new ArrayList();
    private ArrayList<CalculatedValue> returns;
    protected String csvAbsoluteFilePath;
    protected int iteration = 0;
    protected int iterationsCount = 0;
    protected long started = System.currentTimeMillis();
    private Map<String, String> testExecutionVariables;
    private Map<String, String> ATSEnvVariables;
    protected ExecutionLogger logger = new ExecutionLogger();
    protected Passwords passwords;
    private String testName = "";
    private ShadowScript shadowScript;
    private List<String> summary;
    private Action lastAction;

    public Script() {
    }

    public Script(ExecutionLogger logger) {
        this.setTopLogger(logger);
    }

    public String getPassword(String name) {
        if (this.passwords == null) {
            return "";
        }
        return this.passwords.getPassword(name);
    }

    public long getTimeLine() {
        return System.currentTimeMillis() - this.started;
    }

    public long getStarted() {
        return this.started;
    }

    protected void initShadowScript() {
        this.shadowScript = new ShadowScript();
        this.summary = new ArrayList<String>();
    }

    protected void initShadowScript(ShadowScript script) {
        this.shadowScript = script;
    }

    protected void initShadowScript(ScriptHeader header, String suiteName) {
        this.shadowScript = new ShadowScript(header, suiteName);
        this.summary = new ArrayList<String>();
    }

    public ShadowScript getShadowScript() {
        return this.shadowScript;
    }

    public void addShadowAction(Action action) {
        this.shadowScript.addAction(action, this.getTimeLine());
    }

    public void addShadowActionError(Action action, int line, String errorText, TestError.TestErrorStatus testErrorStatus) {
        this.shadowScript.setError(action, this.getTimeLine(), line, errorText, testErrorStatus);
    }

    public void summaryStack(String value) {
        if (this.summary == null) {
            this.summary = new ArrayList<String>();
        }
        this.summary.add(value);
    }

    public String getSummaryText() {
        if (this.summary != null) {
            return String.join((CharSequence)"<br>", this.summary);
        }
        return "";
    }

    public void setLastAction(Action action) {
        this.lastAction = action;
    }

    public void setTopLogger(ExecutionLogger value) {
        if (value != null) {
            this.logger = value;
        }
    }

    @Transient
    public ExecutionLogger getLogger() {
        return this.logger;
    }

    public void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void setTestExecutionVariables(Map<String, String> params) {
        this.testExecutionVariables = params;
    }

    public Map<String, String> getTestExecutionVariables() {
        if (this.testExecutionVariables == null) {
            return new HashMap<String, String>();
        }
        return this.testExecutionVariables;
    }

    public Map<String, String> getParametersMap() {
        if (this.parameterList != null) {
            return this.parameterList.getMap();
        }
        return Maps.newHashMap((Map)ImmutableMap.of());
    }

    public Map<String, String> getVariablesMap() {
        if (this.variables != null) {
            return this.variables.stream().collect(Collectors.toMap(e -> e.getName(), e -> e.getCalculatedValue()));
        }
        return Maps.newHashMap((Map)ImmutableMap.of());
    }

    public Channel getChannel(String name) {
        return AtsSingleton.getInstance().getChannel(name);
    }

    public List<Variable> getAllIterVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        this.iterVariables.forEach((Consumer<List<Variable>>)((Consumer<List>)vars::addAll));
        return vars;
    }

    public void setIterVariables(List<Variable> data) {
        this.setIterVariables(this.iteration, data);
    }

    public void setIterVariables(int iterNum, List<Variable> data) {
        if (data != null && this.iterVariables != null && iterNum - 1 < this.iterVariables.size()) {
            this.iterVariables.set(iterNum - 1, data);
        }
    }

    public List<Variable> getIterVariables(int iterNum) {
        if (this.iterVariables != null && iterNum - 1 < this.iterVariables.size()) {
            return this.iterVariables.get(iterNum - 1);
        }
        return null;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> data) {
        this.variables = data;
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void setParameterList(ParameterList data) {
        this.parameterList = data;
    }

    public CalculatedValue[] getReturns() {
        if (this.returns != null) {
            return this.returns.toArray(new CalculatedValue[this.returns.size()]);
        }
        return null;
    }

    public void setReturns(CalculatedValue[] data) {
        this.returns = new ArrayList<CalculatedValue>(Arrays.asList(data));
    }

    public String getGlobalVariableValue(String varPath) {
        String value = AtsSingleton.getInstance().getGlobalVariableValue(varPath);
        if (value == null) {
            this.getLogger().sendWarning("Unable to find global variable", varPath);
            value = this.getParameterValue(varPath);
        }
        return value;
    }

    public boolean checkVariableExists(String name) {
        for (Variable variable : this.getVariables()) {
            if (!variable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Variable getVariable(String name, boolean noCalculation) {
        Variable foundVar = this.getVariable(name);
        if (foundVar == null) {
            foundVar = this.createVariable(name, new CalculatedValue(this, ""), null, false);
        }
        if (noCalculation) {
            foundVar.getValue().setData("");
            foundVar.setCalculation(false);
        }
        return foundVar;
    }

    public Variable getVariable(String name) {
        Variable[] vars = this.variables.toArray(new Variable[this.variables.size()]);
        for (int ind = vars.length - 1; ind >= 0; --ind) {
            Variable var = vars[ind];
            if (var == null || !name.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    public Variable addVariable(String name, CalculatedValue value, Transformer transformer, boolean fixed) {
        Variable foundVar = this.getVariable(name);
        if (foundVar == null) {
            foundVar = this.createVariable(name, value, transformer, fixed);
        } else {
            foundVar.setValue(value);
            foundVar.setTransformation(transformer);
        }
        return foundVar;
    }

    public Variable createVariable(String name, CalculatedValue value, Transformer transformer) {
        return this.createVariable(name, value, transformer, false);
    }

    public Variable createVariable(String name, CalculatedValue value, Transformer transformer, boolean fixed) {
        Variable newVar = new Variable(name, value, transformer, fixed);
        this.variables.add(newVar);
        return newVar;
    }

    public String getVariableValue(String variableName) {
        return this.getVariable(variableName, false).getCalculatedValue();
    }

    public String[] getParameters() {
        if (this.parameterList == null) {
            return new String[0];
        }
        return this.parameterList.getParameters();
    }

    public ScriptValue getParameter(String name) {
        return new ScriptValue(this.getParameterValue(name, ""));
    }

    public ScriptValue ats_parameter(int index) {
        return this.getParameter(index);
    }

    public ScriptValue getParameter(int index) {
        return new ScriptValue(this.getParameterValue(index, ""));
    }

    public String getParameterValue(String name) {
        return this.getParameterValue(name, "");
    }

    public String getParameterValue(String name, String defaultValue) {
        if (this.parameterList == null) {
            return defaultValue;
        }
        try {
            int index = Integer.parseInt(name);
            return this.getParameterValue(index, defaultValue);
        }
        catch (NumberFormatException numberFormatException) {
            return this.parameterList.getParameterValue(name, defaultValue);
        }
    }

    public String getParameterValue(int index) {
        return this.getParameterValue(index, "");
    }

    public String getParameterValue(int index, String defaultValue) {
        if (this.parameterList == null) {
            return defaultValue;
        }
        return this.parameterList.getParameterValue(index, defaultValue);
    }

    public String getSpecialValue(String key) {
        return this.scriptHeader.getData(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPropertyVariableValue(String file, String name) {
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("assets/data/" + file.replace(".", "/") + ".properties");){
            Properties prop = new Properties();
            if (input == null) {
                this.getLogger().sendWarning("Unable to find properties file", file);
                String string = "";
                return string;
            }
            prop.load(input);
            String value = prop.getProperty(name);
            if (value != null) {
                String string = value;
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getLogger().sendWarning("Unable to find property key", name);
        return "";
    }

    public String getProjectVariableValue(String name) {
        String value = AtsSingleton.getInstance().getProjectVariableValue(name);
        if (value == null) {
            this.getLogger().sendWarning("Unable to find project variable", name);
            return "";
        }
        return value;
    }

    public void setEnvironnementValue(String name, String value) {
        try {
            System.setProperty(name, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getEnvironmentValue(String name, String defaultValue) {
        String value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        value = System.getenv(name);
        if (value != null) {
            return value;
        }
        if (this.testExecutionVariables != null && (value = this.testExecutionVariables.get(name)) != null) {
            Matcher mv = CalculatedValue.ENV_PATTERN.matcher(value);
            while (mv.find()) {
                EnvironmentValue sp = new EnvironmentValue(mv);
                value = value.replace(sp.getReplace(), this.getEnvironmentValue(sp.getValue(), sp.getDefaultValue()));
                mv = CalculatedValue.ENV_PATTERN.matcher(value);
            }
            return value;
        }
        StringBuilder ATS_name = new StringBuilder("ATS_").append(name.replaceAll("\\.", ""));
        value = System.getenv(ATS_name.toString());
        if (value != null) {
            return value;
        }
        if (this.ATSEnvVariables == null) {
            this.ATSEnvVariables = Script.extractEnvOptions();
        }
        if (this.ATSEnvVariables != null && !this.ATSEnvVariables.isEmpty() && (value = this.ATSEnvVariables.get(name.replaceAll("\\-", ""))) != null) {
            return value;
        }
        return defaultValue;
    }

    private static Map<String, String> extractEnvOptions() {
        String atsOptions = System.getenv("ATS_OPTIONS");
        if (atsOptions != null) {
            Map envOptions = Maps.newHashMap();
            List<String> listArgs = Arrays.asList(atsOptions.split(" "));
            Iterator<String> iterator = listArgs.iterator();
            while (iterator.hasNext()) {
                String argName;
                String firstArg;
                int equalPos;
                String arg;
                String paramValue = arg = iterator.next();
                if (arg.startsWith("-D")) {
                    paramValue = arg.substring(2);
                }
                if ((equalPos = (firstArg = paramValue.toLowerCase(Locale.ROOT)).indexOf("=")) == -1) {
                    argName = firstArg.replaceAll("\\-", "");
                    envOptions.put(argName, "1");
                    continue;
                }
                argName = firstArg.substring(0, equalPos).replaceAll("\\-", "");
                String argValue = firstArg.substring(equalPos + 1).trim();
                envOptions.put(argName, argValue);
            }
            return envOptions;
        }
        return null;
    }

    public String getUuidValue() {
        return UUID.randomUUID().toString();
    }

    public String getTodayValue() {
        return DateTransformer.getTodayValue();
    }

    public String getNowValue() {
        return TimeTransformer.getNowValue();
    }

    public void updateIterationData(int iter, int count) {
        this.iteration = iter;
        this.iterationsCount = count;
    }

    public int getIteration() {
        return this.iteration;
    }

    public int getIterationsCount() {
        return this.iterationsCount;
    }

    public long getLastActionDuration() {
        if (this.lastAction != null) {
            return this.lastAction.getExecutionDuration();
        }
        return 0L;
    }

    public String getCsvFilePath() {
        return this.csvAbsoluteFilePath;
    }

    public File getCsvFile() {
        return new File(this.csvAbsoluteFilePath);
    }

    public File getAssetsFile(String relativePath) {
        if (!((String)relativePath).startsWith("/")) {
            relativePath = "/" + (String)relativePath;
        }
        relativePath = "assets" + (String)relativePath;
        URL url = this.getClass().getClassLoader().getResource((String)relativePath);
        if (url != null) {
            try {
                return Paths.get(url.toURI()).toFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getAssetsFilePath(String relativePath) {
        File f = this.getAssetsFile(relativePath);
        if (f != null) {
            return f.getAbsolutePath();
        }
        return "";
    }

    public String getAssetsUrl(String relativePath) {
        URL url = this.getClass().getClassLoader().getResource(relativePath);
        if (url != null) {
            return "file://" + url.getPath();
        }
        return "";
    }

    public String getTestName() {
        return this.testName;
    }

    protected void setTestName(String value) {
        this.testName = value;
    }
}

