/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendTextException;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;

public class ActionText
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "keyboard";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g);
    private CalculatedValue text;
    private int waitChar = 0;

    public ActionText() {
    }

    public ActionText(AtsScript script, ExecuteOptions options, int stopPolicy, String text, ArrayList<String> objectArray) {
        super(script, options, stopPolicy, objectArray);
        this.setText(new CalculatedValue(script, text));
        this.setWaitChar(options.getWaitChar());
    }

    public ActionText(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedValue text) {
        super(script, options, stopPolicy, maxTry, delay, element);
        this.setText(text);
    }

    public ActionText(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedValue text, int wait) {
        super(script, options, stopPolicy, maxTry, delay, element);
        this.setText(text);
        this.setWaitChar(wait);
    }

    @Override
    public StringBuilder getJavaCode() {
        if (this.waitChar > 0) {
            return super.getJavaCode().append(", ").append(this.text.getJavaCode()).append(", ").append(this.waitChar).append(")");
        }
        return super.getJavaCode().append(", ").append(this.text.getJavaCode()).append(")");
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.text.getKeywords());
        return keywords;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        for (int maxTry = 0; maxTry < 3; ++maxTry) {
            try {
                super.execute(ts, testName, testLine, tryNum + maxTry);
                return;
            }
            catch (SendTextException sendTextException) {
                continue;
            }
        }
        this.status.setError(-4, "send keys action fail on the element");
        this.terminateExecution(ts, -4);
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            String safeDataValue = this.getTestElement().enterText(this.status, this.text, ts, this.waitChar);
            this.status.endAction();
            if (this.text.isCrypted()) {
                safeDataValue = "########";
            }
            ts.getRecorder().updateTextScreen(this.status, safeDataValue);
        } else {
            String safeDataValue = this.text.getCalculated();
            if (this.text.isCrypted()) {
                safeDataValue = "########";
            }
            ts.getRecorder().update(this.status.getCode(), this.status.getDuration(), safeDataValue);
        }
        ts.getRecorder().updateScreen(false);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("text", this.text.getCalculated().replaceAll("\"", "\\\""));
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedValue getText() {
        return this.text;
    }

    public void setText(CalculatedValue text) {
        this.text = text;
    }

    public int getWaitChar() {
        return this.waitChar;
    }

    public void setWaitChar(int value) {
        if (value > 5000) {
            value = 5000;
        } else if (value < 0) {
            return;
        }
        this.waitChar = value;
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("callscript -> ").append(subFolder).append(".EnterText");
    }
}

