/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.analytics;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public enum ActionTypesEnum {
    NAVIGATION("ActionWindow", "GotoUrl", "ActionApi"),
    CALL_SCRIPT("ActionCallscript"),
    USER_ACTION("ActionText", "ActionMouse", "ActionSelect"),
    ASSERT("ActionAssert", "ActionProperty"),
    TECHNICAL("ActionChannel", "ActionScripting", "ActionButton", "ActionPropertySet", "EndOfRecording"),
    SSA("StartScriptAction"),
    OTHERS(new String[0]);

    private final List<String> actionTypesList;

    private ActionTypesEnum(String ... actionTypes) {
        this.actionTypesList = List.of(actionTypes);
    }

    public static ActionTypesEnum of(String actionType) {
        return Arrays.stream(ActionTypesEnum.values()).filter(actionTypesEnum -> actionTypesEnum.actionTypesList.stream().anyMatch(s -> {
            String[] actionTypeArray = actionType.split("\\.");
            String actionTypeName = actionTypeArray[actionTypeArray.length - 1];
            return actionTypeName.contains((CharSequence)s);
        })).findFirst().orElse(OTHERS);
    }

    public void executeWithEnum() {
    }

    public static void executeWithEnum(String actionTypeString, Consumer<ActionTypesEnum> enumProcessor) {
        ActionTypesEnum actionType = OTHERS;
        switch (ActionTypesEnum.of(actionTypeString).ordinal()) {
            case 0: {
                actionType = NAVIGATION;
                break;
            }
            case 1: {
                actionType = CALL_SCRIPT;
                break;
            }
            case 2: {
                actionType = USER_ACTION;
                break;
            }
            case 3: {
                actionType = ASSERT;
                break;
            }
            case 4: {
                actionType = TECHNICAL;
                break;
            }
            case 5: {
                break;
            }
        }
        enumProcessor.accept(actionType);
    }
}

