/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.models;

import com.ats.tools.report.models.Bound;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActionElement {
    private String tag;
    private String criterias;
    private int foundElements;
    private int searchDuration;
    private Bound bound;
    private static final String ELEMENT_INDEX_TEMPLATE = "<div class=\"index-icon\">${elementIndex}</div>";

    public String toString() {
        return "Element{tag='" + this.tag + "', criterias='" + this.criterias + "', foundElements=" + this.foundElements + ", searchDuration=" + this.searchDuration + ", bound=" + String.valueOf(this.bound) + "}";
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getCriterias() {
        String pattern = "\\[(-?\\d+)\\]$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(this.criterias);
        if (m.find()) {
            String index = m.group(1);
            Object criteriaWithIndex = this.criterias.replaceFirst(pattern, ELEMENT_INDEX_TEMPLATE.replace("${elementIndex}", index));
            criteriaWithIndex = "<div style='display: flex; align-items: center;'><div>" + ((String)criteriaWithIndex).replace("<div ", "</div><div ") + "</div>";
            return criteriaWithIndex;
        }
        return this.criterias;
    }

    public void setCriterias(String criterias) {
        this.criterias = criterias;
    }

    public int getFoundElements() {
        return this.foundElements;
    }

    public void setFoundElements(int foundElements) {
        this.foundElements = foundElements;
    }

    public int getSearchDuration() {
        return this.searchDuration;
    }

    public void setSearchDuration(int searchDuration) {
        this.searchDuration = searchDuration;
    }

    public Bound getBound() {
        return this.bound;
    }

    public void setBound(Bound bound) {
        this.bound = bound;
    }
}

