/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.models;

import com.ats.tools.report.models.Suite;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class HtmlReportProject {
    private String projectId;
    private String projectUuid;
    private String projectName;
    private String projectVersion;
    private String projectDescription;
    private String projectLogo;
    private String projectWatermark;
    private final String ATS_LOGO = "data:image/png;base64,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";
    private final String ICON_TRUE = "data:image/png;base64,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";
    private final String ICON_FALSE = "data:image/png;base64,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";
    private List<Suite> suites;
    private long started;

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public void setProjectUuid(String projectUuid) {
        this.projectUuid = projectUuid;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public List<Suite> getSuites() {
        return this.suites;
    }

    public void setSuites(List<Suite> suites) {
        this.suites = suites;
    }

    public String getStartedFormatted() {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.started), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return localDateTime.format(formatter);
    }

    public String getStartedFormattedZulu() {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.started), ZoneId.of("UTC"));
        return localDateTime.toString() + "Z";
    }

    public long getStarted() {
        return this.started;
    }

    public void setStarted(long started) {
        this.started = started;
    }

    public String getATS_LOGO() {
        return "data:image/png;base64,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";
    }

    public String getICON_TRUE() {
        return "data:image/png;base64,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";
    }

    public String getICON_FALSE() {
        return "data:image/png;base64,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";
    }

    public String getLogo() {
        return this.projectLogo;
    }

    public void setProjectLogo(String projectLogo) {
        this.projectLogo = projectLogo;
    }

    public void setProjectWatermark(String projectWatermark) {
        this.projectWatermark = projectWatermark;
    }

    public String getWatermark() {
        return this.projectWatermark;
    }
}

