/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.desktop;

import com.ats.AtsSingleton;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.DesktopResponse;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;

public class W3CParams {
    private static final String NO_SESSION_ID = "no-session-id";
    public SystemDriver.HttpMethod method;
    public StringBuilder url = new StringBuilder();
    private final Map<Integer, String> commandTypeMap = Map.of(1, "Recorder");
    private final Map<Integer, String> commandSTypeMap = Map.ofEntries(Map.entry(0, "Stop"), Map.entry(1, "Screenshot"), Map.entry(2, "Start"), Map.entry(3, "Create"), Map.entry(4, "Image"), Map.entry(5, "Value"), Map.entry(6, "Data"), Map.entry(7, "Status"), Map.entry(8, "Element"), Map.entry(9, "Position"), Map.entry(10, "Download"), Map.entry(11, "ImageMobile"), Map.entry(12, "CreateMobile"), Map.entry(13, "ScreenshotMobile"), Map.entry(14, "Summary"));

    public ObjectNode get(Integer type, Integer subType, String data) throws Exception {
        String strType = this.commandTypeMap.get(type);
        String strSType = this.commandSTypeMap.get(subType);
        if (strType != null && strSType != null) {
            return this.get(strType, strSType, data);
        }
        return null;
    }

    private IDriverInfo getDriverInfo() {
        if (AtsSingleton.getInstance().getCurrentChannel().getDriverEngine() != null) {
            return AtsSingleton.getInstance().getCurrentChannel().getDriverEngine().getDriverInfo();
        }
        return null;
    }

    public ObjectNode get(String type, String subType, String data) throws Exception {
        String sessionId = NO_SESSION_ID;
        if (this.getDriverInfo() != null) {
            sessionId = this.getDriverInfo().getSessionId();
        }
        ObjectNode result = null;
        this.url.append("session").append("/").append(sessionId).append("/").append("ats").append("/").append(type.toLowerCase()).append("/").append(subType.toLowerCase());
        this.method = SystemDriver.HttpMethod.POST;
        block3 : switch (type.toLowerCase()) {
            case "recorder": {
                switch (subType.toLowerCase()) {
                    case "image": {
                        result = this.convertToImage(data);
                        break block3;
                    }
                    case "start": {
                        result = this.convertToStart(data);
                        break block3;
                    }
                    case "create": {
                        result = this.convertToCreate(data);
                        break block3;
                    }
                    case "createmobile": {
                        result = this.convertToCreateMobile(data);
                        break block3;
                    }
                    case "imagemobile": {
                        result = this.convertToImageMobile(data);
                        break block3;
                    }
                    case "value": {
                        result = this.convertToValue(data);
                        break block3;
                    }
                    case "data": {
                        result = this.convertToData(data);
                        break block3;
                    }
                    case "status": {
                        result = this.convertToStatus(data);
                        break block3;
                    }
                    case "element": {
                        result = this.convertToElement(data);
                        break block3;
                    }
                    case "position": {
                        result = this.convertToPosition(data);
                        break block3;
                    }
                    case "summary": {
                        result = this.convertToSummary(data);
                        break block3;
                    }
                    case "screenshot": {
                        result = this.convertToScreenShot(data);
                        break block3;
                    }
                    case "screenshotmobile": {
                        result = this.convertToScreenShotMobile(data);
                        break block3;
                    }
                    case "stop": {
                        result = this.convertToStop(data);
                    }
                }
            }
        }
        if (result != null) {
            JsonNode newNode;
            if (this.getDriverInfo() != null && (newNode = this.getDriverInfo().toJson()) != null && newNode.has("driverInfo") && newNode.get("driverInfo").has("sessionId")) {
                result.set("driverInfo", newNode.get("driverInfo"));
            }
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode rootNode = mapper.createObjectNode();
            rootNode.set("value", (JsonNode)result);
            result = rootNode;
        }
        return result;
    }

    public DesktopResponse getDesktopResponse(JsonNode result) {
        DesktopResponse response = new DesktopResponse();
        if (result.has("error")) {
            if (result.get("error").has("message")) {
                response.setErrorCode(400);
                response.setErrorMessage(result.get("error").get("message").toString());
            } else {
                response.setErrorCode(400);
                response.setErrorMessage("unknow error");
            }
        } else {
            response.setErrorCode(200);
            response.setErrorMessage("");
        }
        return response;
    }

    private ObjectNode convertToImage(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            JsonNodeFactory factory = JsonNodeFactory.instance;
            ArrayNode screenRect = factory.arrayNode();
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            for (int i = 0; i < 4; ++i) {
                screenRect.add(Integer.parseInt(parts[i]));
            }
            postData.set("screenRect", (JsonNode)screenRect);
            postData.put("isRef", Boolean.parseBoolean(parts[4]));
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/image action");
        }
    }

    private ObjectNode convertToImageMobile(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            JsonNodeFactory factory = JsonNodeFactory.instance;
            ArrayNode screenRect = factory.arrayNode();
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            for (int i = 0; i < 4; ++i) {
                screenRect.add(Integer.parseInt(parts[i]));
            }
            postData.set("screenRect", (JsonNode)screenRect);
            postData.put("isRef", Boolean.parseBoolean(parts[4]));
            postData.put("url", parts[5]);
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/image/mobile action");
        }
    }

    private ObjectNode convertToStart(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            postData.put("id", parts[0]);
            postData.put("fullName", parts[1]);
            postData.put("description", parts[2]);
            postData.put("author", parts[3]);
            postData.put("groups", parts[4]);
            postData.put("preRequisites", parts[5]);
            postData.put("externalId", parts[6]);
            postData.put("videoQuality", Integer.parseInt(parts[7]));
            postData.put("started", parts[8]);
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/start action");
        }
    }

    private ObjectNode convertToCreate(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            JsonNodeFactory factory = JsonNodeFactory.instance;
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            ArrayNode screenRect = factory.arrayNode();
            for (int i = 0; i < 4; ++i) {
                screenRect.add(Integer.parseInt(parts[i + 5]));
            }
            postData.put("actionType", parts[0]);
            postData.put("line", Integer.parseInt(parts[1]));
            postData.put("script", parts[2]);
            postData.put("timeLine", Long.parseLong(parts[3]));
            postData.put("channelName", parts[4]);
            postData.set("channelDimension", (JsonNode)screenRect);
            postData.put("sync", Boolean.parseBoolean(parts[9]));
            postData.put("stop", Boolean.parseBoolean(parts[10]));
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/create action");
        }
    }

    private ObjectNode convertToCreateMobile(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            JsonNodeFactory factory = JsonNodeFactory.instance;
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            ArrayNode screenRect = factory.arrayNode();
            for (int i = 0; i < 4; ++i) {
                screenRect.add(Integer.parseInt(parts[i + 5]));
            }
            postData.put("actionType", parts[0]);
            postData.put("line", Integer.parseInt(parts[1]));
            postData.put("script", parts[2]);
            postData.put("timeline", Long.parseLong(parts[3]));
            postData.put("channelName", parts[4]);
            postData.set("channelDimension", (JsonNode)screenRect);
            postData.put("url", parts[9]);
            postData.put("sync", Boolean.parseBoolean(parts[10]));
            postData.put("stop", Boolean.parseBoolean(parts[11]));
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/create/mobile action");
        }
    }

    private ObjectNode convertToValue(String data) throws Exception {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            postData.put("v", data);
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/value action");
        }
    }

    private ObjectNode convertToData(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            if (parts.length > 0) {
                postData.put("v1", parts[0]);
                if (parts.length > 1) {
                    postData.put("v2", parts[1]);
                } else {
                    postData.put("v2", "");
                }
            } else {
                postData.put("v1", "");
                postData.put("v2", "");
            }
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/data action");
        }
    }

    private ObjectNode convertToStatus(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            postData.put("error", Integer.parseInt(parts[0]));
            postData.put("duration", Long.parseLong(parts[1]));
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/status action");
        }
    }

    private ObjectNode convertToElement(String data) throws Exception {
        try {
            JsonNodeFactory factory = JsonNodeFactory.instance;
            String[] parts = data.split("\n");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            ArrayNode screenRect = factory.arrayNode();
            for (int i = 0; i < 4; ++i) {
                screenRect.add(Integer.parseInt(parts[i]));
            }
            postData.set("elementBound", (JsonNode)screenRect);
            postData.put("searchDuration", Long.parseLong(parts[4]));
            postData.put("numElements", Integer.parseInt(parts[5]));
            postData.put("searchCriterias", parts[6]);
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/element action");
        }
    }

    private ObjectNode convertToPosition(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            postData.put("hpos", parts[0]);
            postData.put("hposValue", Integer.parseInt(parts[1]));
            postData.put("vpos", parts[2]);
            postData.put("vposValue", Integer.parseInt(parts[3]));
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/position action");
        }
    }

    private ObjectNode convertToSummary(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            postData.put("passed", Boolean.parseBoolean(parts[0]));
            postData.put("actions", Integer.parseInt(parts[1]));
            postData.put("suiteName", parts[2]);
            postData.put("testName", parts[3]);
            postData.put("data", parts[4]);
            if (parts.length > 5) {
                postData.put("errorScript", parts[5]);
                postData.put("errorLine", Integer.parseInt(parts[6]));
                postData.put("errorMessage", parts[7]);
            }
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/summary action");
        }
    }

    private ObjectNode convertToScreenShot(String data) throws Exception {
        try {
            String[] parts = data.split("\n");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            postData.put("x", Integer.parseInt(parts[0]));
            postData.put("y", Integer.parseInt(parts[1]));
            postData.put("w", Integer.parseInt(parts[2]));
            postData.put("h", Integer.parseInt(parts[3]));
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/screenshot action");
        }
    }

    private ObjectNode convertToScreenShotMobile(String data) throws Exception {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            postData.put("uri", data);
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/screenshot/mobile action");
        }
    }

    private ObjectNode convertToStop(String data) throws Exception {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode postData = mapper.createObjectNode();
            return postData;
        }
        catch (Exception e) {
            throw new Exception("cannot convert " + data + " string to json for the recorder/stop action");
        }
    }
}

