/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.element.FoundElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.generator.objects.MouseDirection;
import com.ats.tools.ResourceContent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.testng.collections.Sets;

public class IEDriverEngine
extends WebDriverEngine {
    private final Set<String> windows = Sets.newLinkedHashSet();

    public IEDriverEngine(Channel channel, ActionStatus status, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, boolean enableLearning) {
        super(channel, driverInfo, systemDriver, props, enableLearning);
        this.JS_ELEMENT_PARENTS = ResourceContent.getParentElementJavaScriptIE();
        this.JS_ELEMENT_FROM_POINT = "var result=null;var parent=document;var e=parent.elementFromPoint(arguments[1],arguments[2]);if(e && e!=arguments[0]){var r=e.getBoundingClientRect();result=[e, e.tagName, e.getAttribute('inputmode')=='numeric', e.getAttribute('type')=='password', r.x+0.0001, r.y+0.0001, r.width+0.0001, r.height+0.0001, r.left+0.0001, r.top+0.0001, 0.0001, 0.0001, {},false];};";
        InternetExplorerOptions ieOptions = new InternetExplorerOptions();
        ieOptions.attachToEdgeChrome();
        ieOptions.withEdgeExecutablePath(systemDriver.getMsEdgePath());
        ieOptions.setCapability("ignoreProtectedModeSettings", true);
        this.launchDriver(status, (MutableCapabilities)ieOptions);
        if (status.isPassed() && !"11".equals(channel.getApplicationVersion())) {
            status.setError(-19, "cannot start channel with IE" + channel.getApplicationVersion() + " (Only IE11 is supported by ATS)");
        }
        this.executeToFront();
    }

    @Override
    public void setWindowToFront() {
        super.setWindowToFront();
        this.executeToFront();
    }

    private void executeToFront() {
        try {
            this.driver.executeAsyncScript("var callback=arguments[arguments.length-1];var result=setTimeout(function(){window.focus();},1000);callback(result);", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void scroll(FoundElement element) {
        try {
            super.scroll(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY, boolean offset) {
        this.desktopMoveToElement(element, position, (int)(element.getWidth() / 2.0), (int)(element.getHeight() / 2.0) - 8);
        this.getSystemDriver().mouseDown();
    }

    @Override
    public void drop(FoundElement element, MouseDirection md, boolean desktopDriver) {
        this.getSystemDriver().mouseRelease();
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
        this.getSystemDriver().mouseMiddleClick();
    }

    @Override
    public void doubleClick() {
        this.getSystemDriver().doubleClick();
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList, int waitSearch, ActionTestScript topScript) {
        if (element.isNumeric()) {
            for (SendKeyData sequence : textActionList) {
                element.executeScript(status, "value='" + sequence.getData() + "'", true);
            }
        } else {
            try {
                for (SendKeyData sequence : textActionList) {
                    element.getWebElement().sendKeys(new CharSequence[]{sequence.getSequenceWeb(true)});
                }
            }
            catch (Exception e) {
                status.setError(-4, e.getMessage());
            }
        }
    }

    @Override
    public boolean switchWindow(ActionStatus status, String type, String data, boolean regexp, boolean refresh) {
        super.switchWindow(status, type, data, regexp, refresh);
        if (status.isPassed()) {
            this.executeJavaScript(status, "setTimeout(function(){window.focus();},1000);", true);
            this.channel.setWindowToFront();
            this.executeToFront();
            this.channel.sleep(2000);
            this.getSystemDriver().updateWindowHandle(this.channel);
        }
        return true;
    }

    @Override
    protected Set<String> getDriverWindowsList() {
        Set<String> driverList = super.getDriverWindowsList();
        driverList.parallelStream().forEach(s -> this.windows.add((String)s));
        Iterator<String> iterator = this.windows.iterator();
        while (iterator.hasNext()) {
            if (driverList.contains(iterator.next())) continue;
            iterator.remove();
        }
        return this.windows;
    }
}

