/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.webservices;

import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.engines.webservices.ApiExecutor;
import com.ats.executor.drivers.engines.webservices.AtsCookieJar;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.ActionApi;
import java.io.File;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RestApiExecutor
extends ApiExecutor {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APP_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final String MULTIPART_DATA = "multipart/form-data";
    private static final String APP_JSON = "application/json";
    private static final String APP_XML = "application/xml";

    public RestApiExecutor(PrintStream logStream, AtsCookieJar cookieJar, OkHttpClient client, int timeout, int maxTry, Channel channel, String wsUrl) {
        super(logStream, cookieJar, client, timeout, maxTry, channel);
        if (!((String)wsUrl).endsWith("/")) {
            wsUrl = (String)wsUrl + "/";
        }
        this.setUri((String)wsUrl);
    }

    private String getUrlEncodedData(CalculatedProperty p) {
        String key = p.getName();
        if (key == null || key.isEmpty() || "JSON_DATA".equals(key) || "XML_DATA".equals(key)) {
            return URLEncoder.encode(p.getValue().getCalculated(), StandardCharsets.UTF_8);
        }
        return URLEncoder.encode(p.getName(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode(p.getValue().uncrypt(this.channel.getTestScript(), p.getValue().getCalculated()), StandardCharsets.UTF_8);
    }

    private void addDataPart(CalculatedProperty p, MultipartBody.Builder body, Script script) {
        String key = p.getName();
        CalculatedValue value = p.getValue();
        value.uncryptData(script);
        value.uncrypt(script);
        String valueString = value.getCalculated();
        if (key == null || key.isEmpty() || "JSON_DATA".equals(key) || "XML_DATA".equals(key)) {
            if (!this.checkFileData(valueString, "file", body)) {
                body.addFormDataPart("value", value.getCalculated());
            }
        } else if (!this.checkFileData(valueString, key, body)) {
            body.addFormDataPart(key, valueString);
        }
    }

    private boolean checkFileData(String value, String key, MultipartBody.Builder body) {
        File file;
        if (value.startsWith("file:///") && (file = new File(value.substring(8))).exists()) {
            RequestBody fileBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)"application/octet-stream; charset=utf-8"));
            body.addFormDataPart(key, file.getName(), fileBody);
            return true;
        }
        return false;
    }

    @Override
    public void execute(ActionStatus status, ActionApi api) {
        super.execute(status, api);
        if (api.getMethod().getCalculated().startsWith("file:///")) {
            this.loadLocalFile("json", api.getMethod().getCalculated());
            return;
        }
        String fullUri = this.getMethodUri().toString();
        boolean addContentType = true;
        boolean multipartData = false;
        Request.Builder requestBuilder = new Request.Builder();
        for (Map.Entry header : this.headerProperties.entrySet()) {
            if (CONTENT_TYPE.equals(header.getKey())) {
                addContentType = false;
                if (((String)header.getValue()).contains(MULTIPART_DATA)) {
                    multipartData = true;
                }
            }
            requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
        }
        String apiType = api.getType().toUpperCase();
        if ("GET".equals(apiType) || "DELETE".equals(apiType)) {
            Object data = "";
            if (api.getData() != null && !api.getData().isEmpty()) {
                data = "?" + api.getData().stream().map(this::getUrlEncodedData).collect(Collectors.joining("&"));
            }
            requestBuilder.url(fullUri + (String)data);
            if ("GET".equals(apiType)) {
                requestBuilder.get();
            } else {
                requestBuilder.delete();
            }
        } else {
            requestBuilder.url(fullUri);
            RequestBody body = null;
            if (api.getData() != null) {
                Script script = api.getScript();
                if (api.getData().size() == 1 && !multipartData) {
                    CalculatedProperty prop = api.getData().getFirst();
                    if (addContentType) {
                        if ("JSON_DATA".equals(prop.getName())) {
                            requestBuilder.addHeader(CONTENT_TYPE, APP_JSON);
                        } else if ("XML_DATA".equals(prop.getName())) {
                            requestBuilder.addHeader(CONTENT_TYPE, APP_XML);
                        } else {
                            requestBuilder.addHeader(CONTENT_TYPE, APP_URL_ENCODED);
                        }
                    }
                    CalculatedValue value = prop.getValue();
                    body = RequestBody.Companion.create(value.uncrypt(this.channel.getTestScript(), value.getCalculated()), null);
                } else {
                    MultipartBody.Builder multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
                    api.getData().forEach(p -> this.addDataPart((CalculatedProperty)p, multipartBody, script));
                    if (addContentType) {
                        requestBuilder.addHeader(CONTENT_TYPE, MULTIPART_DATA);
                    }
                    body = multipartBody.build();
                }
            }
            if (body == null) {
                body = RequestBody.Companion.create("", null);
            }
            if ("PATCH".equals(apiType)) {
                requestBuilder.patch(body);
            } else if ("PUT".equals(apiType)) {
                requestBuilder.put(body);
            } else {
                requestBuilder.post(body);
            }
        }
        this.executeRequest(status, requestBuilder.build());
    }
}

