/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.listeners;

import com.ats.AtsSingleton;
import com.ats.generator.ATS;
import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.SuitesReport;
import com.ats.tools.report.SuitesReportItem;
import com.ats.tools.report.context.reader.FullReportContextExecutionReader;
import com.ats.tools.report.generators.CampaignReportGenerator;
import com.ats.tools.report.models.ReportItem;
import com.ats.tools.report.models.ReportSettings;
import com.diogonunes.jcolor.Ansi;
import com.diogonunes.jcolor.Attribute;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.testng.IExecutionListener;

public class ExecutionListener
implements IExecutionListener {
    private static final Gson gson = new Gson();
    private static final String ATS_REPORT_LEVEL_FROM_COMMANDLINE = "ats.report";
    private static final List<String> trueList = Arrays.asList("on", "true", "1", "yes", "y");
    private static SuitesReport suiteReport = null;
    private static SuitesReportItem suiteItem = null;

    private static void setSuitesFile(File value) {
        File outputDir = value.getParentFile();
        outputDir.mkdirs();
        AtsSingleton.getInstance().setJsonSuitesFilePath(value.getAbsolutePath());
        AtsSingleton.getInstance().setAtsOutputFolder(outputDir.toPath());
        AtsSingleton.getInstance().setProjectPath(outputDir.getParentFile().getAbsolutePath());
    }

    public static void startSuite(SuitesReportItem suite) {
        suiteItem = suite;
        try {
            File jsonSuiteFile = AtsSingleton.getInstance().getJsonSuitesFile();
            if (jsonSuiteFile == null) {
                jsonSuiteFile = suiteItem.getSuitesFile();
                ExecutionListener.setSuitesFile(jsonSuiteFile);
                suiteReport = new SuitesReport(suiteItem);
            } else {
                JsonReader reader = new JsonReader((Reader)new FileReader(jsonSuiteFile));
                suiteReport = (SuitesReport)gson.fromJson(reader, SuitesReport.class);
                reader.close();
                suiteReport.add(suiteItem);
            }
            FileWriter writer = new FileWriter(jsonSuiteFile);
            gson.toJson((Object)suiteReport, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void onExecutionStart() {
        super.onExecutionStart();
        System.out.println("-------------------------------------------------------");
        System.out.println("   ATS ver. " + ATS.getAtsVersion() + "   ( " + Ansi.colorize((String)"https://actiontestscript.org", (Attribute[])new Attribute[]{Attribute.BRIGHT_BLUE_TEXT()}) + " )");
        System.out.println("-------------------------------------------------------");
    }

    public void onExecutionFinish() {
        super.onExecutionFinish();
        if (suiteItem.isNoSuiteLaunch()) {
            AtsLogger.printLog(" ----------------------------------------------- ");
            AtsLogger.printLog("         ATS test execution complete             ");
            AtsLogger.printLog(" ----------------------------------------------- ");
        } else {
            AtsLogger.printLog(" ----------------------------------------------- ");
            AtsLogger.printLog("         ATS suite execution complete            ");
            AtsLogger.printLog(" ----------------------------------------------- ");
        }
        Path outputFolderPath = AtsSingleton.getInstance().getAtsOutputFolder();
        String cmdATSReport = System.getProperty("ats-report");
        int devReport = 0;
        String atsReportEnv = System.getenv("ATS_REPORT");
        if (atsReportEnv != null) {
            devReport = Utils.string2Int(atsReportEnv, 0);
        }
        if (cmdATSReport != null) {
            devReport = Utils.string2Int(cmdATSReport, 0);
        }
        String cmdMGTReport = System.getProperty("mgt-report");
        int mgtReport = 0;
        if (cmdMGTReport != null) {
            mgtReport = Utils.string2Int(cmdMGTReport, 0);
        }
        String cmdvalidReport = System.getProperty("validation-report");
        int validReport = 0;
        if (cmdvalidReport != null) {
            validReport = trueList.contains(cmdvalidReport.toLowerCase()) ? 1 : 0;
        }
        boolean hideDurations = Boolean.parseBoolean(System.getProperty("hide-duration"));
        boolean atsvHtmlReport = Boolean.parseBoolean(System.getProperty("atsv-html")) || trueList.contains(((String)StringUtils.defaultIfBlank((CharSequence)System.getenv("ATSV_HTML"), (CharSequence)"")).toLowerCase());
        boolean reportingAsk = false;
        for (SuitesReportItem item : ExecutionListener.suiteReport.suites) {
            if (!item.isReporting()) continue;
            reportingAsk = true;
        }
        String atsReportLevelProperty = System.getProperty(ATS_REPORT_LEVEL_FROM_COMMANDLINE);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{atsReportLevelProperty}) && devReport <= 0) {
            devReport = Integer.parseInt(atsReportLevelProperty);
        }
        if (devReport + mgtReport + validReport != 0 || reportingAsk) {
            AtsLogger.printLog("generate ATS reports in output folder", outputFolderPath.toAbsolutePath().toString());
            File jsonSuiteFile = AtsSingleton.getInstance().getJsonSuitesFile();
            if (jsonSuiteFile != null && jsonSuiteFile.exists()) {
                long startTime = System.nanoTime();
                try {
                    ReportSettings reportSettings = new ReportSettings(outputFolderPath, jsonSuiteFile.toPath(), devReport, validReport == 1, hideDurations, atsvHtmlReport, false);
                    FullReportContextExecutionReader reader = new FullReportContextExecutionReader(reportSettings, ReportItem.fromSuitesReportItem(suiteItem));
                    new CampaignReportGenerator(reader).generateSuitsHtmlReports();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Duration generationDuration = Duration.ofNanos(System.nanoTime() - startTime);
                AtsLogger.printLog(String.format("reports generation terminated in %d second(s) %d millisecond(s)", generationDuration.toSeconds(), generationDuration.toMillisPart()));
            }
        }
        AtsSingleton.getInstance().terminateOutputLogs();
    }
}

