/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.parsers;

import com.ats.generator.parsers.Lexer;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.transform.Transformer;
import com.ats.script.AtsScript;
import com.ats.script.ScriptHeader;
import com.ats.tools.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;

public class ScriptParser {
    public static final String ATS_SEPARATOR = "->";
    public static final int ATS_SEPARATOR_SIZE = "->".length();
    public static final String ATS_ASSIGN_SEPARATOR = "=>";
    private Lexer lexer;

    public ScriptParser(Lexer lexer) {
        this.lexer = lexer;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public boolean isGenerator() {
        return this.lexer.isGenerator();
    }

    public void addScript() {
        this.lexer.addScript();
    }

    private String getDataGroup(Matcher m, int index) {
        if (m.groupCount() > index - 1 && m.group(index) != null) {
            return m.group(index).trim();
        }
        return "";
    }

    private String getHeaderData(String data) {
        return data.substring(data.indexOf(ATS_SEPARATOR) + ATS_SEPARATOR_SIZE).trim();
    }

    public void parse(AtsScript script, ScriptHeader header, String data) {
        if (ScriptHeader.GROUPS_MATCH.test(data)) {
            header.parseGroups(this.getHeaderData(data));
        } else if (ScriptHeader.DESCRIPTION_MATCH.test(data)) {
            header.setDescription(this.getHeaderData(data));
        } else if (ScriptHeader.MEMO_MATCH.test(data)) {
            header.setMemo(this.getHeaderData(data));
        } else if (ScriptHeader.PRE_PROCESSING_MATCH.test(data)) {
            header.setPreprocessing(this.getHeaderData(data));
        } else if (ScriptHeader.POST_PROCESSING_MATCH.test(data)) {
            header.setPostprocessing(this.getHeaderData(data));
        } else if (ScriptHeader.ID_MATCH.test(data)) {
            header.setId(this.getHeaderData(data));
        } else if (ScriptHeader.EXTERNAL_ID_MATCH.test(data)) {
            header.setExternalId(this.getHeaderData(data));
        } else if (ScriptHeader.UUID_MATCH.test(data)) {
            header.setUuid(this.getHeaderData(data));
        } else if (ScriptHeader.DATE_CREATED_MATCH.test(data)) {
            header.setCreatedAt(Utils.parseDateFormat(this.getHeaderData(data)));
        } else if (ScriptHeader.AUTHOR_MATCH.test(data)) {
            header.setAuthor(this.getHeaderData(data));
        } else if (ScriptHeader.MODIFIED_AT_MATCH.test(data)) {
            header.setModifiedAt(Utils.parseDateFormat(this.getHeaderData(data)));
        } else if (ScriptHeader.MODIFIED_BY_MATCH.test(data)) {
            header.setModifiedBy(this.getHeaderData(data));
        } else if (ScriptHeader.PREREQUISITE_MATCH.test(data)) {
            header.setPrerequisite(this.getHeaderData(data));
        } else if (data.regionMatches(true, 0, "var", 0, Variable.SCRIPT_LABEL_LENGTH)) {
            ArrayList<String> dataArray = new ArrayList<String>(Arrays.asList(this.getHeaderData(data).split(ATS_SEPARATOR)));
            if (dataArray.size() > 0) {
                String name = dataArray.remove(0).trim();
                String value = "";
                Transformer transformer = new Transformer();
                if (dataArray.size() > 0) {
                    String nextData = dataArray.remove(0).trim();
                    Matcher m = Transformer.TRANSFORM_PATTERN.matcher(nextData);
                    if (m != null && m.find()) {
                        transformer = Transformer.createTransformer(this.getDataGroup(m, 1), this.getDataGroup(m, 2));
                        if (dataArray.size() > 0) {
                            value = dataArray.remove(0).trim();
                        }
                    } else {
                        value = nextData;
                    }
                }
                script.addVariable(name, new CalculatedValue(script, value), transformer, data.startsWith("var-x"));
            }
        } else if (ScriptHeader.RETURN_MATCH.test(data)) {
            String[] returnsData = this.getHeaderData(data).split(ATS_SEPARATOR);
            CalculatedValue[] returns = new CalculatedValue[returnsData.length];
            for (int i = 0; i < returnsData.length; ++i) {
                returns[i] = new CalculatedValue(script, returnsData[i].trim());
            }
            script.setReturns(returns);
        } else {
            boolean actionDisabled = false;
            if (data.startsWith("//")) {
                data = data.substring(2);
                actionDisabled = true;
            }
            this.lexer.createAction(script, data, actionDisabled);
        }
    }
}

