/*
 * Decompiled with CFR 0.152.
 */
package com.ats.learning;

import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.learning.IAtsLearning;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;

public class AtsLearning
implements IAtsLearning {
    private static final String ATS_SUITE_LEARNING = "ats-learning.jsonl";
    private FileWriter fw;

    public AtsLearning(Path suiteOutputPath) {
        try {
            this.fw = new FileWriter(suiteOutputPath.getParent().resolve(ATS_SUITE_LEARNING).toFile(), true);
        }
        catch (IOException e) {
            this.fw = null;
            e.printStackTrace();
        }
    }

    @Override
    public void terminate() {
        if (this.fw != null) {
            try {
                this.fw.close();
                this.fw = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void saveAtsLearning(TestElement testElement, IDriverEngine engine, SearchedElement searchedElement) {
        String userContent = "this html element with it's parents tree and their attributes:" + engine.getParentsDomCode(testElement.getFoundElement().getValue()) + "\nin order to find this element, I use following ATS code:\nELEMENT1 [one or more comma separated attributes using format: \"key=value\"] etc...";
        String assistantContent = searchedElement.getAtsLearning();
        try {
            JsonObject user = new JsonObject();
            user.addProperty("role", "user");
            user.addProperty("content", userContent);
            JsonObject assistant = new JsonObject();
            assistant.addProperty("role", "assistant");
            assistant.addProperty("content", assistantContent);
            JsonArray messages = new JsonArray();
            messages.add((JsonElement)user);
            messages.add((JsonElement)assistant);
            JsonObject data = new JsonObject();
            data.add("messages", (JsonElement)messages);
            this.fw.write(data.toString() + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

