/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.summary;

import com.ats.tools.report.analytics.ActionTypesEnum;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.ReportDurationData;
import com.ats.tools.report.utils.TimeUtil;
import java.time.Duration;

public class DurationCalculator {
    private Duration navigationDuration = Duration.ZERO;
    private Duration callScriptDuration = Duration.ZERO;
    private Duration userActionDuration = Duration.ZERO;
    private Duration assertionDuration = Duration.ZERO;
    private Duration technicalDuration = Duration.ZERO;
    private Duration othersDuration = Duration.ZERO;
    private final Duration miscellaneousDuration;

    public DurationCalculator(Duration miscellaneous) {
        this.miscellaneousDuration = miscellaneous;
    }

    public void addActionDuration(Action action) {
        Duration actionDuration = Duration.ofMillis(action.getDuration());
        ActionTypesEnum actionType = ActionTypesEnum.of(action.getType());
        switch (actionType) {
            case NAVIGATION: {
                this.navigationDuration = this.navigationDuration.plus(actionDuration);
                break;
            }
            case CALL_SCRIPT: {
                this.callScriptDuration = this.callScriptDuration.plus(actionDuration);
                break;
            }
            case USER_ACTION: {
                this.userActionDuration = this.userActionDuration.plus(actionDuration);
                break;
            }
            case ASSERT: {
                this.assertionDuration = this.assertionDuration.plus(actionDuration);
                break;
            }
            case TECHNICAL: {
                this.technicalDuration = this.technicalDuration.plus(actionDuration);
                break;
            }
            case OTHERS: {
                this.othersDuration = this.othersDuration.plus(actionDuration);
            }
        }
    }

    public ReportDurationData getReportDuration() {
        String totalFunctionalDuration = TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(this.userActionDuration.toMillis()) + TimeUtil.roundUpToSecond(this.assertionDuration.toMillis()));
        String totalTechnicalDuration = TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(this.technicalDuration.toMillis()) + TimeUtil.roundUpToSecond(this.othersDuration.toMillis()) + TimeUtil.roundUpToSecond(this.navigationDuration.toMillis()) + TimeUtil.roundUpToSecond(this.callScriptDuration.toMillis()) + TimeUtil.roundUpToSecond(this.miscellaneousDuration.toMillis()));
        return new ReportDurationData(totalFunctionalDuration, totalTechnicalDuration, TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(this.navigationDuration.toMillis())), TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(this.callScriptDuration.toMillis())), TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(this.userActionDuration.toMillis())), TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(this.assertionDuration.toMillis())), TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(this.technicalDuration.toMillis())), TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(this.othersDuration.toMillis())), TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(this.miscellaneousDuration.toMillis())));
    }
}

