/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.channels.Channel;
import com.ats.script.Script;
import com.ats.script.actions.ActionWindow;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.tools.logger.ExecutionLogger;
import com.google.gson.JsonObject;
import java.util.function.Predicate;

public class ActionWindowState
extends ActionWindow {
    public static final String MAXIMIZE = "maximize";
    public static final String REDUCE = "reduce";
    public static final String RESTORE = "restore";
    public static final String CLOSE = "close";
    public static final String SCRIPT_STATE_LABEL = "window-state";
    public static final String SCRIPT_CLOSE_LABEL = "window-close";
    public static final Predicate<String> PREDICATE_STATE = g -> SCRIPT_STATE_LABEL.equals(g);
    public static final Predicate<String> PREDICATE_CLOSE = g -> SCRIPT_CLOSE_LABEL.equals(g);
    private String state = "close";

    public ActionWindowState() {
    }

    public ActionWindowState(Script script, ExecuteOptions options, String state) {
        super(script, options);
        this.setState(state);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append("\"").append(this.state).append("\")");
        return codeBuilder;
    }

    @Override
    public String exec(Channel channel, ExecutionLogger logger) {
        if (CLOSE.equals(this.state)) {
            channel.closeWindow(this.status);
        } else {
            channel.windowState(this.status, this.state);
            if (!REDUCE.equals(this.state)) {
                channel.getDriverEngine().updateDimensions();
                this.getCurrentChannel().sleep();
                this.getCurrentChannel().getSystemDriver().updateVisualImage(this.getCurrentChannel().getDimension(), false);
            }
        }
        return this.state;
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("state", this.state);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        if (state != null && (MAXIMIZE.equals(state = state.toLowerCase()) || REDUCE.equals(state) || CLOSE.equals(state))) {
            this.state = state;
            return;
        }
        this.state = RESTORE;
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("callscript -> ").append(subFolder).append(".WindowsState");
    }
}

