/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

import com.ats.driver.AtsManager;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.tools.wait.IWaitGuiReady;
import com.ats.tools.wait.WaitGuiReady;
import com.ats.tools.wait.WaitGuiReadyInfo;
import com.ats.tools.wait.WaitGuiReadyWithValues;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class AtsClassLoader
extends ClassLoader {
    private ArrayList<String> testClasses = new ArrayList();
    private IWaitGuiReady waitGuiReady;

    public Class<ActionTestScript> loadTestScriptClass(ActionStatus status, String name) {
        Class<ActionTestScript> testScriptClass = this.loadAtsClass(name);
        if (testScriptClass == null) {
            for (String s : this.testClasses) {
                if (!name.equalsIgnoreCase(s)) continue;
                return this.loadAtsClass(s);
            }
            status.setError(422, "ATS script not found -> " + name + "\n");
        }
        return testScriptClass;
    }

    private Class<ActionTestScript> loadAtsClass(String name) {
        try {
            return this.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.findClass(name);
        }
        catch (Error | Exception e) {
            return null;
        }
    }

    @Override
    public Class<?> findClass(String name) {
        byte[] bt = this.loadAtsScriptClass(name);
        if (bt != null) {
            try {
                return this.defineClass(name, bt, 0, bt.length);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return null;
    }

    private byte[] loadAtsScriptClass(String className) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(className.replace(".", "/") + ".class");
        if (is != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int len = 0;
            try {
                while ((len = is.read()) != -1) {
                    bos.write(len);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] data = bos.toByteArray();
            try {
                bos.close();
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return data;
        }
        return null;
    }

    public IWaitGuiReady getWaitGuiReady() {
        return this.waitGuiReady;
    }

    public AtsClassLoader(AtsManager atsManager) {
        Class<IWaitGuiReady> wait = this.findCustomWaitClass();
        if (wait != null) {
            try {
                this.waitGuiReady = wait.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        if (this.waitGuiReady == null) {
            this.waitGuiReady = atsManager.getWaitEnterText() > 0 || atsManager.getWaitGotoUrl() > 0 || atsManager.getWaitMouseMove() > 0 || atsManager.getWaitSearch() > 0 || atsManager.getWaitSwitchWindow() > 0 ? new WaitGuiReadyWithValues(atsManager.getWaitEnterText(), atsManager.getWaitGotoUrl(), atsManager.getWaitMouseMove(), atsManager.getWaitSearch(), atsManager.getWaitSwitchWindow()) : new WaitGuiReady();
        }
        ArrayList<String> files = new ArrayList<String>();
        try {
            Enumeration<URL> res = this.getClass().getClassLoader().getResources("");
            while (res.hasMoreElements()) {
                URL url = res.nextElement();
                if (!"file".equals(url.getProtocol())) continue;
                files.add(url.getFile());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        files.forEach(f -> this.walkFiles(f.length() - 1, (String)f));
    }

    private void walkFiles(int offset, String path) {
        File root = new File(path);
        File[] list = root.listFiles();
        if (list == null) {
            return;
        }
        for (File f : list) {
            if (f.isDirectory()) {
                this.walkFiles(offset, f.getAbsolutePath());
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            String relativePath = f.getPath().substring(offset);
            this.testClasses.add(relativePath.substring(0, relativePath.length() - 6).replace(File.separator, "."));
        }
    }

    private Class<IWaitGuiReady> findCustomWaitClass() {
        String[] files;
        String classpath = System.getProperty("java.class.path");
        for (String path : files = classpath.split(System.getProperty("path.separator"))) {
            Class<IWaitGuiReady> customWaitClass = this.findWaitGuiClass(path);
            if (customWaitClass == null) continue;
            return customWaitClass;
        }
        return null;
    }

    private Class<IWaitGuiReady> findWaitGuiClass(String filePath) {
        File f = new File(filePath);
        if (f.exists()) {
            return this.findWaitGuiClass(f);
        }
        return null;
    }

    private Class<IWaitGuiReady> findWaitGuiClass(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                int n = 0;
                File[] fileArray = file.listFiles();
                int n2 = fileArray.length;
                if (n < n2) {
                    File child = fileArray[n];
                    return this.findWaitGuiClass(child);
                }
            } else if (file.getName().toLowerCase().endsWith(".jar")) {
                Class<?> waitClass = null;
                try {
                    Attributes attr;
                    JarFile jar = new JarFile(file);
                    Enumeration<JarEntry> entries = jar.entries();
                    Manifest man = jar.getManifest();
                    if (man != null && "WaitGuiReady".equals((attr = man.getMainAttributes()).getValue("Ats-Type"))) {
                        while (entries.hasMoreElements()) {
                            String className;
                            Class<?> c;
                            String entryName = entries.nextElement().getName();
                            if (!entryName.endsWith(".class") || !(c = this.loadClass(className = entryName.replace('/', '.').substring(0, entryName.length() - 6))).isAnnotationPresent(WaitGuiReadyInfo.class) || !IWaitGuiReady.class.isAssignableFrom(c)) continue;
                            waitClass = c;
                        }
                    }
                    jar.close();
                }
                catch (IOException | ClassNotFoundException exception) {
                    // empty catch block
                }
                return waitClass;
            }
        }
        return null;
    }
}

