/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.desktop;

import com.ats.element.AtsBaseElement;
import com.ats.element.AtsElement;
import com.ats.element.FoundElement;
import com.ats.element.JsonUtils;
import com.ats.executor.TestBound;
import com.ats.executor.drivers.desktop.DesktopData;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.generator.variables.CalculatedProperty;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DesktopResponse {
    private List<AtsElement> elements;
    private List<DesktopWindow> windows;
    private List<DesktopData> attributes;
    private int errorCode = 0;
    private String errorMessage = null;
    private byte[] image;

    public DesktopResponse() {
    }

    public DesktopResponse(String error) {
        this.errorMessage = error;
        this.errorCode = -999;
    }

    public DesktopResponse(JsonNode node) {
        this.jsonDeserialize(node);
    }

    @JsonGetter(value="elements")
    public List<AtsElement> getElements() {
        return this.elements;
    }

    @JsonSetter(value="elements")
    public void setElements(List<AtsElement> elements) {
        this.elements = elements;
    }

    @JsonGetter(value="windows")
    public List<DesktopWindow> getWindows() {
        if (this.windows == null) {
            return Collections.emptyList();
        }
        return this.windows;
    }

    @JsonSetter(value="windows")
    public void setWindows(List<DesktopWindow> windows) {
        this.windows = windows;
    }

    @JsonGetter(value="attributes")
    public List<DesktopData> getAttributes() {
        return this.attributes;
    }

    @JsonSetter(value="attributes")
    public void setAttributes(List<DesktopData> data) {
        this.attributes = data;
    }

    @JsonGetter(value="errorCode")
    public int getErrorCode() {
        return this.errorCode;
    }

    @JsonSetter(value="errorCode")
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @JsonGetter(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonSetter(value="errorMessage")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @JsonGetter(value="image")
    public byte[] getImage() {
        return this.image;
    }

    @JsonSetter(value="image")
    public void setImage(byte[] image) {
        this.image = image;
    }

    public List<DesktopData> getData() {
        if (this.attributes == null || this.attributes.size() == 0) {
            return Collections.emptyList();
        }
        return this.attributes;
    }

    @Transient
    public List<FoundElement> getFoundElements(TestBound channelDimension) {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return this.elements.stream().map(e -> new FoundElement((AtsElement)e, channelDimension)).collect(Collectors.toCollection(ArrayList::new));
    }

    @Transient
    public DesktopWindow getWindow() {
        if (this.windows != null && this.windows.size() > 0) {
            return this.windows.get(0);
        }
        return null;
    }

    @Transient
    public FoundElement getParentsElement(TestBound dimension) {
        FoundElement current = null;
        if (this.elements != null) {
            for (AtsElement obj : this.elements) {
                FoundElement elem = new FoundElement(obj, dimension);
                elem.setParent(current);
                current = elem;
            }
        }
        return current;
    }

    @Transient
    public CalculatedProperty[] getElementAttributes() {
        if (this.attributes == null || this.attributes.size() == 0) {
            return new CalculatedProperty[0];
        }
        CalculatedProperty[] result = new CalculatedProperty[this.attributes.size()];
        int loop = 0;
        for (DesktopData data : this.attributes) {
            result[loop] = data.getCalculatedProperty();
            ++loop;
        }
        return result;
    }

    @Transient
    public List<FoundElement> getFoundElements(Predicate<AtsBaseElement> predicate, TestBound dimension) {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return this.elements.parallelStream().filter(predicate).map(e -> new FoundElement((AtsElement)e, dimension)).collect(Collectors.toCollection(ArrayList::new));
    }

    @Transient
    public String getFirstAttribute() {
        if (this.attributes != null && this.attributes.size() > 0) {
            return this.attributes.get(0).getValue();
        }
        return null;
    }

    public void jsonDeserialize(JsonNode node) {
        if (node != null) {
            if (node.get("error") != null && node.get("error").asInt() != 0) {
                this.setErrorCode(node.get("error").asInt());
                this.setErrorMessage(node.get("message").asText());
            } else if (node.get("errorCode") != null && node.get("errorCode").asInt() != 0) {
                this.setErrorCode(node.get("errorCode").asInt());
                this.setErrorMessage(node.get("errorMessage").asText());
            } else {
                this.elements = new ArrayList<AtsElement>();
                JsonNode jsonElements = node.get("elements");
                if (jsonElements != null) {
                    if (jsonElements.isArray()) {
                        for (Object jsonElement : jsonElements) {
                            AtsElement atsElement = new AtsElement((JsonNode)jsonElement);
                            this.elements.add(atsElement);
                        }
                    } else {
                        this.elements = null;
                    }
                } else {
                    this.elements = null;
                }
                this.windows = new ArrayList<DesktopWindow>();
                JsonNode jsonWindows = node.get("windows");
                if (jsonWindows != null) {
                    if (jsonWindows.isArray()) {
                        for (JsonNode jsonWindow : jsonWindows) {
                            DesktopWindow desktopWindow = new DesktopWindow(jsonWindow);
                            this.windows.add(desktopWindow);
                        }
                    } else {
                        this.windows = null;
                    }
                } else {
                    this.windows = null;
                }
                this.attributes = new ArrayList<DesktopData>();
                JsonNode jsonAttributes = node.get("attributes");
                if (jsonAttributes != null) {
                    if (jsonAttributes.isArray()) {
                        for (JsonNode jsonAttribute : jsonAttributes) {
                            DesktopData desktopData = new DesktopData(jsonAttribute);
                            this.attributes.add(desktopData);
                        }
                    } else {
                        this.attributes = null;
                    }
                } else {
                    this.attributes = null;
                }
                this.image = (byte[])(node.has("image") ? JsonUtils.getBase64Image(node, "image") : null);
            }
        }
    }
}

