/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.generator.variables.BaseValue;
import java.util.regex.Matcher;

public class BaseValueDefault
extends BaseValue {
    protected String defaultValue;

    public BaseValueDefault(Matcher m) {
        super(m);
        this.replace = m.group(0);
        String data = m.group(1);
        String dataDefault = "";
        if (m.groupCount() > 1) {
            dataDefault = m.group(2).trim();
        } else {
            String[] arrValue = data.split(",");
            if (arrValue.length > 1) {
                data = arrValue[0].trim();
                dataDefault = arrValue[1].trim();
            }
        }
        this.value = data;
        this.codeValue = data;
        this.defaultValue = dataDefault;
    }

    public BaseValueDefault(String value, String defaultValue) {
        super(value);
        this.defaultValue = defaultValue;
    }

    @Override
    public String getReplace() {
        return this.replace;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getNoComma() {
        return this.replace.replace(",", "\n");
    }

    @Override
    public String getCode() {
        StringBuilder codeBuilder = new StringBuilder("(");
        codeBuilder.append(this.codeValue);
        if (this.defaultValue.length() > 0) {
            codeBuilder.append(", \"");
            codeBuilder.append(this.defaultValue);
            codeBuilder.append("\"");
        }
        codeBuilder.append(")");
        return codeBuilder.toString();
    }

    @Override
    public String getHashValue() {
        StringBuilder sb = new StringBuilder("#@").append(this.getType()).append(this.value).append("~~").append(this.defaultValue).append("#");
        return sb.toString();
    }
}

