/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.script.Script;
import com.ats.script.actions.ActionReturnVariableArray;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Predicate;

public class ActionAI
extends ActionReturnVariableArray {
    public static final String SCRIPT_LABEL = "ai-request";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g);
    private CalculatedValue request;

    public ActionAI() {
    }

    public ActionAI(Script script, ExecuteOptions options, CalculatedValue request, ArrayList<Variable> returnValues) {
        super(script, options, returnValues);
        this.setRequest(request);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.request.getJavaCode()).append(")");
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.request.getKeywords());
        return keywords;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        ArrayList returnValue;
        super.execute(ts, testName, testLine, tryNum);
        String req = this.request.getCalculated();
        File f = this.getCurrentChannel().saveCurrentPage();
        if (f != null && (returnValue = new ArrayList()).size() > 0) {
            ArrayList<Variable> variableValues = new ArrayList<Variable>();
            for (String varName : returnValue) {
                variableValues.add(this.script.getVariable(varName.trim(), true));
            }
            this.setVariables(variableValues);
        }
        this.status.endAction();
        ts.getRecorder().updateScreen(this.status, req);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("request", this.request.getCalculated());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedValue getRequest() {
        return this.request;
    }

    public void setRequest(CalculatedValue value) {
        this.request = value;
    }
}

