/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.network.octoperf;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.Action;
import com.ats.script.actions.condition.ExecuteOptions;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.commons.text.StringEscapeUtils;

public class ActionOctoperfVirtualUser
extends Action {
    public static final String SCRIPT_LABEL = "octoperf-vu";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g);
    private CalculatedValue user;
    private CalculatedValue comment;
    private String tags;
    private boolean append = false;

    public ActionOctoperfVirtualUser() {
    }

    public ActionOctoperfVirtualUser(Script script, ExecuteOptions options, ArrayList<String> dataArray) {
        super(script);
        String usr = "vuser";
        String cmt = "";
        String tgs = "";
        if (dataArray.size() > 0) {
            usr = dataArray.remove(0).trim();
            if (dataArray.size() > 0) {
                cmt = dataArray.remove(0).trim();
            }
            if (dataArray.size() > 0) {
                tgs = dataArray.remove(0).trim();
            }
        }
        this.setAppend(options.hasAppend());
        this.setUser(new CalculatedValue(script, usr));
        this.setComment(new CalculatedValue(script, cmt));
        this.setTags(tgs);
    }

    public ActionOctoperfVirtualUser(Script script, boolean append, CalculatedValue user, CalculatedValue comment, String tags) {
        super(script);
        this.setAppend(append);
        this.setUser(user);
        this.setComment(comment);
        this.setTags(tags);
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append(this.append).append(", ").append(this.user.getJavaCode()).append(", ").append(this.comment.getJavaCode()).append(", \"").append(StringEscapeUtils.escapeJava((String)this.tags)).append("\")");
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        this.getCurrentChannel().sendToOctoperfServer(this);
        this.status.endDuration();
    }

    public CalculatedValue getUser() {
        return this.user;
    }

    public void setUser(CalculatedValue user) {
        this.user = user;
    }

    public CalculatedValue getComment() {
        return this.comment;
    }

    public void setComment(CalculatedValue comment) {
        this.comment = comment;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String value) {
        this.tags = value;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }
}

