/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

import com.ats.executor.ActionStatus;
import com.ats.generator.variables.parameter.ParameterDataFile;
import com.ats.recorder.VisualElement;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.module.ModuleDescriptor;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.MediaType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class Utils {
    public static final String EMPTY_SCREEN = "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";
    private static final String WHITE_PIXEL = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAACXBIWXMAAC4jAAAuIwF4pT92AAAAB3RJTUUH5wYKDCwDjkpXLgAAABl0RVh0Q29tbWVudABDcmVhdGVkIHdpdGggR0lNUFeBDhcAAAAMSURBVAjXY/j//z8ABf4C/tzMWecAAAAASUVORK5CYII=";
    private static final String VALID_JAVA_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_$";
    public static final MediaType JSON_MEDIA = MediaType.get((String)"application/json; charset=utf-8");
    public static final MediaType TEXT_MEDIA = MediaType.get((String)"text/plain");
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String[] DATES_PATTERN = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd 'at' HH:mm:ss"};
    private static final Pattern SYS_VERSION_PATTERN = Pattern.compile("<a href\\s?=\\s?\"([^\"]+\\.(zip|tgz))\">");

    public static Date parseDateFormat(String value) {
        if (value != null && !value.isBlank()) {
            try {
                return DateUtils.parseDate((String)value, (String[])DATES_PATTERN);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Calendar today = Calendar.getInstance();
        today.clear(10);
        today.clear(12);
        today.clear(13);
        return today.getTime();
    }

    public static String dateFormat(Date value) {
        return DateFormatUtils.format((Date)value, (String)DATE_FORMAT);
    }

    public static String unescapeAts(String data) {
        return data.replaceAll("&sp;", " ").replaceAll("&co;", ",").replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&eq;", "=").replaceAll("&rb;", "]").replaceAll("&lb;", "[");
    }

    public static String escapeHTML(String str) {
        return str.codePoints().mapToObj(c -> c > 127 || "\"'<>&".indexOf(c) != -1 ? "&#" + c + ";" : new String(Character.toChars(c))).collect(Collectors.joining());
    }

    public static String escapeJava(String value) {
        StringBuilder builder = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (c == '\'') {
                builder.append("\\'");
                continue;
            }
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                builder.append(String.format("\\u%04x", c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean isNumeric(String numString) {
        if (numString == null) {
            return false;
        }
        try {
            Double.parseDouble(numString);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int string2Int(String value) {
        return Utils.string2Int(value, 0);
    }

    public static int string2Int(String value, int defaultValue) {
        try {
            return Integer.parseInt(value.replaceAll("\\s", ""));
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long string2Long(String value) {
        try {
            return Long.parseLong(value.replaceAll("\\s", ""));
        }
        catch (NullPointerException | NumberFormatException e) {
            return 0L;
        }
    }

    public static boolean isNotEmpty(String value) {
        return value != null && !value.isBlank();
    }

    public static double string2Double(String value) {
        try {
            return Double.parseDouble(value.replaceAll("\\s", ""));
        }
        catch (NullPointerException | NumberFormatException e) {
            return 0.0;
        }
    }

    public static String truncateString(String value, int length) {
        if (value != null && value.length() > length) {
            value = value.substring(0, length);
        }
        return value;
    }

    public static JsonArray string2JsonArray(String value) {
        char[] letters = value.toCharArray();
        JsonArray array = new JsonArray();
        for (char ch : letters) {
            array.add((JsonElement)new JsonPrimitive((Number)ch));
        }
        return array;
    }

    public static String getShortUid() {
        char[] chars = "ABSDEFGHIJKLMNOPQRSTUVWXYZ1234567890".toCharArray();
        Random r = new Random(System.currentTimeMillis());
        char[] id = new char[8];
        for (int i = 0; i < 8; ++i) {
            id[i] = chars[r.nextInt(chars.length)];
        }
        return new String(id);
    }

    public static String checkJsonData(String jsonStr) {
        if (jsonStr != null && jsonStr.length() > 0 && (jsonStr.startsWith("{") && jsonStr.endsWith("}") || jsonStr.startsWith("[") && jsonStr.endsWith("]"))) {
            try {
                JsonParser.parseString((String)jsonStr);
                return jsonStr;
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isXmlLike(String inXMLStr) {
        boolean retBool = false;
        if ((inXMLStr = inXMLStr.trim()) != null && inXMLStr.length() > 0 && inXMLStr.startsWith("<") && inXMLStr.endsWith(">")) {
            String XML_PATTERN_STR = "<(\\S+?)(.*?)>(.*?)(</\\1>)?";
            Pattern pattern = Pattern.compile("<(\\S+?)(.*?)>(.*?)(</\\1>)?", 42);
            Matcher matcher = pattern.matcher(inXMLStr);
            retBool = matcher.matches();
        }
        return retBool;
    }

    public static String cleanHtmlCode(String value) {
        return value.replaceAll("\\r?\\n", "").replaceAll(" ?<!----> ?", "");
    }

    public static boolean containsIgnoreCase(String src, String what) {
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... css) {
        if (ArrayUtils.isEmpty((Object[])css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!Utils.isNotBlank(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !Utils.isBlank(cs);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = Utils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getImageData(boolean isError, String imgType, ArrayList<byte[]> images, VisualElement element, int ref) {
        if (images.size() > 0 && images.get(images.size() - 1) != null) {
            return Base64.getEncoder().encodeToString(images.get(images.size() - 1));
        }
        return EMPTY_SCREEN;
    }

    public static byte[] loadImage(URL url) {
        byte[] byArray;
        block9: {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            InputStream inputStream = url.openStream();
            try {
                int n = 0;
                byte[] buffer = new byte[1024];
                while (-1 != (n = inputStream.read(buffer))) {
                    output.write(buffer, 0, n);
                }
                byArray = output.toByteArray();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public static byte[] getWhitePixel() {
        return Base64.getDecoder().decode(WHITE_PIXEL);
    }

    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                ret = ret && Utils.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }

    public static void deleteRecursiveFiles(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        if (f.isDirectory()) {
            for (File f0 : f.listFiles()) {
                if (f0.isDirectory()) {
                    Utils.deleteRecursiveFiles(f0);
                    if (f0.listFiles().length != 0) continue;
                    f0.delete();
                    continue;
                }
                if (!f0.isFile()) continue;
                f0.delete();
            }
        }
    }

    public static void deleteRecursiveJavaFiles(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        if (f.isDirectory()) {
            for (File f0 : f.listFiles()) {
                if (f0.isDirectory()) {
                    Utils.deleteRecursiveJavaFiles(f0);
                    if (f0.listFiles().length != 0) continue;
                    f0.delete();
                    continue;
                }
                if (!f0.isFile() || !f0.getName().toLowerCase().endsWith(".java")) continue;
                f0.delete();
            }
        }
    }

    public static void copyFiles(String src, String dest, boolean overwrite) {
        try {
            Files.walk(Paths.get(src, new String[0]), new FileVisitOption[0]).forEach(a -> {
                String aPath = a.toString();
                Path b = Paths.get(dest, aPath.substring(src.length()));
                String fileName = a.getFileName().toString();
                try {
                    if (!aPath.equals(src) && (Files.isDirectory(a, new LinkOption[0]) || fileName.endsWith(".java") && fileName.substring(0, fileName.length() - 5).chars().allMatch(c -> VALID_JAVA_CHAR.indexOf(c) != -1))) {
                        CopyOption[] copyOptionArray;
                        if (overwrite) {
                            CopyOption[] copyOptionArray2 = new CopyOption[1];
                            copyOptionArray = copyOptionArray2;
                            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                        } else {
                            copyOptionArray = new CopyOption[]{};
                        }
                        Files.copy(a, b, copyOptionArray);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkUrl(ActionStatus status, String urlPath) {
        int responseCode;
        URL url = null;
        try {
            url = new URI(urlPath).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            status.setPassed(false);
            status.setCode(-10);
            status.setData(urlPath);
            return false;
        }
        try {
            if (urlPath.startsWith("https")) {
                HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                con.setRequestMethod("HEAD");
                responseCode = con.getResponseCode();
            } else {
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("HEAD");
                responseCode = con.getResponseCode();
            }
        }
        catch (IOException e) {
            status.setPassed(false);
            status.setCode(-12);
            status.setData(e.getMessage());
            return false;
        }
        if (responseCode == 200) {
            return true;
        }
        status.setPassed(false);
        status.setCode(-11);
        status.setData(urlPath);
        return false;
    }

    public static String removeExtension(String s) {
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = s.lastIndexOf(separator);
        String filename = lastSeparatorIndex == -1 ? s : s.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    public static String leftString(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String getCauseStackTraceString(Throwable e, String indent) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = e.getCause();
        if (cause != null) {
            sb.append(indent);
            sb.append("Java exception caused by -> ");
            sb.append(Utils.getCauseStackTraceString(cause, indent));
        } else {
            Throwable[] suppressedExceptions;
            sb.append(e.toString());
            sb.append("\n");
            StackTraceElement[] stack = e.getStackTrace();
            if (stack != null) {
                for (StackTraceElement stackTraceElement : stack) {
                    sb.append(indent);
                    sb.append("\tat ");
                    sb.append(stackTraceElement.toString());
                    sb.append("\n");
                }
            }
            if ((suppressedExceptions = e.getSuppressed()) != null) {
                for (Throwable throwable : suppressedExceptions) {
                    sb.append(indent);
                    sb.append("\tSuppressed: ");
                    sb.append(Utils.getCauseStackTraceString(throwable, indent + "\t"));
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(URI uri) {
        block26: {
            FileOutputStream fileOutputStream = null;
            AbstractInterruptibleChannel fileChannel = null;
            try {
                File file;
                block25: {
                    ReadableByteChannel readableByteChannel = Channels.newChannel(uri.toURL().openStream());
                    try {
                        File file2 = File.createTempFile("ats_chrome_plugin", ".crx");
                        file2.deleteOnExit();
                        fileOutputStream = new FileOutputStream(file2);
                        fileChannel = fileOutputStream.getChannel();
                        ((FileChannel)fileChannel).transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                        file = file2;
                        if (readableByteChannel == null) break block25;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (readableByteChannel != null) {
                                try {
                                    readableByteChannel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            break block26;
                        }
                    }
                    readableByteChannel.close();
                }
                return file;
            }
            finally {
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public static String cutBOM(String value) {
        byte[] bytes;
        if (value.length() > 1 && (bytes = value.substring(0, 1).getBytes()).length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return value.substring(1);
        }
        return value;
    }

    public static ParameterDataFile loadData(String url) throws MalformedURLException, URISyntaxException {
        return Utils.loadData(new ActionStatus(), new URI(url).toURL());
    }

    public static ParameterDataFile loadData(ActionStatus status, String url) throws MalformedURLException, URISyntaxException {
        return Utils.loadData(status, new URI(url).toURL());
    }

    public static ParameterDataFile loadData(ActionStatus status, URL url) {
        return new ParameterDataFile(status, url);
    }

    public static String getArtifactLastVersion(String folderUrl) {
        String version = null;
        try {
            HttpURLConnection con = (HttpURLConnection)new URI(folderUrl).toURL().openConnection();
            if (con.getResponseCode() == 200) {
                ModuleDescriptor.Version v;
                InputStream inputStream = con.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder builder = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                inputStream.close();
                ArrayList<String> versions = new ArrayList<String>();
                Matcher matcher = SYS_VERSION_PATTERN.matcher(builder.toString());
                int index = 0;
                while (matcher.find(index)) {
                    versions.add(matcher.group(1));
                    index = matcher.end();
                }
                if (versions.size() > 0 && (v = versions.stream().map(ModuleDescriptor.Version::parse).sorted(Collections.reverseOrder()).findFirst().get()) != null) {
                    version = v.toString().replace(".zip", "").replace(".tgz", "");
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return version;
    }

    public static String escapeMathSymbolsOnce(String data) {
        return data.replace("<", "").replace(">", "").replace("=", "").replace("~", "");
    }
}

