/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.generators;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.AtsReport;
import com.ats.tools.report.generators.AtsReportXmlGenerator;
import com.ats.tools.report.generators.ReportGenerator;
import com.ats.tools.report.models.ReportContextExecution;
import com.ats.tools.report.models.ReportSettings;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteInfo;
import com.ats.tools.report.models.TestSummary;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class XmlReportGenerator
implements ReportGenerator {
    private final ReportContextExecution contextExecution;
    private final AtsReportXmlGenerator atsReportXmlGenerator;

    public XmlReportGenerator(ReportContextExecution contextExecution) {
        this.contextExecution = contextExecution;
        ReportSettings reportSettings = contextExecution.reportSettings();
        this.atsReportXmlGenerator = new AtsReportXmlGenerator(contextExecution.project(), reportSettings.devReport(), reportSettings.outputFolder(), reportSettings.validReport(), contextExecution.reportFileNames().xmlReport());
    }

    @Override
    public void generateReport() throws Exception {
        try {
            this.atsReportXmlGenerator.writeProjectInfo();
            for (Suite suite : this.contextExecution.project().getSuites()) {
                this.writeSuiteData(suite);
            }
            AtsLogger.printLog("XML report generated", this.atsReportXmlGenerator.getFilePath().toString());
        }
        catch (Exception e) {
            AtsLogger.printLog("an error occurred during XML report generation");
            throw e;
        }
        finally {
            this.atsReportXmlGenerator.writeFileEnd();
        }
    }

    private void writeSuiteData(Suite suite) throws IOException {
        this.atsReportXmlGenerator.writeSuiteData(suite);
        for (TestSummary testSummary : suite.getSuiteInfo().getSummaries()) {
            this.writeTestCaseData(suite.getSuiteInfo(), testSummary);
        }
        this.atsReportXmlGenerator.writeSuiteEnd();
    }

    private void writeTestCaseData(SuiteInfo suite, TestSummary testSummary) throws IOException {
        ReportSettings reportSettings = this.contextExecution.reportSettings();
        String suiteName = suite.getName();
        String testName = testSummary.getTestName();
        Path targetPath = reportSettings.outputFolder().resolve(suiteName).resolve((String)AtsReport.ADD_XML_DIRECTORY_SUFFIX.apply(testName));
        if (!Files.exists(targetPath, new LinkOption[0])) {
            return;
        }
        this.atsReportXmlGenerator.writeScript(targetPath.resolve("actions.xml").toFile(), reportSettings.devReport());
    }
}

