/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.models;

import com.ats.tools.report.analytics.ActionTypesEnum;
import com.ats.tools.report.models.ActionData;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class PlaylistData {
    private String name;
    @JsonProperty(value="passed")
    private long _passed = 0L;
    @JsonProperty(value="failed")
    private long _failed = 0L;
    @JsonProperty(value="filtered")
    private long _filtered = 0L;
    private final List<ActionData> actionsData;

    public PlaylistData(String name) {
        this.name = name;
        this.actionsData = new ArrayList<ActionData>();
        this.actionsData.add(new ActionData("Navigation", 0));
        this.actionsData.add(new ActionData("Calls", 0));
        this.actionsData.add(new ActionData("UserAction", 0));
        this.actionsData.add(new ActionData("Assertion", 0));
        this.actionsData.add(new ActionData("Technical", 0));
        this.actionsData.add(new ActionData("Others", 0));
    }

    public void addAction(String actionType) {
        String actionName = "";
        switch (ActionTypesEnum.of(actionType)) {
            case NAVIGATION: {
                actionName = "Navigation";
                break;
            }
            case CALL_SCRIPT: {
                actionName = "Calls";
                break;
            }
            case USER_ACTION: {
                actionName = "UserAction";
                break;
            }
            case ASSERT: {
                actionName = "Assertion";
                break;
            }
            case TECHNICAL: {
                actionName = "Technical";
                break;
            }
            default: {
                actionName = "Others";
            }
        }
        for (ActionData action : this.actionsData) {
            if (!action.getName().equalsIgnoreCase(actionName)) continue;
            action.setValue(action.getValue() + 1);
            return;
        }
    }

    public void addTest(long passed, long failed, long filtered) {
        this._passed = passed;
        this._failed = failed;
        this._filtered = filtered;
    }

    public String getName() {
        return this.name;
    }

    public List<ActionData> getActions() {
        return this.actionsData;
    }
}

