/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.data.Dimension;
import com.ats.data.Point;
import com.ats.data.Rectangle;
import com.ats.driver.ApplicationProperties;
import com.ats.element.AtsBaseElement;
import com.ats.element.AtsSapElement;
import com.ats.element.FoundElement;
import com.ats.element.RemoteRootElement;
import com.ats.element.SapDialogBox;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.DriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.SystemDriverEngine;
import com.ats.generator.ATS;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.ActionApi;
import com.ats.tools.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class SapDriverEngine
extends DriverEngine
implements IDriverEngine {
    public static final String START_TIMEOUT_OPTION = "--start-timeout";
    private static final Pattern SAP_URL_PATTERN = Pattern.compile("(.*):(.*)@(.*)", 2);
    private final byte[] SAP_ICON;
    private static final String SESSION = "session";
    private static final String SHUTDOWN = "shutdown";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String SCROLL = "scroll";
    private static final String ELEMENTS = "elements";
    private static final String ELEMENT = "element";
    private static final String PRESS = "press";
    private static final String DBL_CLICK = "dbclick";
    private static final String DIALOG_BOX = "dialogBox";
    private static final String TEXT = "text";
    private static final String TREE = "tree";
    private static final String OPTIONS = "options";
    private static final String SELECT = "select";
    private static final String PARENTS = "parents";
    private static final String WINDOW = "window";
    private static final String SWITCH = "switch";
    private static final String CLOSE = "close";
    private static final String SCRIPT = "script";
    private static final String GOTO_URL = "gotoUrl";
    private static final String FOCUS = "focus";
    public static final String SAP_NETWORKOPTION = "NetworkOption";
    public static final String SAP_ENDPOINT = "Endpoint";
    public static final String SAP_MAJOR_VERSION = "MajorVersion";
    public static final String SAP_NETWORKOPTION_FAST = "fast";
    public static final String SAP_NETWORKOPTION_SLOW = "slow";
    public static final String SAP_CONNECTION_ID = "connectionId";
    private String sapUser;
    private String sapPassword;
    private String sapClient;
    private String sapLang;
    private String applicationName;
    private OkHttpClient httpClient;
    private String userAgent;
    private String sapDriverUrl;
    private String connectionId;
    private List<FoundElement> elementMapLocation;
    private FoundElement currentElement;
    private final ObjectMapper jsonMapper;
    private final RemoteRootElement root;
    private String networkOption;
    private static final int ACTION_WAIT = 150;

    /*
     * Enabled aggressive block sorting
     */
    public SapDriverEngine(Channel channel, ActionStatus status, String application, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, boolean enableLearning) {
        JsonNode window;
        JsonNode version;
        String channelName;
        block21: {
            block20: {
                super(channel, driverInfo, systemDriver, props, 150, 0, enableLearning);
                this.SAP_ICON = Base64.getDecoder().decode("iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAJ/3pUWHRSYXcgcHJvZmlsZSB0eXBlIGV4aWYAAHja7ZhZcis5DkX/uYpeAidwWA7HiN5BL78PmCl5eLLfUPXR0VGW7ZQoJgngghcXadZ//r3Nv/gJqRQTJZdUU7L8xBqrb7wp9vq5rs7G8//68PjOfRw3zy88Q4FruD6mdc9vjMvbDTne4/3juMnjXqfcC91fPBYMurPnzT2v3AsFf427+7Op930tvnPn/gv5LPGc/PlzzARjCoPBG7+CC5b/eqMP+udDO1f9n5nkQjrv7TXyOnbm+fZT8J7vPsXOtns8fAyFsemekD7F6B538jp2J0IfUHvb+cMX4u2073/exW7vWfZel3ctJiKVzO3Uw5XzjomdUIZzW+KV+RPe5/OqvAouDoI+QbPzGsZV54n2dtFN19x261yHG5gY/fKE23s/fDhjhfBXP4JCEPXlts+hhmlCAZ8BaoFh/7TFnX3r2W+QtNNOx0zvWMwdZD+9zKvBP3k9F9pbU9c5W56xwi6vCYgZipz+ZxaAuH3HVE58z8u8yxv7DtgAgnLCXHCw2X4t0cW95VY4OAfmiY3GXunu8rwXIETsLRjjAgjY5IK45Gz2PjtHHAv4NCz3IfoOAk7ET2c22ISQAKd43Zt7sjtzvfhrGGoBCOGgZKCpoQFWjEL+5FjIoSZBohGRJFmKVGkppJgkpZSTclTLIccsOeWcS665lVBikZJKLqXU0qqvAQqTmmo2tdRaW2PTxtKNuxszWuu+hx679NRzL732NkifEYeMNPIoo442/QyT4z/TzGaWWWdbbpFKKy5ZaeVVVl1tk2s77Lhlp5132XW3J2o3qh9Rc5+Q+x41d6OmiMUzL7+hxnDOjyWc0okoZiDmowPxrAiQ0F4xs8XF6BU5xcxWz6EQD2pOFJzpFDEQjMt52e6J3Rty3+JmJP4Wbv4r5IxC93cgZxS6G7kfcXuB2mynooQDkJ5CjakNG2JjwirNl6Y16Y+v5q8u8M9C/zMLrdaHErR3s1IJ+6wcWqjTS9sxtR0qn/IehZzfZFdK2+xpa+qUsj5l+LztIA1d1rOui/re4krXW2rs11fzswm/dA0jmCupt407x4dHmvvqEz5eXn3hEwupV1wnQuvv8Kuoa3/mD4SEcAuSZ/JzR+kmRuhBCWW6OmKy/LpQqUxrxdzgPDgWW5tg5+5z5T23PRgO6lkuu++lrGz4Io924lH8lJVFRihlRJgyLCl19uhL9Nn2ji19zryXi32XHDbLMn+zWDfEdmvNj+zoK2FauvUi7vvENYWzifd9YVRnQp5zz5F73wAiZYeoE80rBG4A4o5tl6S8XXKOMwdIUCiTvXtXRqmJIkAZKWFWXCMOWmt8gLn3DlNX7atAiZLbLGFs9NqqaWEmHwYcCl1XiUDaFwkhim4zakMhRQZBy20cRxEUXBoxcBhGuOvqeAg6gR07XneqVz0uJoeHoVSzxrtl9/6wJjR8rWnfr2rttS5BuFYue81pwDYTew1rRDAys48lqTQN90uLysvtzGO/N2NvWz+Z+rMAmB/3w85fMvOji+ay9Zv9fmbqfaP5/bC+Ntf8flhfR9X8flhfR9V8FdbJbUMTvLNY1TC2xlTbhuMMRx+L73Wds5RLbdmIl9FdKKtxqNA5eghLuarAHONDXai0GfRNuc6bPkK3yh5qpFH6iPOc/TzVM2WdegWY34t3kkeaQKMjdcRSzdrZOFrMZsvgV9W7sXQ2AzqAj5FpiCd4SE3k3IqtihCqa7ooTsk4uy3z+rSRxVtSkBnpe6xpKdc0FyrrBNvX5dPx0I9Yso1zzuruKQzOPpF8PUpiFTzwO2WahO3N+cYt6UelEeWwepcIxbBQHz1tgfTe9iq7LRrrx/3P281fvP95u/n1+3scQ8X1mKPQ34ABuYGW3ErjwxSlunPaoOGTjn2FjS4elITULXSPSl+ZqoKGTmkF3+FXWFSahTRj3ZVPzqBd0b8WSH3JUR9cuLJSKzNWMn9uEN8xknS5SGBWjLvMViHbGRURxjE9OoP6nRYZjkuofTKvYUzqLu3mJ60WjqCZR5n+yhl6BLoBUqZQGkbU07g7RcKgaXMfl0vuVJPSWhiZXKS9LhyUU4dU1Dgt/o0GiEJKF2irpsiazUX6DWI0jzVONA7FnveU48+Jd4ZFH7C8vpovJwgdAwUThX+YqWMc7UFQPxJBBi2CuImDVjCpphdEzelL/QB3i0O74S5nKw44gzggFFwqnZMSd+gul97EQgWJruicxrJdPOTfVjmIQ0Bt02c0+uGtcagiGqdOmACE80x+dbbrcAVguqFlGSIJA2KbY9c4aInKFITWdLPkCWnQYutJH1d08Aoqgav6weFIsYPExH2EWDKH9wLpi8jIcx38FhX/kg4NT9BAQrVml35JoFId2X5JoOKKjSqBzG4z1310DIgeHbNVx7B67yFcylA/lM/Slzs3bArfCmEx6I3mR48aQe3K9K6KuqBThDErqoP9T/YRi2X7OLYinBs0vI5cOsLZkGRjBpsjrSbvWTOFVdE0kJq2jwQoF4yclXYRws7qTl3yTN6qJcgvMy8hxeShdcGrxBGlZX1oxbE9VQTpB4OjoDjtvSOWrGC6G/D72pnjPLZJ+uBocM5AjBPW5noILw7yqqcchUFTuRc5fkNw12YyYF9lNGSDQbeG3GQlxjjOxiZdkF0UAdQniZ3Qrh2S6WUdCem3OnK7oWXCd3PXCfcTGzrR0MorQu0hSdaGjGYbkrPs7Oal2AaNfjvujO16VemnB15p4Ln9izg6Wn33MN6o9TBYF3CHMVboohxz3NfGGffPMsd/1b9yauC1872vUpCRB4waQyyYAjCb0t4HfzAcIcuo4dS/d968QuBHALCiNT1WAArrvoj+F3mksb82Z7H3m7+LOyrgXeTN+9A7BXqi7jMxGCq1Z5LVQmiy0FccluLhVQtrQiSEKqnsmHyduwkx2BBTgUwWkcOa7iqHRVlOukUMSFwoHg52s+JnTm6UwywlFQ4wUcQSgg3zlUteaL1C9QTLL/Khai/ow/QoiotpfD9Mg9qAZy434catfaBtxuqJUu+nVV4jK0pWVaJC5KiShCpRVsk3/1MicvuR4s2nAbqmpY+Pq12X7JM1DiM2h1swRK5j08QelaXyL/cAECWaLguOXcpd8GKuUDs2X1VJps/hUaB+cjUfB3xK2mtSB2/noZ+7BZO7BWvlqq7a8GlxDXdmu35n9pApGxyBHAXiV1pUqJglEjF+vT7LR61W9A+1dHl9AFVHqAkdB1UZdGik3I19tdX64Ze7fYrXs3k3L3vHAed990hD5cseIYw+cNA9no2sGmr53ecqFEuEaO4I1TSVszUUkmOq9lWvfqvmz726duq7nPQ4vTrj5hzzu1MP33bqGkLofr6OmfkbHrH8s9D/5UJKN9X8FyWro0PH75RDAAAABmJLR0QAuwCzAKH4nVFNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5gIHDwAJmV7GfwAAARZJREFUSMftlLFKA0EQhr87NqchljaCpeQBUil2eYOEW0FBfA7BxsA2PoQ2FhGTQoRAUNzGwsonyIGFYGmhJHqJGQsTWYKYXEys7q92luHbYf6ZhVSp/ipveCge1ApuPCN9KCe4AzIzhPeAPTWnzvREZNcaXVVzgu9Yo88BlDSXbwEeX88UkozUeChQfV7D876t6w7gteGFAjYBVpdsIvhNVOL0aYXMIi582xpdd/OmatF1q8xhtEGQzcFX9V0R0dboi9HcxA9ctUIq0boLj0XY+gkOoDrtF3//OPbv8ycd6ffHjqmvAoLsggOX0Bp9OcmixQn34F1Eytboxq8FTTmKbyKUxsFHPbCTeiJwZE3YTH/aVP+jT9QPZXeteJAIAAAAAElFTkSuQmCC");
                this.sapClient = "001";
                this.sapLang = "EN";
                this.jsonMapper = new ObjectMapper();
                this.root = new RemoteRootElement();
                this.networkOption = "";
                channelName = channel.getName();
                application = props.getUri() != null ? props.getUri() : application.replaceFirst("^sap:\\/\\/", "");
                if (channelName.isBlank()) {
                    status.setError(-19, "channel name cannot be empty");
                    return;
                }
                this.sapDriverUrl = this.getDriverInfo().getDriverServerUri().resolve("/").toString();
                String auth = channel.getAuthenticationValue();
                if (props.getAuthentication() != null) {
                    auth = props.getAuthentication();
                }
                if (auth == null || auth.isBlank()) break block20;
                String authenticationDecoded = new String(Base64.getDecoder().decode(auth), StandardCharsets.UTF_8);
                String[] authenticationData = authenticationDecoded.split(":");
                if (authenticationData.length <= 1) {
                    status.setError(-19, "no user and password defined");
                    return;
                }
                this.sapUser = authenticationData[0];
                CalculatedValue passValue = new CalculatedValue((Script)channel.getTestScript(), authenticationData[1]);
                passValue.uncrypt(channel.getTestScript());
                this.sapPassword = passValue.getCalculated();
                String[] appUrl = application.split(":");
                if (appUrl.length > 1) {
                    application = appUrl[0];
                    this.sapClient = appUrl[1];
                    if (appUrl.length > 2) {
                        this.sapLang = appUrl[2];
                    }
                    break block21;
                } else {
                    appUrl = application.split("/");
                    if (appUrl.length <= 1) {
                        status.setError(-19, "missing client ID");
                        return;
                    }
                    application = appUrl[0];
                    this.sapClient = appUrl[1];
                    if (appUrl.length > 2) {
                        this.sapLang = appUrl[2];
                    }
                }
                break block21;
            }
            Matcher mv = SAP_URL_PATTERN.matcher(application);
            if (mv.find()) {
                this.sapUser = mv.group(1);
                this.checkPassword(new CalculatedValue((Script)channel.getTestScript(), mv.group(2)), 0);
                application = mv.group(3);
            } else {
                channel.getArguments().forEach(c -> this.checkArgs((CalculatedValue)c));
            }
        }
        this.applicationPath = this.applicationName = application;
        this.httpClient = new OkHttpClient.Builder().cache(null).connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(80L, TimeUnit.SECONDS).build();
        this.userAgent = "AtsSapDriver/" + ATS.getAtsVersion() + "," + System.getProperty("user.name") + ",";
        ImmutableMap connexionMap = this.sapUser != null && this.sapPassword != null ? ImmutableMap.of((Object)"connection", (Object)this.applicationName, (Object)"user", (Object)this.sapUser, (Object)"password", (Object)this.sapPassword, (Object)"client", (Object)this.sapClient, (Object)"lang", (Object)this.sapLang, (Object)"channel", (Object)channelName) : ImmutableMap.of((Object)"connection", (Object)this.applicationName, (Object)"channel", (Object)channelName);
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)connexionMap, SESSION, START);
        for (int maxTry = 0; response == null && maxTry < 30; ++maxTry) {
            channel.sleepMiddle();
            response = this.executeRequest((ImmutableMap<String, Object>)connexionMap, SESSION, START);
        }
        String sapGuiVersion = "";
        String warning = "";
        if (response == null) {
            status.setError(-19, "unable to connect to sap driver");
            return;
        }
        JsonNode error = response.findValue("error");
        if (error != null) {
            status.setError(-19, error.findValue("Message").asText());
            return;
        }
        JsonNode network = response.findValue(SAP_NETWORKOPTION);
        if (network != null) {
            this.setNetworkOption(network.asText().toLowerCase());
            if (SAP_NETWORKOPTION_SLOW.equals(this.getNetworkOption())) {
                warning = "Slow network connection detected !";
            }
        }
        if ((version = response.findValue(SAP_MAJOR_VERSION)) != null) {
            sapGuiVersion = version.asText();
        }
        if ((window = response.findValue(WINDOW)) != null) {
            this.connectionId = response.findValue("ConnexionId").asText();
            this.getSystemDriver().setEngine(new SystemDriverEngine(channel, enableLearning));
            int pId = window.get("ProcessId").asInt(0);
            channel.setApplicationData("sap", this.getSystemDriver().getOsName() + " (" + this.getSystemDriver().getOsVersion() + ")", "SAP Gui", sapGuiVersion, this.getSystemDriver().getDriverVersion(), pId, window.get("Handle").asInt(0), this.SAP_ICON, warning, this.sapDriverUrl);
            channel.getDimension().update(window.get("ScreenX").asDouble(0.0), window.get("ScreenY").asDouble(0.0), window.get("Width").asDouble(0.0), window.get("Height").asDouble(0.0));
            List<DesktopWindow> windows = this.getSystemDriver().getWindowsByPid(pId);
            for (DesktopWindow win : windows) {
                String s = win.getAttribute("Title");
                if (s != null && s.toLowerCase().contains("sap logon")) {
                    this.getSystemDriver().ostracon(status, win.getHandle());
                }
                if (s == null || !s.toLowerCase().contains("sap easy access")) continue;
                this.getSystemDriver().getEngine().window = win;
            }
            return;
        } else {
            status.setError(-19, "unable to find main SAP window");
        }
    }

    private void checkArgs(CalculatedValue cv) {
        String v = cv.getCalculated();
        if (v.startsWith("user=")) {
            this.sapUser = v.substring(5);
        } else if (v.startsWith("pass=")) {
            this.checkPassword(cv, 5);
        } else if (v.startsWith("password=")) {
            this.checkPassword(cv, 9);
        } else if (v.startsWith("client=")) {
            this.sapClient = v.substring(7);
        }
    }

    private void checkPassword(CalculatedValue cv, int start) {
        cv.setCalculated(cv.getCalculated().substring(start));
        cv.uncrypt(this.channel.getTestScript());
        this.sapPassword = cv.getCalculated();
    }

    private JsonNode executeRequest(ImmutableMap<String, Object> map, String ... reqUrl) {
        String url = this.sapDriverUrl + Stream.of(reqUrl).map(Object::toString).collect(Collectors.joining("/"));
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        Request request = requestBuilder.addHeader("User-Agent", this.userAgent).addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF8").post(RequestBody.Companion.create(this.jsonMapper.valueToTree(map).toString(), Utils.JSON_MEDIA)).build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            String responseData = CharStreams.toString((Readable)new InputStreamReader(response.body().byteStream(), StandardCharsets.UTF_8));
            response.close();
            return this.jsonMapper.readTree(responseData);
        }
        catch (JsonSyntaxException | IOException e) {
            return null;
        }
    }

    private void loadElementsByTag(String parentId, String tagName, List<AtsSapElement> list, int line, String controlType) {
        JsonNode elements;
        JsonNode response;
        HashMap<String, String> m = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"tag", (Object)tagName, (Object)"line", (Object)String.valueOf(line), (Object)"controlType", (Object)controlType));
        if (parentId != null) {
            m.put("parent", parentId);
        }
        if ((response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.copyOf(m), ELEMENTS)) != null && (elements = response.findValue(ELEMENTS)) != null) {
            for (JsonNode element : elements) {
                list.add(new AtsSapElement(this.jsonMapper, element));
            }
        }
    }

    @Override
    public WebElement getRootElement(Channel cnl) {
        return this.root;
    }

    @Override
    public void close() {
        if (this.connectionId != null) {
            this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId), SESSION, STOP);
        }
    }

    @Override
    public void quit() {
        this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of(), SHUTDOWN);
    }

    @Override
    public boolean switchWindow(ActionStatus status, String type, String data, boolean regexp, boolean refresh) {
        int index = Utils.string2Int(data);
        JsonNode resp = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"index", (Object)index), WINDOW, SWITCH);
        if (resp != null) {
            JsonNode window = resp.findValue(WINDOW);
            if (window != null) {
                this.channel.getDimension().update(window.get("ScreenX").asDouble(0.0), window.get("ScreenY").asDouble(0.0), window.get("Width").asDouble(0.0), window.get("Height").asDouble(0.0));
                this.channel.setWinHandle(window.get("Handle").asInt());
                this.channel.toFront();
                status.setNoError();
            } else {
                JsonNode error = resp.findValue("error");
                if (error != null) {
                    status.setError(-14, error.get("Message").asText());
                }
            }
        }
        return false;
    }

    @Override
    public void closeWindow(ActionStatus status) {
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId), WINDOW, CLOSE);
        if (response != null) {
            JsonNode window = response.findValue(WINDOW);
            if (window != null) {
                this.channel.getDimension().update(window.get("ScreenX").asDouble(0.0), window.get("ScreenY").asDouble(0.0), window.get("Width").asDouble(0.0), window.get("Height").asDouble(0.0));
                this.channel.setWinHandle(window.get("Handle").asInt());
                this.channel.toFront();
            } else {
                JsonNode error = response.findValue("error");
                if (error != null) {
                    status.setError(-14, error.get("Message").asText());
                }
            }
        }
    }

    @Override
    public Object executeScript(ActionStatus status, String script, Object ... params) {
        return null;
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, TestElement element) {
        return this.executeScript(status, element.getWebElementId(), script);
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, boolean returnValue) {
        try {
            if (returnValue) {
                String result = this.executeScript(status, "", script);
                status.setMessage(result.toString());
                return result;
            }
            this.executeScript(status, "", script);
            status.setPassed(true);
        }
        catch (StaleElementReferenceException e0) {
            throw e0;
        }
        catch (Exception e1) {
            status.setException(-13, e1);
        }
        return null;
    }

    private String executeScript(ActionStatus status, String elementId, String script) {
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)elementId, (Object)SCRIPT, (Object)script), ELEMENT, SCRIPT);
        if (response != null) {
            JsonNode jsonError = response.findValue("error");
            if (jsonError != null) {
                status.setError(jsonError.get("Code").asInt(0), jsonError.get("Message").asText());
                return "";
            }
            JsonNode result = response.findValue("result");
            if (result != null && !result.isNull()) {
                return result.asText();
            }
        }
        return "";
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
        JsonNode jsonError;
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"url", (Object)url), GOTO_URL);
        if (response != null && (jsonError = response.findValue("error")) != null) {
            status.setError(jsonError.get("Code").asInt(0), jsonError.get("Message").asText());
        }
    }

    @Override
    public List<FoundElement> findElements(boolean sysComp, TestElement testObject, String tagName, String[] attributes, String[] attributesValues, Predicate<AtsBaseElement> searchPredicate, WebElement startElement) {
        ArrayList<AtsSapElement> list = new ArrayList<AtsSapElement>();
        TestElement parent = testObject.getParent();
        int line = 0;
        String parentId = null;
        if (parent != null) {
            parentId = parent.getWebElementId();
        }
        if (attributes.length == 0 && testObject.getIndex() != 0) {
            line = testObject.getIndex();
        }
        String controlType = sysComp ? "WIN" : "SAP";
        this.loadElementsByTag(parentId, tagName, list, line, controlType);
        return list.parallelStream().filter(searchPredicate).map(FoundElement::new).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public Rectangle getBoundRect(TestElement testElement) {
        return null;
    }

    @Override
    public void waitAfterAction(ActionStatus status) {
        this.actionWait();
    }

    @Override
    public void updateDimensions() {
        JsonNode window;
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId), WINDOW);
        if (response != null && (window = response.findValue(WINDOW)) != null && !window.isNull()) {
            this.channel.getDimension().update(window.get("ScreenX").asDouble(0.0), window.get("ScreenY").asDouble(0.0), window.get("Width").asDouble(0.0), window.get("Height").asDouble(0.0));
        }
    }

    @Override
    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        Optional<FoundElement> fe;
        double xPos = x;
        double yPos = y;
        if (this.elementMapLocation != null && this.elementMapLocation.size() > 0 && (fe = this.elementMapLocation.stream().filter(e -> e.isActive() && e.getRectangle().contains(xPos, yPos)).findFirst()).isPresent()) {
            return fe.get();
        }
        return null;
    }

    @Override
    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        return null;
    }

    @Override
    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        CalculatedProperty[] properties;
        for (CalculatedProperty prop : properties = this.getAttributes(element, true)) {
            if (!prop.getName().equals(attributeName)) continue;
            return prop.getValue().getCalculated();
        }
        return null;
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        JsonNode jsonElement;
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)element.getId()), ELEMENT);
        if (response != null && (jsonElement = response.findValue(ELEMENT)) != null) {
            AtsSapElement elem = new AtsSapElement(this.jsonMapper, jsonElement);
            return elem.getAttributes();
        }
        return new CalculatedProperty[0];
    }

    @Override
    public CalculatedProperty[] getHtmlAttributes(FoundElement element) {
        return this.getAttributes(element, true);
    }

    @Override
    public List<String[]> loadSelectOptions(TestElement element) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)element.getWebElementId()), ELEMENT, OPTIONS);
        if (response != null) {
            JsonNode jsonOptions = response.findValue(OPTIONS);
            jsonOptions.fields().forEachRemaining(f -> result.add(new String[]{(String)f.getKey(), ((JsonNode)f.getValue()).asText()}));
        }
        return result;
    }

    @Override
    public List<FoundElement> findSelectOptions(TestBound dimension, TestElement element) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void selectOptionsItem(ActionStatus status, TestElement testElement, CalculatedProperty selectProperty, boolean keepSelect) {
        String key;
        String searchedValue = selectProperty.getValue().getCalculated();
        List<String[]> items = this.loadSelectOptions(testElement);
        if ("index".equals(selectProperty.getName())) {
            int index = Utils.string2Int(searchedValue);
            if (items.size() <= index) {
                status.setError(-3, "index not found, max length options : " + items.size());
                return;
            }
            key = items.get(index)[0];
        } else {
            int idx = 1;
            if ("value".equals(selectProperty.getName())) {
                idx = 0;
            }
            int dataIndex = idx;
            Optional<String[]> foundOption = selectProperty.isRegexp() ? items.stream().filter(e -> e[dataIndex].matches(searchedValue)).findFirst() : items.stream().filter(e -> e[dataIndex].equals(searchedValue)).findFirst();
            if (!foundOption.isPresent()) {
                status.setError(-3, "option not found : " + searchedValue);
                return;
            }
            key = foundOption.get()[0];
        }
        this.checkResultError(this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)testElement.getWebElementId(), (Object)"key", (Object)key), ELEMENT, SELECT), status);
    }

    @Override
    public void loadParents(FoundElement hoverElement) {
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)hoverElement.getId()), ELEMENT, PARENTS);
        if (response != null) {
            double channelX = this.channel.getDimension().getX();
            double channelY = this.channel.getDimension().getY();
            JsonNode jsonParent = response.findValue("parent");
            if (jsonParent != null && !jsonParent.isNull()) {
                hoverElement.setParent(new FoundElement(channelX, channelY, jsonParent, jsonParent.get("Parent")));
            }
        }
    }

    private void checkResultError(JsonNode node, ActionStatus status) {
        JsonNode jsonError;
        if (node != null && (jsonError = node.findValue("error")) != null) {
            status.setError(jsonError.get("Code").asInt(0), jsonError.get("Message").asText());
        }
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList, int waitChar, ActionTestScript topScript) {
        boolean precIsSpecialKey = false;
        for (SendKeyData kd : textActionList) {
            String elementStr;
            if (kd.getData().length() <= 0 && kd.getSpecialKey() == null) continue;
            Object keySequence = kd.getSequenceMobile();
            String string = elementStr = precIsSpecialKey ? "root" : element.getWebElementId();
            if (kd.getData() != null && kd.getData() != "" && kd.getDownKey() != null) {
                keySequence = "$KEY-" + kd.getDownKey().name() + "-" + kd.getData();
            }
            if (kd.getSpecialKeyString() == null || !((String)keySequence).startsWith("$KEY-")) {
                this.checkResultError(this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)ELEMENT, (Object)elementStr, (Object)TEXT, (Object)keySequence), TEXT), status);
                if (status.getCode() == -3) {
                    throw new ElementNotInteractableException(status.getMessage());
                }
            } else if (elementStr != "root") {
                this.checkResultError(this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)ELEMENT, (Object)elementStr, (Object)TEXT, (Object)keySequence), FOCUS), status);
            }
            if (kd.getSpecialKey() != null && kd.getDownKey() == null && this.getSystemDriver() != null && this.getSystemDriver().getEngine() != null) {
                ArrayList<SendKeyData> specialKeyArray = new ArrayList<SendKeyData>();
                specialKeyArray.add(kd);
                this.getSystemDriver().getEngine().sendTextData(status, element, specialKeyArray, waitChar, topScript);
                precIsSpecialKey = true;
                this.waitAfterAction(status);
                continue;
            }
            precIsSpecialKey = false;
        }
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        String tag = element.getTag();
        if (tag.equalsIgnoreCase("toolbarmenu") || tag.equalsIgnoreCase("menu")) {
            int x = (int)Math.round(element.getScreenX() + element.getWidth() / 2.0);
            int y = (int)Math.round(element.getScreenY() + element.getHeight() / 2.0);
            this.getSystemDriver().mouseMove(x, y);
            this.getSystemDriver().mouseClick();
        } else {
            this.checkResultError(this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)element.getId()), ELEMENT, PRESS), status);
            if (status.getCode() == -3) {
                throw new ElementNotInteractableException(status.getMessage());
            }
        }
    }

    @Override
    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
        this.currentElement = foundElement;
    }

    @Override
    public void mouseMoveToElement(FoundElement foundElement) {
        this.currentElement = foundElement;
        ActionStatus status = new ActionStatus(this.channel, "", 0);
        this.checkResultError(this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)foundElement.getId()), ELEMENT, FOCUS), status);
        if (status.getCode() == -3) {
            throw new ElementNotInteractableException(status.getMessage());
        }
    }

    @Override
    public void doubleClick() {
        if (this.currentElement != null) {
            ActionStatus status = new ActionStatus(this.channel, "", 0);
            this.checkResultError(this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)this.currentElement.getId()), ELEMENT, DBL_CLICK), status);
            if (status.getCode() == -3) {
                throw new ElementNotInteractableException(status.getMessage());
            }
        }
    }

    @Override
    public void setWindowToFront() {
        this.channel.toFront();
    }

    @Override
    public void refreshElementMapLocation() {
        new Thread(new LoadMapElement(this.channel, this.connectionId, this)).start();
    }

    public void setElementMapLocation(ArrayList<FoundElement> value) {
        this.elementMapLocation = value;
    }

    @Override
    public String getTextData(FoundElement e) {
        return this.getAttribute(null, e, "Text", 5);
    }

    @Override
    public String getSelectedText(TestElement e) {
        return "";
    }

    @Override
    public void setSysProperty(String propertyName, String propertyValue) {
    }

    @Override
    public void scroll(int delta) {
    }

    @Override
    public void scroll(FoundElement element) {
    }

    @Override
    public void scroll(FoundElement element, int delta) {
        if (this.currentElement != null) {
            ActionStatus status = new ActionStatus(this.channel, "", 0);
            this.checkResultError(this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)this.currentElement.getId(), (Object)"value", (Object)delta), SCROLL), status);
        }
    }

    @Override
    public void clearText(ActionStatus status, TestElement testElement, MouseDirection md) {
    }

    @Override
    public void rightClick() {
        int x = (int)(this.currentElement.getScreenX() + (double)(Math.round(this.currentElement.getWidth()) / 2L));
        int y = (int)(this.currentElement.getScreenY() + (double)(Math.round(this.currentElement.getHeight()) / 2L));
        this.getSystemDriver().mouseMove(x, y);
        this.getSystemDriver().mouseRightClick();
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
    }

    @Override
    public void buttonClick(ActionStatus status, String id) {
    }

    @Override
    public void tap(int count, FoundElement element) {
    }

    @Override
    public void press(int duration, ArrayList<String> paths, FoundElement element) {
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY, boolean offset) {
    }

    @Override
    public void drop(FoundElement element, MouseDirection md, boolean desktopDragDrop) {
    }

    @Override
    public void swipe(ActionStatus status, FoundElement element, MouseDirection position, MouseDirection direction) {
    }

    @Override
    public void keyDown(Keys key) {
    }

    @Override
    public void keyUp(Keys key) {
    }

    @Override
    public void moveByOffset(int hDirection, int vDirection) {
    }

    @Override
    public SapDialogBox switchToAlert() {
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId), ELEMENT, DIALOG_BOX);
        try {
            String id = response.findValue("Id").asText();
            String title = "";
            String text = response.findValue("Text").asText();
            String type = response.findValue("Tag").asText();
            return new SapDialogBox(this, id, "", text, type);
        }
        catch (Exception e) {
            throw new NoAlertPresentException();
        }
    }

    public void dialogBoxExecute(ActionStatus status, String id, String action) {
        JsonNode result = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SAP_CONNECTION_ID, (Object)this.connectionId, (Object)"id", (Object)id, (Object)"execute", (Object)action), ELEMENT, DIALOG_BOX);
        String response = result.findValue("result").asText();
        if ("ko".equalsIgnoreCase(response)) {
            status.setMessage("Error:  " + result.findValue("error").asText());
            status.setPassed(false);
        }
    }

    @Override
    public boolean switchToDefaultContent(boolean dialog) {
        return false;
    }

    @Override
    public void switchToFrameId(String id) {
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public void api(ActionStatus status, ActionApi api) {
    }

    @Override
    public void windowState(ActionStatus status, Channel channel, String state) {
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public int getNumWindows() {
        return 0;
    }

    @Override
    public String getUrl() {
        return null;
    }

    @Override
    protected void setPosition(Point pt) {
    }

    @Override
    protected void setSize(Dimension dim) {
    }

    @Override
    public String getCookies() {
        return "";
    }

    @Override
    public String getHeaders(ActionStatus status) {
        return "";
    }

    public String getNetworkOption() {
        return this.networkOption;
    }

    public void setNetworkOption(String value) {
        this.networkOption = value;
    }

    @Override
    public void resetToDefaultWindow() {
    }

    private static class LoadMapElement
    implements Runnable {
        final TestBound channelDimension;
        final String connectionId;
        final SapDriverEngine driver;

        public LoadMapElement(Channel channel, String connectionId, SapDriverEngine driver) {
            this.channelDimension = channel.getDimension();
            this.connectionId = connectionId;
            this.driver = driver;
        }

        @Override
        public void run() {
            JsonNode elements;
            JsonNode response = this.driver.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)SapDriverEngine.SAP_CONNECTION_ID, (Object)this.connectionId), SapDriverEngine.ELEMENTS, SapDriverEngine.TREE);
            if (response != null && (elements = response.findValue(SapDriverEngine.ELEMENTS)) != null) {
                ArrayList<FoundElement> list = new ArrayList<FoundElement>();
                double channelX = this.channelDimension.getX();
                double channelY = this.channelDimension.getY();
                elements.elements().forEachRemaining(node -> list.add(new FoundElement(channelX, channelY, (JsonNode)node)));
                this.driver.setElementMapLocation(list);
            }
        }
    }
}

