/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers.capabilities;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.ats.tools.performance.proxy.IAtsProxy;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openqa.selenium.firefox.FirefoxProfile;

public class FirefoxOptions
extends org.openqa.selenium.firefox.FirefoxOptions {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> options = new HashMap<String, Object>();
    private Map<String, Object> plugins;

    public FirefoxOptions(BrowserArgumentsParser browserArguments, ApplicationProperties props, SystemDriver systemDriver, IAtsProxy proxy) {
        String X11_ENABLED;
        if (proxy.isEnabled()) {
            this.setProxy(proxy.getValue());
            if (proxy.isAutoDetect()) {
                this.addArguments(new String[]{"--proxy-auto-detect"});
            }
        }
        if (browserArguments.getBinaryPath() != null) {
            this.setBinary(browserArguments.getBinaryPath());
        }
        if ("true".equalsIgnoreCase(X11_ENABLED = System.getenv("X11_ENABLED"))) {
            this.addArguments(new String[]{"--user-agent=Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.3282.119 Safari/537.36"});
            this.plugins = browserArguments.getPlugins(true);
        } else if (browserArguments.isHeadless() || !systemDriver.isInteractive()) {
            this.addArguments(new String[]{"-headless"});
            this.plugins = browserArguments.getPlugins(true);
        } else {
            this.plugins = browserArguments.getPlugins(false);
        }
        if (browserArguments.isIncognito()) {
            this.addArguments(new String[]{"-private"});
        }
        if (browserArguments.getUserDataPath() != null) {
            File dir = new File(browserArguments.getUserDataPath());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.addArguments(new String[]{"-profile", browserArguments.getUserDataPath()});
        }
        for (String opt : browserArguments.getMoreOptions()) {
            this.addArguments(new String[]{opt});
        }
        if (browserArguments.getLang() != null) {
            this.addPreference("intl.locale.requested", browserArguments.getLang());
        }
        if (this.plugins.size() > 0) {
            FirefoxProfile ffProfile = new FirefoxProfile();
            for (Map.Entry<String, Object> entry : this.plugins.entrySet()) {
                ffProfile.setPreference(entry.getKey(), entry.getValue());
            }
            this.setProfile(ffProfile);
        }
        HashSet<String> excludedOptions = new HashSet<String>(Arrays.asList(props.getExcludedOptions()));
        super.asMap().forEach((k, v) -> {
            if (!excludedOptions.contains(k)) {
                this.options.put((String)k, v);
            }
        });
    }

    public Map<String, Object> asMap() {
        return this.options;
    }
}

