/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator;

import com.google.common.io.CharStreams;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ATS {
    public static final String WEB_SITE = "https://actiontestscript.org";
    private static String atsVersion;
    private static String atsServer;
    private String[] args = null;
    private Options options = new Options();
    private File projectFolder = null;
    private File destinationFolder = null;
    private File reportFolder = null;
    private File outputFolder = null;
    private boolean compile = false;

    public static void logError(String msg) {
        ATS.print("ERROR", msg);
    }

    public static void logInfo(String msg) {
        ATS.print("INFO", msg);
    }

    public static void logWarn(String msg) {
        ATS.print("WARN", msg);
    }

    private static void print(String type, String msg) {
        System.out.println("[" + type + "] " + msg);
    }

    public static String getAtsVersion() {
        if (atsVersion == null) {
            InputStream resourceAsStream = ATS.class.getResourceAsStream("/com/ats/ats.properties");
            try {
                String content = CharStreams.toString((Readable)new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
                Pattern pattern = Pattern.compile("version=(.*)", 2);
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    atsVersion = matcher.group(1);
                }
            }
            catch (Exception e) {
                atsVersion = "N/A";
            }
        }
        return atsVersion;
    }

    public static String getAtsServer() {
        if (atsServer == null) {
            InputStream resourceAsStream = ATS.class.getResourceAsStream("/com/ats/ats.properties");
            try {
                String content = CharStreams.toString((Readable)new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
                Pattern pattern = Pattern.compile("atsServer=(.*)", 2);
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    atsServer = matcher.group(1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return atsServer;
    }

    public ATS(String[] args) {
        this.args = args;
        this.options.addOption("h", "help", false, "Show help");
        this.options.addOption("f", "force", false, "Force Java files generation if files or folder exists");
        this.options.addOption("c", "compile", false, "Compile generated java files");
        this.options.addOption("prj", "project", true, "ATS project folder");
        this.options.addOption("dest", "destination", true, "Generated Java files destination folder");
        this.options.addOption("rep", "report", true, "Execution report Java files destination folder");
        this.options.addOption("suites", "suiteXmlFiles", true, "Execution suites to launch");
    }

    public void parse() {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(this.options, this.args);
        }
        catch (ParseException e) {
            ATS.logError("cannot parse command line : " + e.getMessage());
        }
        if (cmd != null) {
            if (cmd.hasOption("h")) {
                this.help();
            } else {
                boolean force = cmd.hasOption("f");
                this.compile = cmd.hasOption("c");
                String prjFolder = ".";
                prjFolder = cmd.hasOption("prj") ? cmd.getOptionValue("prj") : Paths.get("", new String[0]).toAbsolutePath().toFile().getPath();
                File file = new File(prjFolder);
                if (file.exists()) {
                    this.projectFolder = new File(file.getAbsolutePath());
                } else {
                    Path projectPath = Paths.get(prjFolder, new String[0]);
                    this.projectFolder = projectPath.toFile();
                }
                if (this.projectFolder.exists()) {
                    ATS.logInfo("using ATS project folder -> " + this.projectFolder.getAbsolutePath());
                } else {
                    ATS.logError("project folder does not exists -> " + this.projectFolder.getAbsolutePath());
                }
                if (cmd.hasOption("dest")) {
                    this.destinationFolder = new File(cmd.getOptionValue("dest"));
                    if (this.destinationFolder.exists()) {
                        if (force) {
                            ATS.logWarn("destination folder exists ! (java files will be deleted)");
                        } else {
                            ATS.logError("destination folder exists, please delete folder or use '-force' option");
                        }
                    }
                    ATS.logInfo("using destination folder -> " + this.destinationFolder.getAbsolutePath());
                } else {
                    this.destinationFolder = Paths.get("target", new String[0]).resolve("generated").toAbsolutePath().toFile();
                }
                if (cmd.hasOption("rep")) {
                    this.reportFolder = new File(cmd.getOptionValue("rep"));
                    if (this.reportFolder.exists()) {
                        if (force) {
                            ATS.logWarn("execution report folder found, it will be deleted");
                        } else {
                            ATS.logError("execution report folder exists, please delete folder or use '-force' option");
                        }
                    }
                    ATS.logInfo("using report folder : " + this.reportFolder.getAbsolutePath());
                }
            }
        }
    }

    private void help() {
    }

    public boolean isCompile() {
        return this.compile;
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public File getDestinationFolder() {
        return this.destinationFolder;
    }

    public File getReportFolder() {
        return this.reportFolder;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }
}

