/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform;

import com.ats.MathEvaluation;
import com.ats.generator.variables.transform.Transformer;

public class NumericTransformer
extends Transformer {
    private int decimal = -1;
    private boolean comma = false;

    public NumericTransformer() {
    }

    public NumericTransformer(Object dp, Object useComma) {
        this((Integer)dp, (Boolean)useComma);
    }

    public NumericTransformer(int dp) {
        this.setDecimal(dp);
        this.setComma(false);
    }

    public NumericTransformer(int dp, boolean useComma) {
        this.setDecimal(dp);
        this.setComma(useComma);
    }

    public NumericTransformer(String data) {
        if (data.contains(",")) {
            this.setComma(true);
            data = data.replace(",", "");
        }
        this.setDecimal(this.getInt(data.replace("dp", "").trim()));
    }

    @Override
    public String getJavaCode() {
        StringBuilder sb = new StringBuilder(", ").append("nm").append("(").append(this.decimal).append(", ").append(this.comma).append(")");
        return sb.toString();
    }

    @Override
    public String format(String data) {
        MathEvaluation math = new MathEvaluation(this.comma, this.decimal);
        return math.eval(data);
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public boolean getComma() {
        return this.comma;
    }

    public void setComma(boolean value) {
        this.comma = value;
    }
}

