/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.crypto.Password;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.SystemValues;
import com.ats.generator.ATS;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.generator.variables.ConditionalValue;
import com.ats.generator.variables.ProjectVariable;
import com.ats.generator.variables.PropertyVariable;
import com.ats.script.Project;
import com.ats.script.actions.Action;
import com.ats.script.actions.neoload.ActionNeoload;
import com.ats.script.actions.network.ActionNetwork;
import com.ats.script.actions.network.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.Operators;
import com.ats.tools.Utils;
import com.ats.tools.logger.ExecutionLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.openqa.selenium.Keys;
import org.testng.annotations.Test;

public class ScriptHeader {
    private static final String NAME = "name";
    private static final String PROJECT_ID = "project-id";
    private static final String PROJECT_DESCRIPTION = "project-description";
    private static final String PROJECT_PATH = "project-path";
    public static final String ID = "id";
    public static final String UUID = "uuid";
    public static final String EXTERNAL_ID = "external";
    public static final String GROUPS = "groups";
    public static final String DESCRIPTION = "description";
    public static final String DATE_CREATED = "created";
    public static final String RETURN = "return";
    public static final String AUTHOR = "author";
    public static final String MODIFIED_AT = "modified-at";
    public static final String MODIFIED_BY = "modified-by";
    public static final String PREREQUISITE = "prerequisite";
    public static final String MEMO = "memo";
    public static final String PRE_PROCESSING = "pre-processing";
    public static final String POST_PROCESSING = "post-processing";
    public static final Predicate<String> GROUPS_MATCH = g -> g.regionMatches(true, 0, GROUPS, 0, GROUPS.length());
    public static final Predicate<String> ID_MATCH = g -> g.regionMatches(true, 0, ID, 0, ID.length());
    public static final Predicate<String> UUID_MATCH = g -> g.regionMatches(true, 0, UUID, 0, UUID.length());
    public static final Predicate<String> AUTHOR_MATCH = g -> g.regionMatches(true, 0, AUTHOR, 0, AUTHOR.length());
    public static final Predicate<String> MODIFIED_AT_MATCH = g -> g.regionMatches(true, 0, MODIFIED_AT, 0, MODIFIED_AT.length());
    public static final Predicate<String> MODIFIED_BY_MATCH = g -> g.regionMatches(true, 0, MODIFIED_BY, 0, MODIFIED_BY.length());
    public static final Predicate<String> PREREQUISITE_MATCH = g -> g.regionMatches(true, 0, PREREQUISITE, 0, PREREQUISITE.length());
    public static final Predicate<String> DESCRIPTION_MATCH = g -> g.regionMatches(true, 0, DESCRIPTION, 0, DESCRIPTION.length());
    public static final Predicate<String> DATE_CREATED_MATCH = g -> g.regionMatches(true, 0, DATE_CREATED, 0, DATE_CREATED.length());
    public static final Predicate<String> RETURN_MATCH = g -> g.regionMatches(true, 0, RETURN, 0, RETURN.length());
    public static final Predicate<String> EXTERNAL_ID_MATCH = g -> g.regionMatches(true, 0, EXTERNAL_ID, 0, EXTERNAL_ID.length());
    public static final Predicate<String> MEMO_MATCH = g -> g.regionMatches(true, 0, MEMO, 0, MEMO.length());
    public static final Predicate<String> PRE_PROCESSING_MATCH = g -> g.regionMatches(true, 0, PRE_PROCESSING, 0, PRE_PROCESSING.length());
    public static final Predicate<String> POST_PROCESSING_MATCH = g -> g.regionMatches(true, 0, POST_PROCESSING, 0, POST_PROCESSING.length());
    private File testReportFolder;
    private File javaDestinationFolder;
    private File javaFile;
    private String path = "";
    private String projectPath = "";
    private Project project;
    @Expose(serialize=true)
    private String packageName = "";
    @Expose(serialize=true)
    private String name = "";
    @Expose(serialize=true)
    private String id = "";
    @Expose(serialize=true)
    private String uuid = "";
    @Expose(serialize=true)
    private String externalId = "";
    @Expose(serialize=true)
    private List<String> groups = List.of();
    @Expose(serialize=true)
    private String description = "";
    @Expose(serialize=true)
    private String author = "";
    @Expose(serialize=true)
    private String prerequisite = "";
    @Expose(serialize=true)
    private String memo = "";
    private String preprocessing = "";
    private String postprocessing = "";
    @Expose(serialize=true)
    private Date createdAt = new Date();
    @Expose(serialize=true)
    private Date modifiedAt = new Date(0L);
    @Expose(serialize=true)
    private String modifiedBy = "";
    @Expose(serialize=true)
    private String projectId = "";
    @Expose(serialize=true)
    private String projectDescription = "";
    @Expose(serialize=true)
    private String projectUuid = "";
    private String logsType = "";
    @Expose(serialize=true)
    private String error = null;
    private static final String javaCode = String.join((CharSequence)System.getProperty("line.separator"), "", "//---------------------------------------------------------------------------------------", "//\t    _  _____ ____     ____                           _             ", "//\t   / \\|_   _/ ___|   / ___| ___ _ __   ___ _ __ __ _| |_ ___  _ __ ", "//\t  / _ \\ | | \\___ \\  | |  _ / _ \\ '_ \\ / _ \\ '__/ _` | __/ _ \\| '__|", "//\t / ___ \\| |  ___) | | |_| |  __/ | | |  __/ | | (_| | || (_) | |   ", "//\t/_/   \\_\\_| |____/   \\____|\\___|_| |_|\\___|_|  \\__,_|\\__\\___/|_|   ", "//", "//---------------------------------------------------------------------------------------", "//\t/!\\ Warning /!\\", "//\tThis class was automatically generated by ATS Script Generator (ver. #ATS_VERSION#)", "//\tYou may lose modifications if you edit this file manually !", "//---------------------------------------------------------------------------------------", "", "import " + ScriptHeader.class.getPackageName() + ".*;", "import " + Action.class.getPackageName() + ".*;", "import " + ActionNeoload.class.getPackageName() + ".*;", "import " + ActionNetwork.class.getPackageName() + ".*;", "import " + ActionOctoperfVirtualUser.class.getPackageName() + ".*;", "import " + ActionTestScript.class.getName() + ";", "import " + Cartesian.class.getName() + ";", "import " + Mouse.class.getName() + ";", "import " + ConditionalValue.class.getName() + ";", "import " + ProjectVariable.class.getName() + ";", "import " + Password.class.getName() + ";", "import " + PropertyVariable.class.getName() + ";", "import " + Operators.class.getName() + ";", "import " + Keys.class.getName() + ";", "", "public class #CLASS_NAME# extends " + ActionTestScript.class.getSimpleName() + "{", "", "\t/**", "\t* Test Name : <b>#TEST_NAME#</b>", "\t* Generated at : <b>" + DateFormat.getDateTimeInstance().format(new Date()) + "</b>", "\t* Script created at : #TEST_CREATED_AT#", "\t* #TEST_DESCRIPTION#", "\t* @author\t#TEST_AUTHOR_NAME#", "\t*/", "", "\t// -----------------[ ATS script info ]----------------- //", "", "\tpublic static final java.lang.String ATS_TEST_ID = \"#TEST_ID#\";", "\tpublic static final java.lang.String ATS_TEST_NAME = \"#TEST_NAME#\";", "\tpublic static final java.lang.String ATS_AUTHOR_NAME = \"#TEST_AUTHOR_NAME#\";", "\tpublic static final java.lang.String ATS_DESCRIPTION = \"#TEST_DESCRIPTION#\";", "\tpublic static final java.lang.String ATS_PREREQUISITES = \"#TEST_PREREQUISITES#\";", "\tpublic static final java.lang.String ATS_MEMO = \"#TEST_MEMO#\";", "\tpublic static final java.util.Date TEST_MODIFIED_AT = getIsoDate(\"#TEST_MODIFIED_AT#\");", "\tpublic static final java.lang.String TEST_MODIFIED_BY = \"#TEST_MODIFIED_BY#\";", "\tpublic static final java.lang.String ATS_EXTERNAL_ID = \"#TEST_EXTERNAL_ID#\";", "\tpublic static final java.lang.String ATS_GROUPS = \"#GROUPS_NAME#\";", "\tpublic static final java.lang.String ATS_PROJECT_ID = \"#PROJECT_ID#\";", "\tpublic static final java.lang.String ATS_PROJECT_DESCRIPTION = \"#PROJECT_DESCRIPTION#\";", "\tpublic static final java.lang.String ATS_PROJECT_UUID = \"#PROJECT_UUID#\";", "\tpublic static final java.lang.String ATS_LOGS_TYPE = \"#PROJECT_LOGS_TYPE#\";", "\tpublic static final java.lang.String ATS_PRE_PROCESSING = \"#TEST_PRE_PROCESSING#\";", "\tpublic static final java.lang.String ATS_POST_PROCESSING = \"#TEST_POST_PROCESSING#\";", "", "\t// -----------------[ Constructors ]----------------- //", "", "\tpublic #CLASS_NAME#(){super();}", "\tpublic #CLASS_NAME#(" + ActionTestScript.class.getName() + " sc){super(sc);}", "", "\t// -----------------[ Overrides ]----------------- //", "", "\t@java.lang.Override", "\tprotected " + ScriptHeader.class.getSimpleName() + " getScriptHeader(){return new ScriptHeader(ATS_PROJECT_UUID, ATS_PROJECT_ID, ATS_PROJECT_DESCRIPTION, ATS_TEST_NAME, ATS_TEST_ID, ATS_AUTHOR_NAME, ATS_DESCRIPTION, ATS_PREREQUISITES, ATS_EXTERNAL_ID, ATS_MEMO, ATS_PRE_PROCESSING, ATS_POST_PROCESSING, ATS_GROUPS, ATS_LOGS_TYPE, TEST_MODIFIED_AT, TEST_MODIFIED_BY);}", "", "\t// -----------------[ Test ]----------------- //", "", "\tpublic void testMain(){", "\t\t#SCRIPT_PREFIX##CLASS_NAME#();", "\t}", "", "\t@" + Test.class.getName() + "#TEST_ANNOTATION#", "\tpublic void #SCRIPT_PREFIX##CLASS_NAME#(){");

    public ScriptHeader() {
    }

    public ScriptHeader(String projectUuid, String projectId, String projectDescription, String testName, String id, String author, String description, String prerequisites, String externalId, String memo, String preprocessing, String postprocessing, String groups, String logsType, Date modifiedAt, String modifiedBy) {
        this.projectUuid = projectUuid;
        this.projectId = projectId;
        this.projectDescription = projectDescription;
        this.name = testName;
        this.id = id;
        this.author = author;
        this.description = description;
        this.modifiedAt = modifiedAt;
        this.modifiedBy = modifiedBy;
        this.prerequisite = prerequisites;
        this.externalId = externalId;
        this.memo = memo;
        this.preprocessing = preprocessing;
        this.postprocessing = postprocessing;
        this.logsType = logsType;
        this.setGroups(Arrays.asList(groups.split(",")));
    }

    public ScriptHeader(Project prj, File file) {
        this.project = prj;
        this.setProjectPath(prj.getFolderPath());
        this.setPath(file.getAbsolutePath());
        this.setName(Utils.removeExtension(file.getName()));
        try {
            Path relative = prj.getAtsSourceFolder().relativize(file.getParentFile().toPath());
            this.setPackageName(relative.toString().replace(File.separator, "."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.testReportFolder = prj.getReportFolder().toFile();
        this.javaFile = prj.getJavaFile(this.getPackagePath() + this.name + ".java");
        this.javaDestinationFolder = prj.getJavaDestinationFolder().toFile();
    }

    public ScriptHeader(Project prj) {
        this.project = prj;
        this.projectPath = prj.getFolderPath();
        this.path = this.projectPath + "/AtsTemp-";
        this.name = "AtsTemp-";
        this.packageName = "";
    }

    public ScriptHeader(String name) {
        this.name = name;
        this.packageName = "";
    }

    public File getTestReportFolder(Path path) {
        return this.testReportFolder;
    }

    public File getReportFolder() {
        return this.testReportFolder;
    }

    public File getJavaDestinationFolder() {
        return this.javaDestinationFolder;
    }

    public File getJavaFile() {
        return this.javaFile;
    }

    public String getPackagePath() {
        Object path = this.packageName.replace(".", File.separator);
        if (((String)path).length() > 0) {
            path = (String)path + File.separator;
        }
        return path;
    }

    public void parseGroups(String data) {
        this.setGroups(Arrays.stream(data.split(",")).map(String::trim).filter(s -> s.length() > 0).collect(Collectors.toList()));
    }

    public String getDataGroups() {
        return this.getDataGroupsName();
    }

    public String getDataGroupsName() {
        if (this.groups != null) {
            return String.join((CharSequence)",", this.groups);
        }
        return "";
    }

    public String getDataGroupsJson() {
        if (this.project != null && this.groups != null) {
            return this.project.getGroupsJson(this.groups);
        }
        return "";
    }

    public String getGroupsList() {
        if (this.groups != null) {
            StringJoiner joiner = new StringJoiner(",");
            for (String group : this.groups) {
                if (group.length() <= 0) continue;
                joiner.add(group);
            }
            return joiner.toString();
        }
        return "";
    }

    public String getJoinedGroups() {
        if (this.groups != null) {
            StringJoiner joiner = new StringJoiner(", ");
            for (String group : this.groups) {
                if (group.length() <= 0) continue;
                joiner.add("\"" + group + "\"");
            }
            return joiner.toString();
        }
        return "";
    }

    private String getTestAnnotation() {
        StringBuilder annotation = new StringBuilder();
        String groups = this.getJoinedGroups();
        if (groups.length() > 0) {
            annotation.append("groups={").append(groups).append("}");
        }
        if (this.description != null && this.description.length() > 0) {
            if (annotation.length() > 0) {
                annotation.append(",");
            }
            annotation.append("description=\"");
            annotation.append(StringEscapeUtils.escapeJava((String)Utils.leftString(this.description, 30)));
            annotation.append("\"");
        }
        if (annotation.length() > 0) {
            annotation.insert(0, "(").append(")");
            return annotation.toString();
        }
        return "";
    }

    public String getQualifiedName() {
        if (this.packageName != null && this.packageName.length() > 0) {
            return this.packageName + "." + this.name;
        }
        return this.name;
    }

    public String getJavaCode(Project project) {
        String code = javaCode.replace("#CLASS_NAME#", this.name).replace("#TEST_NAME#", this.getQualifiedName()).replace("#TEST_ID#", StringEscapeUtils.escapeJava((String)this.id)).replace("#TEST_DESCRIPTION#", StringEscapeUtils.escapeJava((String)this.description)).replace("#TEST_PREREQUISITES#", StringEscapeUtils.escapeJava((String)this.prerequisite)).replace("#TEST_AUTHOR_NAME#", StringEscapeUtils.escapeJava((String)this.author)).replace("#TEST_EXTERNAL_ID#", StringEscapeUtils.escapeJava((String)this.externalId)).replace("#TEST_PRE_PROCESSING#", StringEscapeUtils.escapeJava((String)this.preprocessing)).replace("#TEST_POST_PROCESSING#", StringEscapeUtils.escapeJava((String)this.postprocessing)).replace("#TEST_MEMO#", StringEscapeUtils.escapeJava((String)this.memo)).replace("#TEST_MODIFIED_AT#", Utils.dateFormat(this.modifiedAt)).replace("#TEST_MODIFIED_BY#", StringEscapeUtils.escapeJava((String)this.modifiedBy)).replace("#TEST_ANNOTATION#", this.getTestAnnotation()).replace("#GROUPS_NAME#", this.getDataGroupsName()).replace("#ATS_VERSION#", ATS.getAtsVersion()).replace("#TEST_CREATED_AT#", DateFormat.getDateTimeInstance().format(this.createdAt)).replace("#PROJECT_UUID#", StringEscapeUtils.escapeJava((String)project.getUuid())).replace("#PROJECT_DESCRIPTION#", StringEscapeUtils.escapeJava((String)project.getDescription())).replace("#SCRIPT_PREFIX#", StringEscapeUtils.escapeJava((String)project.getScriptPrefix())).replace("#PROJECT_LOGS_TYPE#", StringEscapeUtils.escapeJava((String)project.getLogsType())).replace("#PROJECT_ID#", StringEscapeUtils.escapeJava((String)project.getGav()));
        if (!this.packageName.isEmpty()) {
            return "package " + this.packageName + ";\r\n" + code;
        }
        return code;
    }

    public Map<String, Object> getJsonData(int quality, long started) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put(ID, this.getId());
        valueNode.put("fullName", this.getQualifiedName());
        valueNode.put(DESCRIPTION, this.getDescription());
        valueNode.put(AUTHOR, this.getAuthor());
        valueNode.put("modifiedAt", String.valueOf(this.getModifiedAt().getTime()));
        valueNode.put("modifiedBy", this.getModifiedBy());
        valueNode.put(GROUPS, this.getGroupsList());
        valueNode.put("preRequisites", this.getPrerequisite());
        valueNode.put("externalId", this.getExternalId());
        valueNode.put(MEMO, this.getMemo());
        valueNode.put("videoQuality", quality);
        valueNode.put("started", Long.toString(started));
        return valueNode;
    }

    public void setSystemProperties(String value) {
    }

    public String getSystemProperties() {
        return String.join((CharSequence)",", SystemValues.VALUES_NAME);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public String getData(String key) {
        switch (key) {
            case "description": {
                return this.getDescription();
            }
            case "name": {
                return this.getName();
            }
            case "external": {
                return this.getExternalId();
            }
            case "prerequisite": {
                return this.getPrerequisite();
            }
            case "id": {
                return this.getId();
            }
            case "groups": {
                return this.getGroupsList();
            }
            case "author": {
                return this.getAuthor();
            }
            case "project-id": {
                return this.getProjectId();
            }
            case "project-description": {
                return this.getProjectDescription();
            }
            case "project-path": {
                return Project.getProjectFolderPath();
            }
            case "modified-by": {
                return this.getModifiedBy();
            }
            case "memo": {
                return this.getMemo();
            }
            case "post-processing": {
                return this.getPostprocessing();
            }
            case "pre-processing": {
                return this.getPreprocessing();
            }
        }
        return "";
    }

    public void sendPreprocessing(ExecutionLogger logger, String suiteName) {
        this.sendRestData(logger, this.preprocessing, suiteName, -1L, -1, false);
    }

    public void sendPostprocessing(ExecutionLogger logger, String suiteName, long duration, int actions, boolean passed) {
        this.sendRestData(logger, this.postprocessing, suiteName, duration, actions, passed);
    }

    private void sendRestData(ExecutionLogger logger, String url, String suiteName, long duration, int actions, boolean passed) {
        if (url != null && ((String)url).length() > 0) {
            if (!((String)url).toLowerCase().startsWith("http")) {
                url = "http://" + (String)url;
            }
            try {
                Request.Builder reqBuilder = new Request.Builder().url((String)url);
                Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
                JsonObject jsonObj = (JsonObject)gson.toJsonTree((Object)this);
                jsonObj.addProperty("suite", suiteName);
                if (duration != -1L && actions != -1) {
                    jsonObj.addProperty("duration", (Number)duration);
                    jsonObj.addProperty("passed", Boolean.valueOf(passed));
                    jsonObj.addProperty("actions", (Number)actions);
                }
                RequestBody body = RequestBody.Companion.create(jsonObj.toString(), Utils.JSON_MEDIA);
                OkHttpClient client = new OkHttpClient.Builder().cache(null).connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
                Request request = reqBuilder.addHeader("User-Agent", "Ats-Execution-Agent").addHeader("Content-Type", "application/json; charset=utf-8").post(body).build();
                Response response = client.newCall(request).execute();
                response.close();
            }
            catch (Exception e) {
                logger.sendWarning("unable to send REST data", e.getMessage());
            }
        }
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> value) {
        this.groups = value.stream().distinct().collect(Collectors.toList());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String value) {
        this.author = value;
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(String value) {
        this.prerequisite = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String value) {
        this.externalId = value;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String value) {
        this.projectPath = value;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date value) {
        this.createdAt = value;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String value) {
        this.uuid = value;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getLogsType() {
        return this.logsType;
    }

    public void setLogsType(String logsType) {
        this.logsType = logsType;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getPreprocessing() {
        return this.preprocessing;
    }

    public void setPreprocessing(String preprocessing) {
        this.preprocessing = preprocessing;
    }

    public String getPostprocessing() {
        return this.postprocessing;
    }

    public void setPostprocessing(String postprocessing) {
        this.postprocessing = postprocessing;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date value) {
        this.modifiedAt = value;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }
}

