/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.AtsSingleton;
import com.ats.data.Rectangle;
import com.ats.driver.AtsManager;
import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.element.test.TestElementDialog;
import com.ats.element.test.TestElementImage;
import com.ats.element.test.TestElementRecord;
import com.ats.element.test.TestElementRoot;
import com.ats.element.test.TestElementSap;
import com.ats.element.test.TestElementSystem;
import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElementAbstract;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;

public class ActionExecuteElement
extends ActionExecuteElementAbstract {
    private SearchedElement searchElement;
    protected TestElement testElement;
    private boolean async;
    private int actionMaxTry;

    public ActionExecuteElement() {
    }

    public ActionExecuteElement(Script script, ExecuteOptions options, int stopPolicy, ArrayList<String> element) {
        super(script, options, stopPolicy);
        if (element != null && !element.isEmpty()) {
            this.setSearchElement(new SearchedElement(script, element));
        }
    }

    public ActionExecuteElement(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element) {
        super(script, options, stopPolicy, maxTry, delay);
        this.setSearchElement(element);
    }

    public int getActionMaxTry() {
        return this.actionMaxTry;
    }

    public TestElement getTestElement() {
        return this.testElement;
    }

    private void setTestElement(TestElement element) {
        if (this.testElement != null) {
            this.testElement.dispose();
        }
        this.testElement = element;
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        if (this.searchElement == null) {
            codeBuilder.append("null");
        } else {
            codeBuilder.append(this.searchElement.getJavaCode());
        }
        return codeBuilder;
    }

    public void execute(ActionTestScript ts, String testName, int testLine) {
        this.execute(ts, testName, testLine, 0);
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        try {
            this.executeNoStale(ts, testName, testLine, tryNum);
        }
        catch (JavascriptException e) {
            this.status.setException(-13, (Exception)((Object)e));
            ts.getTopScript().getLogger().sendError(this.status.getErrorType(), e.getMessage());
            ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), this.status.getMessage());
        }
    }

    private void executeNoStale(ActionTestScript ts, String testName, int testLine, int tryNum) {
        for (int maxTry = 0; maxTry < AtsManager.getMaxStaleOrJavaScriptError(); ++maxTry) {
            try {
                this.execute(ts, testName, testLine, ">", 0, maxTry + tryNum);
                return;
            }
            catch (StaleElementReferenceException e) {
                ts.getTopScript().getLogger().sendWarning("stale reference error", "try again : " + maxTry);
                this.status.setException(-16, (Exception)((Object)e));
                AtsSingleton.getInstance().getCurrentChannel().sleep(500);
                this.setTestElement(null);
                continue;
            }
        }
        throw new WebDriverException("execute element error : " + this.status.getFailMessage());
    }

    public void execute(ActionTestScript ts, String testName, int testLine, String operator, int value, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        if (this.status.isPassed()) {
            int delay = this.getDelay();
            if (delay > 0) {
                ts.getTopScript().getLogger().sendInfo("delay before action", delay + "s");
                this.getCurrentChannel().sleep(delay * 1000);
            }
            this.actionMaxTry = AtsSingleton.getInstance().getMaxTry() + this.getMaxTry();
            if (this.actionMaxTry < 1) {
                this.actionMaxTry = 1;
            }
            if (this.testElement == null) {
                Predicate<Integer> predicate = this.getPredicate(operator, value);
                if (this.searchElement == null) {
                    this.setTestElement(new TestElementRoot(ts, this.getCurrentChannel(), predicate));
                } else {
                    int trySearch = 0;
                    if (this.searchElement.isDialog()) {
                        while (trySearch < this.actionMaxTry) {
                            this.setTestElement(new TestElementDialog(ts, this.getStatus(), this.getCurrentChannel(), this.actionMaxTry, this.searchElement, predicate));
                            if (this.testElement.isValidated()) {
                                trySearch = this.actionMaxTry;
                                continue;
                            }
                            this.getCurrentChannel().sendWarningLog(50, "element not found, wait and try again", this.actionMaxTry - ++trySearch);
                            this.getCurrentChannel().progressiveWait(trySearch);
                        }
                    } else if (this.searchElement.isSysComp()) {
                        while (trySearch < this.actionMaxTry) {
                            if (this.getCurrentChannel().isSap()) {
                                this.setTestElement(new TestElementSap(ts, this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                            } else {
                                this.setTestElement(new TestElementSystem(ts, this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                            }
                            if (this.testElement.isValidated()) {
                                trySearch = this.actionMaxTry;
                                continue;
                            }
                            this.getCurrentChannel().sendWarningLog(50, "element not found, wait and try again", this.actionMaxTry - ++trySearch);
                            this.getCurrentChannel().progressiveWait(trySearch);
                        }
                    } else {
                        SearchedElement parent = this.searchElement.getParent();
                        if (parent != null && parent.isScrollable()) {
                            TestElement parentElement = new TestElement(ts, this.getCurrentChannel(), this.actionMaxTry, predicate, parent);
                            Rectangle parentRect = parentElement.getFoundElement().getRectangle();
                            int tryScrollSearch = 0;
                            int tryScrollSearchMax = AtsSingleton.getInstance().getMaxTryScroll();
                            while (tryScrollSearch < tryScrollSearchMax) {
                                if (tryScrollSearch > 0) {
                                    parentElement.swipe(-200);
                                    this.getCurrentChannel().sleep(2000);
                                }
                                if (this.searchElement.isImageSearch()) {
                                    this.setTestElement(new TestElementImage(ts, this.getCurrentChannel(), 1, predicate, this.searchElement));
                                } else if (this.searchElement.isRecordSearch()) {
                                    this.setTestElement(new TestElementRecord(ts, this.getCurrentChannel(), 1, predicate, this.searchElement));
                                } else if (this.getCurrentChannel().isSap()) {
                                    this.setTestElement(new TestElementSap(ts, this.getCurrentChannel(), 1, predicate, this.searchElement));
                                } else {
                                    this.setTestElement(new TestElement(ts, this.getCurrentChannel(), 1, predicate, this.searchElement));
                                }
                                if (this.testElement.isValidated() && parentRect.contains(this.testElement.getFoundElement().getRectangle())) {
                                    tryScrollSearch = tryScrollSearchMax;
                                    continue;
                                }
                                parentElement = new TestElement(ts, this.getCurrentChannel(), this.actionMaxTry, predicate, parent);
                                ++tryScrollSearch;
                            }
                        } else {
                            while (trySearch < this.actionMaxTry) {
                                if (this.searchElement.isImageSearch()) {
                                    this.setTestElement(new TestElementImage(ts, this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                                } else if (this.searchElement.isRecordSearch()) {
                                    this.setTestElement(new TestElementRecord(ts, this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                                } else if (this.getCurrentChannel().isSap()) {
                                    this.setTestElement(new TestElementSap(ts, this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                                } else {
                                    this.setTestElement(new TestElement(ts, this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                                }
                                if (this.testElement.isValidated()) {
                                    trySearch = this.actionMaxTry;
                                    continue;
                                }
                                this.getCurrentChannel().tryAndWait(50, "element not found, wait and try again", this.actionMaxTry, this.actionMaxTry - ++trySearch);
                            }
                        }
                    }
                }
                this.status.setElement(this.testElement);
                this.status.setSearchDuration(this.testElement.getTotalSearchDuration());
                this.status.setData(this.testElement.getCount());
                AtsSingleton.getInstance().sleep(this.getDelay());
                this.asyncExec(ts);
            } else {
                this.terminateExecution(ts);
            }
        }
    }

    protected boolean getLoadAttributes() {
        if (this.searchElement != null) {
            return this.searchElement.getLoadAttributes();
        }
        return false;
    }

    private Predicate<Integer> getPredicate(String operator, int value) {
        switch (operator) {
            case "<>": {
                return p -> p != value;
            }
            case ">": {
                return p -> p > value;
            }
            case ">=": {
                return p -> p >= value;
            }
            case "<": {
                return p -> p < value;
            }
            case "<=": {
                return p -> p <= value;
            }
        }
        return p -> p == value;
    }

    private void asyncExec(ActionTestScript ts) {
        if (!this.async) {
            this.terminateExecution(ts);
        }
    }

    public void terminateExecution(ActionTestScript ts) {
        int error = 0;
        if (this.testElement.isValidated()) {
            this.status.setPassed(true);
        } else {
            this.status.setError(-1, this.testElement.getNotFoundDescription());
            error = -1;
            this.saveAppSource();
        }
        this.terminateExecution(ts, error);
    }

    protected void terminateExecution(ActionTestScript ts, int error) {
        this.testElement.terminateExecution(this.status, ts, error, this.status.endDuration());
    }

    protected void terminateExecution(ActionTestScript ts, int error, String value, String data) {
        this.testElement.terminateExecution(this.status, ts, error, this.status.endDuration(), value, data);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("searchDuration", (Number)this.status.getSearchDuration());
        data.addProperty("delay", (Number)this.getDelay());
        if (this.status.getElement() != null) {
            data.addProperty("occurrences", (Number)this.status.getElement().getCount());
        }
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        if (this.searchElement != null) {
            keywords.addAll(this.searchElement.getKeywords());
        }
        return keywords;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean value) {
        this.async = value;
    }

    public SearchedElement getSearchElement() {
        return this.searchElement;
    }

    public void setSearchElement(SearchedElement value) {
        this.searchElement = value;
    }
}

