/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.atsv.processors;

import com.ats.tools.report.atsv.models.ActionData;
import com.ats.tools.report.atsv.models.ReportData;
import com.ats.tools.report.atsv.processors.HtmlPlayerReportProcessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class CalculateActionsTimeLineHtmlPlayerReportProcessor
implements HtmlPlayerReportProcessor {
    @Override
    public ReportData process(ReportData reportData) {
        if (CollectionUtils.isNotEmpty(reportData.actionsData())) {
            List<ActionData> updatedActionsData = this.calculateActionsTimeLine(reportData.actionsData());
            return reportData.withNewActionsData(updatedActionsData);
        }
        return reportData;
    }

    private List<ActionData> calculateActionsTimeLine(List<ActionData> actionsData) {
        if (actionsData.size() == 1) {
            return List.of(actionsData.getFirst().withNewTimeLine(0L));
        }
        ArrayList<ActionData> updatedActionsData = new ArrayList<ActionData>(actionsData);
        ActionData previousAction = actionsData.getFirst().withNewTimeLine(0L);
        updatedActionsData.set(0, previousAction);
        for (int i = 1; i < actionsData.size(); ++i) {
            previousAction = ((ActionData)updatedActionsData.get(i)).withNewTimeLine(previousAction.timeLine() + previousAction.duration());
            updatedActionsData.set(i, previousAction);
        }
        return updatedActionsData;
    }
}

