/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.atsv.processors;

import com.ats.script.actions.ActionCallscript;
import com.ats.tools.report.atsv.models.ActionData;
import com.ats.tools.report.atsv.models.ImageData;
import com.ats.tools.report.atsv.models.ReportData;
import com.ats.tools.report.atsv.processors.HtmlPlayerReportProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class RemoveActionCallscriptActionsHtmlPlayerReportProcessor
implements HtmlPlayerReportProcessor {
    private static final String ACTION_CALLSCRIPT = "ActionCallscript";

    @Override
    public ReportData process(ReportData reportData) {
        if (CollectionUtils.isNotEmpty(reportData.actionsData())) {
            List<ActionData> updatedActionsData = this.removeActionCallscriptActions(reportData.actionsData());
            return reportData.withNewActionsAndTestData(reportData.testData().withNewActions(updatedActionsData.size()), updatedActionsData);
        }
        return reportData;
    }

    private List<ActionData> removeActionCallscriptActions(List<ActionData> actions) {
        List<ActionData> actionsData = this.squashActionCallscriptActionsSequences(actions);
        for (int i = actionsData.size() - 1; i > -1; --i) {
            ActionData nextAction;
            ActionData actionData = actionsData.get(i);
            if (!actionData.type().endsWith(ACTION_CALLSCRIPT)) continue;
            int previousActionIndex = i - 1;
            int nextActionIndex = i + 1;
            ActionData previousAction = previousActionIndex > -1 ? actionsData.get(previousActionIndex) : null;
            ActionData actionData2 = nextAction = nextActionIndex < actionsData.size() ? actionsData.get(nextActionIndex) : null;
            if (Objects.isNull(previousAction) && Objects.nonNull(nextAction)) {
                newNextImages = nextAction.images().addImageToBeginningOfImagePool(actionData.images().imagesPool().get(0));
                actionsData.set(nextActionIndex, nextAction.withNewImageDataAndDuration(newNextImages, actionData.duration()));
            } else if (Objects.nonNull(previousAction) && Objects.isNull(nextAction)) {
                ImageData newPreviousImages = previousAction.images().addImageToEndOfImagePool(actionData.images().imagesPool().get(actionData.images().numImages() - 1));
                actionsData.set(previousActionIndex, previousAction.withNewImageDataAndDuration(newPreviousImages, actionData.duration()));
            } else {
                newNextImages = nextAction.images().addImageToBeginningOfImagePool(actionData.images().imagesPool().get(actionData.images().numImages() - 1));
                actionsData.set(nextActionIndex, nextAction.withNewImageDataAndDuration(newNextImages, actionData.duration()));
                ImageData newPreviousImages = previousAction.images().addImageToEndOfImagePool(actionData.images().imagesPool().get(0));
                actionsData.set(previousActionIndex, previousAction.withNewImageDataAndDuration(newPreviousImages, actionData.duration()));
            }
            actionsData.remove(i);
        }
        return this.updateActionsDataIndexSequence(actionsData);
    }

    private List<ActionData> squashActionCallscriptActionsSequences(List<ActionData> actionsData) {
        int[] actionCallscriptIndexes = IntStream.range(0, actionsData.size()).filter(index -> ((ActionData)actionsData.get(index)).type().endsWith(ACTION_CALLSCRIPT)).toArray();
        HashMap callscriptActionsSquashed = new HashMap();
        HashMap<Integer, ActionData> callscriptActionsTemp = new HashMap<Integer, ActionData>();
        for (int actionCallscriptIndex : actionCallscriptIndexes) {
            ActionData actionData = actionsData.get(actionCallscriptIndex);
            if (callscriptActionsTemp.isEmpty()) {
                callscriptActionsTemp.put(actionCallscriptIndex, actionData);
                continue;
            }
            if (Objects.nonNull(callscriptActionsTemp.get(actionCallscriptIndex - 1))) {
                callscriptActionsTemp.put(actionCallscriptIndex, actionData);
                continue;
            }
            this.squashActionCallscriptActionsSequence(callscriptActionsTemp.values()).ifPresent(callscriptAaction -> {
                int minIndex = callscriptActionsTemp.keySet().stream().mapToInt(Integer::intValue).min().getAsInt();
                callscriptActionsSquashed.put(minIndex, callscriptAaction);
            });
            callscriptActionsTemp.clear();
            callscriptActionsTemp.put(actionCallscriptIndex, actionData);
        }
        if (!callscriptActionsTemp.isEmpty()) {
            this.squashActionCallscriptActionsSequence(callscriptActionsTemp.values()).ifPresent(callscriptAaction -> {
                int minIndex = callscriptActionsTemp.keySet().stream().mapToInt(Integer::intValue).min().getAsInt();
                callscriptActionsSquashed.put(minIndex, callscriptAaction);
            });
        }
        ArrayList<ActionData> newActions = new ArrayList<ActionData>();
        for (int i = 0; i < actionsData.size(); ++i) {
            ActionData actionData = actionsData.get(i);
            if (actionData.type().endsWith(ACTION_CALLSCRIPT)) {
                ActionData compoundCallScript = (ActionData)callscriptActionsSquashed.get(i);
                if (!Objects.nonNull(compoundCallScript)) continue;
                newActions.add(compoundCallScript);
                continue;
            }
            newActions.add(actionData);
        }
        return newActions;
    }

    private Optional<ActionData> squashActionCallscriptActionsSequence(Collection<ActionData> actionCallscriptActions) {
        long duration;
        Map<Integer, String> imagesPool;
        List<ActionData> actionsData = this.removeActionCallscriptActionsWithoutImages(actionCallscriptActions);
        if (CollectionUtils.isEmpty(actionsData)) {
            return Optional.empty();
        }
        ActionData firstActionCallScript = actionsData.getFirst();
        if (actionsData.size() == 1) {
            if (firstActionCallScript.images().numImages() > 1) {
                imagesPool = Map.of(0, firstActionCallScript.images().imagesPool().get(0), 1, firstActionCallScript.images().imagesPool().get(firstActionCallScript.images().numImages() - 1));
                duration = firstActionCallScript.duration() / (long)firstActionCallScript.images().numImages();
            } else {
                imagesPool = Map.of(0, firstActionCallScript.images().imagesPool().get(0), 1, firstActionCallScript.images().imagesPool().get(0));
                duration = firstActionCallScript.duration();
            }
        } else {
            ActionData lastActionCallScript = actionsData.getLast();
            imagesPool = Map.of(0, firstActionCallScript.images().imagesPool().get(0), 1, lastActionCallScript.images().imagesPool().get(lastActionCallScript.images().numImages() - 1));
            duration = (firstActionCallScript.duration() + lastActionCallScript.duration()) / (long)(firstActionCallScript.images().numImages() + lastActionCallScript.images().numImages());
        }
        ImageData imageData = new ImageData(firstActionCallScript.images().imageType(), imagesPool.size(), imagesPool);
        return Optional.of(ActionData.createEmptyActionDataWithTypeAndDurationAndImageData(ActionCallscript.class.getName(), duration, imageData));
    }

    private List<ActionData> removeActionCallscriptActionsWithoutImages(Collection<ActionData> actionCallscriptActions) {
        return actionCallscriptActions.stream().filter(actionData -> MapUtils.isNotEmpty(actionData.images().imagesPool())).toList();
    }

    private List<ActionData> updateActionsDataIndexSequence(List<ActionData> actionsData) {
        return IntStream.range(0, actionsData.size()).mapToObj(i -> ((ActionData)actionsData.get(i)).withNewIndex(i)).toList();
    }
}

