/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.context.reader;

import com.ats.script.Project;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.adapters.PassContinueReportAdapter;
import com.ats.tools.report.context.reader.AbstractReportContextExecutionReader;
import com.ats.tools.report.models.ExecutionGroup;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Properties;
import com.ats.tools.report.models.ReportItem;
import com.ats.tools.report.models.ReportSettings;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.TestSummary;
import com.ats.tools.report.summary.SummaryCalculator;
import com.ats.tools.report.utils.FileUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FullReportContextExecutionReader
extends AbstractReportContextExecutionReader {
    public FullReportContextExecutionReader(ReportSettings reportSettings, ReportItem suiteItem) {
        super(new PassContinueReportAdapter(), new SummaryCalculator(), reportSettings, suiteItem);
    }

    @Override
    protected void readFiles() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        this.setScripts(FileUtils.getScripts(this.getReportSettings().outputFolder().toString()));
        this.setProject((HtmlReportProject)objectMapper.readValue(Files.readString(this.getReportSettings().jsonSuiteFile()), HtmlReportProject.class));
        this.populateProjectLogoAndWatermark(this.getProject());
        this.setResults((Results)objectMapper.readValue(this.getReportSettings().outputFolder().resolve("ats-results.json").toFile(), Results.class));
        this.setTestSummaries(this.getTestSummariesForExecutions(this.getReportSettings().outputFolder(), this.getProject().getSuites()));
    }

    @Override
    Properties readProjectProperties() throws Exception {
        Document projectProperties = Project.getProjectProperties();
        if (Objects.isNull(projectProperties)) {
            throw new IllegalStateException("cannot load project properties");
        }
        return new Properties(this.readUserProfileImages(projectProperties), this.readExecutionGroup(projectProperties), this.readParameters(projectProperties));
    }

    private Map<String, String> readUserProfileImages(Document projectProperties) {
        NodeList users = projectProperties.getElementsByTagName("user");
        HashMap<String, String> userProfileImages = new HashMap<String, String>(users.getLength());
        for (int i = 0; i < users.getLength(); ++i) {
            NamedNodeMap attributes = users.item(i).getAttributes();
            userProfileImages.put(attributes.getNamedItem("systemUser").getNodeValue(), attributes.getNamedItem("pic").getNodeValue());
        }
        return Collections.unmodifiableMap(userProfileImages);
    }

    private Map<String, ExecutionGroup> readExecutionGroup(Document projectProperties) {
        NodeList groups = projectProperties.getElementsByTagName("group");
        HashSet<ExecutionGroup> executionGroups = new HashSet<ExecutionGroup>(groups.getLength());
        for (int i = 0; i < groups.getLength(); ++i) {
            NamedNodeMap attr = groups.item(i).getAttributes();
            String tag = attr.getNamedItem("tag").getNodeValue();
            String color = attr.getNamedItem("color").getNodeValue();
            String description = attr.getNamedItem("description").getNodeValue();
            executionGroups.add(new ExecutionGroup(groups.item(i).getTextContent(), tag, color, description));
        }
        return Collections.unmodifiableMap(executionGroups.stream().collect(Collectors.toMap(ExecutionGroup::name, Function.identity())));
    }

    private Map<String, String> readParameters(Document projectProperties) {
        NodeList environment = projectProperties.getElementsByTagName("environment");
        ArrayList<String> parametersNames = new ArrayList<String>();
        HashMap parameters = new HashMap();
        Node node = environment.item(0);
        if (node.getNodeType() == 1) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                parametersNames.add(child.getTextContent().trim());
            }
        }
        parametersNames.forEach(parameterName -> parameters.put(parameterName, System.getProperty(parameterName)));
        parameters.entrySet().removeIf(stringStringEntry -> stringStringEntry.getValue() == null);
        return Collections.unmodifiableMap(parameters);
    }

    private void populateProjectLogoAndWatermark(HtmlReportProject project) {
        project.setProjectLogo(Objects.requireNonNullElse(FileUtils.getBase64ImageProperty(Project.REPORT_LOGO_URL), project.getATS_LOGO()));
        project.setProjectWatermark(FileUtils.getBase64ImageProperty(Project.REPORT_WATERMARK_URL));
    }

    private List<TestSummary> getTestSummariesForExecutions(Path outputFolderPath, List<Suite> suites) throws Exception {
        ArrayList<TestSummary> summaries = new ArrayList<TestSummary>();
        for (Suite suite : suites) {
            for (String testName : suite.getTests()) {
                Path targetPath = outputFolderPath.resolve(suite.getName()).resolve(testName + "_xml");
                File testReportFolder = targetPath.resolve("actions.xml").toFile();
                if (testReportFolder.exists()) {
                    TestSummary testSummary = this.readTestSummary(testReportFolder, suite.getName(), testName);
                    Path atstReport = outputFolderPath.resolve(suite.getName()).resolve(testName + "_atsv.html");
                    testSummary.setAstvReportGenerated(Files.exists(atstReport, new LinkOption[0]) && Files.isRegularFile(atstReport, new LinkOption[0]));
                    summaries.add(testSummary);
                    continue;
                }
                AtsLogger.printLog("test case filtered and not executed", suite.getName() + ":" + testName);
            }
        }
        return summaries;
    }
}

