/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element.test;

import com.ats.element.FoundElement;
import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.desktop.DesktopData;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TestElementRecord
extends TestElement {
    public static final String ATS_DURATION = "capture-duration";
    public static final String ATS_FRAMERATE = "capture-framerate";
    public static final String SHAPES_COUNT = "shapes-count";
    public static final String SHAPES_AVERAGE = "shapes-average";
    public static final String DEVICES_COUNT = "devicesCount";
    public static final String DEVICE = "device";
    public static final String DURATION = "duration";
    public static final String ERROR_MESSAGE = "error-message";

    public TestElementRecord(ActionTestScript script, Channel channel, int maxTry, Predicate<Integer> predicate, SearchedElement searchElement) {
        super(script, channel, maxTry, predicate, searchElement);
    }

    @Override
    protected List<FoundElement> loadElements(SearchedElement searchedElement) {
        if (this.parent != null) {
            int[] result = searchedElement.updateRecordSelector();
            return new ArrayList<FoundElement>(Arrays.asList(new FoundElement(this.channel, this.parent, result[0], result[1])));
        }
        return Collections.emptyList();
    }

    private Map<String, String> loadShapes() throws Exception {
        if (this.getCount() > 0) {
            List<DesktopData> results = this.channel.getShapes(this.getFoundElement().getAttribute().get(DURATION), this.getFoundElement().getAttribute().get(DEVICE), this.getFoundElement().getScreenRectangle());
            Map<String, String> map = results.stream().collect(Collectors.toMap(e -> e.getName(), e -> e.getValue()));
            if (map.get(ERROR_MESSAGE) != null) {
                throw new Exception(map.get(ERROR_MESSAGE));
            }
            return map;
        }
        throw new Exception("element not found");
    }

    @Override
    public void over(ActionStatus status, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
    }

    @Override
    protected void mouseClick(ActionStatus status, MouseDirection position, int offsetX, int offsetY) {
    }

    @Override
    public void mouseWheel(int delta) {
    }

    @Override
    public void clearText(ActionStatus status, MouseDirection md) {
    }

    @Override
    public String sendText(ActionTestScript script, ActionStatus status, CalculatedValue text, int waitChar) {
        return "";
    }

    @Override
    public String enterText(ActionStatus status, CalculatedValue text, ActionTestScript script, int waitChar) {
        return "";
    }

    @Override
    public void drag(ActionStatus status, MouseDirection position, int offsetX, int offsetY, boolean offset) {
    }

    @Override
    public Object executeScript(ActionStatus status, String script, boolean returnValue) {
        return null;
    }

    @Override
    public String getAttribute(ActionStatus status, String name) {
        if (ATS_OCCURRENCES.equals(name)) {
            return String.valueOf(this.getCount());
        }
        if (ATS_OCCURRENCES_INDEX.equals(name)) {
            return String.valueOf(this.getIndex());
        }
        if (SHAPES_COUNT.equals(name) || SHAPES_AVERAGE.equals(name)) {
            try {
                return this.loadShapes().get(name);
            }
            catch (Exception e) {
                status.setError(-16, e.getMessage());
                return e.getMessage();
            }
        }
        return "";
    }

    @Override
    public CalculatedProperty[] getHtmlAttributes() {
        return this.getAttributes(true);
    }

    @Override
    public CalculatedProperty[] getAttributes(boolean reload) {
        try {
            Map<String, String> map = this.loadShapes();
            return new CalculatedProperty[]{this.getAtsProperty(ATS_OCCURRENCES.toString()), this.getAtsProperty(ATS_OCCURRENCES_INDEX.toString()), new CalculatedProperty(SHAPES_COUNT, new CalculatedValue(map.get(SHAPES_COUNT))), new CalculatedProperty(SHAPES_AVERAGE, new CalculatedValue(map.get(SHAPES_AVERAGE)))};
        }
        catch (Exception e) {
            return new CalculatedProperty[]{this.getAtsProperty(ATS_OCCURRENCES.toString()), this.getAtsProperty(ATS_OCCURRENCES_INDEX.toString())};
        }
    }
}

