/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.parameter;

import com.ats.element.FoundElement;
import com.ats.element.ParameterElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.parameter.Parameter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class ParameterList {
    private int iterations = 1;
    private List<Parameter> list;
    private ParameterElement element;

    public ParameterList() {
        this(0);
    }

    public ParameterList(int iterations) {
        this.list = new ArrayList<Parameter>();
        this.iterations = iterations;
    }

    public ParameterList(int iterations, List<Parameter> list) {
        this.list = new ArrayList<Parameter>(list);
        this.iterations = iterations;
    }

    public ParameterList(FoundElement elem, List<Parameter> list) {
        this.list = new ArrayList<Parameter>(list);
        this.iterations = list.size() + 1;
        this.element = elem.getParameterElement();
    }

    public ParameterList(FoundElement elem, String[] array) {
        ArrayList<Parameter> l = new ArrayList<Parameter>(array.length);
        int loop = 0;
        for (String s : array) {
            l.add(new Parameter(loop, s));
            ++loop;
        }
        this.setList(l);
        this.element = elem.getParameterElement();
    }

    public ParameterList(FoundElement elem, String[] cols, List<Parameter> parameterList) {
        this(elem, cols);
        for (Parameter param : parameterList) {
            this.list.add(param);
        }
        this.iterations = this.list.size() + 1;
    }

    public ParameterList(String data) {
        this.list = List.of(new Parameter(0, data));
    }

    public void addParameter(Parameter param) {
        this.list.add(param);
        this.iterations = this.list.size() + 1;
    }

    public void updateCalculated(ActionTestScript ts) {
        this.list.forEach(p -> p.updateCalculated(ts));
    }

    public void appendJavaCode(StringBuilder codeBuilder) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Parameter param : this.list) {
            joiner.add(param.getJavaCode());
        }
        codeBuilder.append(", ").append("p").append("(").append(joiner.toString()).append(")");
    }

    public String getParameterValue(String name, String defaultValue) {
        for (Parameter item : this.list) {
            if (!name.equals(item.getName())) continue;
            return item.getCalculated();
        }
        return defaultValue;
    }

    public String getParameterValue(int index, String defaultValue) {
        if (this.list.size() > index) {
            return this.list.get(index).getCalculated();
        }
        return defaultValue;
    }

    public String[] getParameters() {
        String[] result = new String[this.list.size()];
        int loop = 0;
        for (Parameter item : this.list) {
            result[loop] = item.getValue() == null ? item.getData() : item.getValue().getCalculated();
            ++loop;
        }
        return result;
    }

    public int getParametersSize() {
        if (this.list != null) {
            return this.list.size();
        }
        return 0;
    }

    public Map<String, String> getMap() {
        return this.list.stream().collect(Collectors.toMap(e -> e.getName(), e -> e.getCalculated()));
    }

    public JsonElement toJson() {
        JsonArray arr = new JsonArray(this.list.size());
        for (Parameter p : this.list) {
            JsonObject o = new JsonObject();
            o.addProperty("index", (Number)p.getIndex());
            o.addProperty("value", p.getValue().getCalculated());
            arr.add((JsonElement)o);
        }
        return arr;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int value) {
        this.iterations = value;
    }

    public List<Parameter> getList() {
        return this.list;
    }

    public void setList(ArrayList<Parameter> list) {
        this.list = list;
        this.iterations = list.size() + 1;
    }

    public ParameterElement getElement() {
        return this.element;
    }

    public void setElement(ParameterElement element) {
        this.element = element;
    }
}

