/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.AtsSingleton;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.ActionChannel;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ActionChannelStart
extends ActionChannel {
    private static final String UNKNOWN_ICON = "iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAABhWlDQ1BJQ0MgcHJvZmlsZQAAKJF9kT1Iw1AUhU9TRdGqgx1EHCJUJ7tUEcdSxSJYKG2FVh1MXvoHTRqSFBdHwbXg4M9i1cHFWVcHV0EQ/AFxdnBSdJES70sKLWK88Hgf591zeO8+QGhUmGp2RQFVs4xUPCZmc6tizyt86McgxhGRmKkn0osZeNbXPXVT3YV5lnffnzWg5E0G+ETiKNMNi3iDeHbT0jnvEwdZSVKIz4mnDLog8SPXZZffOBcdFnhm0Mik5omDxGKxg+UOZiVDJZ4hDimqRvlC1mWF8xZntVJjrXvyFwby2kqa67TGEMcSEkhChIwayqjAQph2jRQTKTqPefhHHX+SXDK5ymDkWEAVKiTHD/4Hv2drFqYjblIgBnS/2PbHBNCzCzTrtv19bNvNE8D/DFxpbX+1Acx9kl5va6EjYGgbuLhua/IecLkDjDzpkiE5kp+WUCgA72f0TTlg+BboW3Pn1jrH6QOQoVkt3wAHh8BkkbLXPd7d2zm3f3ta8/sBzblyy7AF0DoAAAAJcEhZcwAAAdgAAAHYAfpcpnIAAAAHdElNRQfoAQ0QBSpDI1zBAAAAGXRFWHRDb21tZW50AENyZWF0ZWQgd2l0aCBHSU1QV4EOFwAAA4ZJREFUSMeNll1om1UYx3/nvG/evk2afiZphmvmQHBQ6ZXCCoOC82J1ggiCNxM/diNBEEEUmQFlne7KCxW9ceJF7xSsiA2zFGSDBS8m2GlxrjO1cbb7iGsX8tW87zle5G2XNHlj/rfPc/7Px/mf5zkCH4zNLAfRKoEQx9D6CWACacSNcAxhWhvAErAAnAfWsslwqR2PaEt+ZnkSpV4GjgP7dg3SwAvQ6L4OfA98kU2GMx0DHDi7Yqta9QToGSACGI12yzAw+mM40kI387jAHeAdYDabDFdaAhw4u2Irp/oqWp8CBhtPPtwneTxuMDxsMTAU4V7JZOGGy+Ut3ZwBbAJnNHyy6gUxdyxe5k3kAFMjBq9M2uwfgIApiY9aGAGL6buKjy5Vmcu5je6DwClRD/T5bgVez78BRhu9RwKCz57qYzToeldgEI2NErR7AMiXNC/NlVja0sjmSm4Cz2ST4Ywcm1kOehcaafQoaXhuvHeX3NGSS9cVc7/UyN5V9QSCgtces8irFp1EgJMHPy0EJVolPLU0tTOv4MgD3kUJ+HbZ5fVMhTd+2ubjC1XKTt02HjMYs1vEaABPAgmJEMeapNgA6Z3TCC6vVrGAHgF/3lPky3UdSQnDVtuntA+YNr1H1IKohPNXHQ4/ZHFrS/FXSQOCmq5nHQvWozsO5MrsVdMOjprARDuLLeDLlW0Wcg4FR7PlaJSEZw8avDnVg2WA1nBxzaVY0/TLtgEmTCDuNy60hr8r929wKmry1hGbAa/n2X9dPvx5248cIG7SJUZMwQuP2oyEQAPXbrm892OV2xXd8ZwENroJEO0RHIrUqypUNO9erJJpo8892JDeVOwIV8ODMQuBQgi4lld8ta66yWtJIsRiN55Wg0yym4pB0VVnFyVap72R6wtDwJUbNW4WBP9sar77wyEk/5d8HUibINZAzwMv4itnuF52ef6HKsGhCreLJmbnClxgHsjJXGq8BJzz5rkvDoUkXx+3ST9tMz1moDqL5w5wLpsMFyVALvVIBkh587wFSkMiEmCgVzEUkhzeb1DxJ98EUjvb7f47MMxZlDuE1m/v3QlSwJWNGhdWLaJFh/TV+kv3If8AmG27MhPv/96rXecEcLrdyuwLGFj9MQr4rsyUtzLLnZf+6V8ngZPeyO1m6c97Pc909auof1t+C6H1GDANHPX5tiwCaSCXTYaL7Xj+A+GqRtjLA+pTAAAAAElFTkSuQmCC";
    private static final String SCRIPT_START_LABEL = "channel-start";
    public static final Predicate<String> PREDICATE = "channel-start"::equals;
    public static final int NETWORK = 1;
    public static final int NEOLOAD = 2;
    private CalculatedValue application;
    private ArrayList<CalculatedValue> arguments = new ArrayList();
    private int network = 0;
    private boolean useCookie = false;
    private boolean attach = false;
    private String authentication = "";
    private String authenticationValue = "";
    private String uuid;

    public ActionChannelStart() {
    }

    public ActionChannelStart(Script script, ExecuteOptions options, String name, CalculatedValue value) {
        this(script, options, name, value, Collections.emptyList());
    }

    public ActionChannelStart(Script script, ExecuteOptions options, String name, CalculatedValue value, List<String> dataArray) {
        super(script, options, name);
        this.setApplication(value);
        options.updateChannelStart(this, dataArray, script);
    }

    public ActionChannelStart(Script script, ExecuteOptions options, boolean attach, boolean useCookie, String name, CalculatedValue value, String[] optionsx) {
        this(script, options.add(optionsx), name, value, Collections.emptyList());
        this.setAttach(attach);
        this.setUseCookie(useCookie);
    }

    public ActionChannelStart(Script script, ExecuteOptions options, boolean attach, boolean useCookie, String name, CalculatedValue value, String[] optionsx, CalculatedValue ... calculatedValues) {
        this(script, options.add(optionsx), name, value, Collections.emptyList());
        this.setArguments(new ArrayList<CalculatedValue>(Arrays.asList(calculatedValues)));
        this.setAttach(attach);
        this.setUseCookie(useCookie);
    }

    public void setUuid(String value) {
        this.uuid = value;
    }

    @Override
    public Element getXmlElement(Document document, ScriptHeader header, int index) {
        Element e = super.getXmlElement(document, header, index);
        Element dataJson = document.createElement("dataJson");
        e.appendChild(dataJson);
        Element param = document.createElement("parameter");
        param.setAttribute("type", "name");
        param.setAttribute("value", this.getName());
        dataJson.appendChild(param);
        param = document.createElement("parameter");
        param.setAttribute("type", "appIcon");
        param.setAttribute("value", UNKNOWN_ICON);
        dataJson.appendChild(param);
        param = document.createElement("parameter");
        param.setAttribute("type", "app");
        param.setAttribute("value", this.application.getCalculated());
        dataJson.appendChild(param);
        Element channel = document.createElement("channel");
        channel.setAttribute("name", this.getName());
        e.appendChild(channel);
        return e;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int line, int tryNum) {
        this.setStatus(new ActionStatus(testName, line));
        this.line = line;
        if (this.getCondition().isPassed()) {
            AtsSingleton.getInstance().startChannel(this, ts);
        }
    }

    @Override
    public JsonObject getActionLogsData() {
        JsonObject data = super.getActionLogsData();
        if (this.getCondition().isPassed()) {
            Channel channel = this.status.getChannel();
            data.addProperty("app", this.application.getCalculated());
            data.addProperty("appVersion", channel.getApplicationVersion());
            for (CalculatedValue dataCalculated : this.arguments) {
                String calc = dataCalculated.getCalculated();
                String[] splitted = calc.split("=");
                String dataName = splitted[0];
                String dataValue = "";
                if (splitted.length > 1) {
                    dataValue = splitted[1];
                }
                data.addProperty("param::" + dataName, dataValue);
            }
            if (this.network == 1) {
                data.addProperty("networkCapture", "true");
            }
            if (this.useCookie) {
                data.addProperty("useCookie", "true");
            }
            data.addProperty("os", channel.getOs());
        } else {
            data.addProperty("condition", "not_validated");
        }
        return data;
    }

    public JsonObject getActionData() {
        Channel channel = this.status.getChannel();
        JsonObject data = this.getActionLogsData();
        data.addProperty("appIcon", Base64.getEncoder().encodeToString(channel.getIcon()));
        return data;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.application.getKeywords());
        return keywords;
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode().append(this.isAttach()).append(", ").append(this.isUseCookie()).append(", ").append("\"").append(this.getName()).append("\", ").append(this.application.getJavaCode()).append(", new java.lang.String[]{");
        ArrayList<String> options = new ArrayList<String>();
        if (this.network == 1) {
            options.add(String.format("\"%s\"", "net"));
        } else if (this.network == 2) {
            options.add(String.format("\"%s\"", "neoload"));
        }
        if (this.authentication != null && !this.authentication.isEmpty()) {
            options.add(String.format("\"%s\"", this.authentication));
            options.add(String.format("\"%s\"", this.authenticationValue));
        }
        codeBuilder.append(String.join((CharSequence)", ", options)).append("}");
        if (!this.arguments.isEmpty()) {
            codeBuilder.append(", ");
            StringJoiner argumentsJoiner = new StringJoiner(", ");
            for (CalculatedValue calc : this.arguments) {
                argumentsJoiner.add(calc.getJavaCode());
            }
            codeBuilder.append(argumentsJoiner);
        }
        return codeBuilder.append(")");
    }

    public CalculatedValue getApplication() {
        return this.application;
    }

    public void setApplication(CalculatedValue value) {
        this.application = value;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String value) {
        this.authentication = value;
    }

    public String getAuthenticationValue() {
        return this.authenticationValue;
    }

    public void setAuthenticationValue(String value) {
        this.authenticationValue = value;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int value) {
        this.network = value;
    }

    public ArrayList<CalculatedValue> getArguments() {
        return this.arguments;
    }

    public void setArguments(ArrayList<CalculatedValue> arguments) {
        this.arguments = arguments;
    }

    public boolean isAttach() {
        return this.attach;
    }

    public void setAttach(boolean attach) {
        this.attach = attach;
    }

    public boolean isUseCookie() {
        return this.useCookie;
    }

    public void setUseCookie(boolean value) {
        this.useCookie = value;
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("callscript -> ").append(subFolder).append(".ChannelStart");
    }
}

