/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.FoundElement;
import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.script.actions.condition.ExecuteOptions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class ActionFileTransfer
extends ActionExecuteElement {
    public static final String DOWNLOAD = "download";
    public static final String UPLOAD = "upload";
    public static final Predicate<String> PREDICATE = g -> DOWNLOAD.equalsIgnoreCase((String)g) || UPLOAD.equalsIgnoreCase((String)g);
    private CalculatedValue file;
    private String type = "upload";
    private boolean clear = false;
    private boolean autoSubmit = false;
    private boolean subfolder = false;

    public ActionFileTransfer() {
    }

    public ActionFileTransfer(AtsScript script, ExecuteOptions options, int stopPolicy, String type, String file, ArrayList<String> objectArray) {
        super(script, options, stopPolicy, objectArray);
        this.setFile(new CalculatedValue(script, file));
        this.setType(type);
        this.setClear(options.isClearFile());
        this.setAutoSubmit(options.isAutoSubmit());
        this.setSubfolder(options.isSubfolder());
    }

    public ActionFileTransfer(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, String type, boolean clear, boolean autoSubmit, boolean subfolder, CalculatedValue text) {
        super(script, options, stopPolicy, maxTry, delay, element);
        this.setFile(text);
        this.setType(type);
        this.setClear(clear);
        this.setAutoSubmit(autoSubmit);
        this.setSubfolder(subfolder);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode().append(", \"").append(this.type).append("\", ").append(this.clear).append(", ").append(this.autoSubmit).append(", ").append(this.subfolder).append(", ").append(this.file.getJavaCode());
        codeBuilder.append(")");
        return codeBuilder;
    }

    public URL getAssetDataFile(String path) {
        return ActionFileTransfer.loopAssetsFiles(new File(this.getClass().getClassLoader().getResource("assets").getPath()).listFiles(), path.replace("\\", File.separator).replace("/", File.separator).toLowerCase());
    }

    private static URL loopAssetsFiles(File[] files, String path) {
        if (files != null) {
            for (File f : files) {
                if (f == null || !f.canRead()) continue;
                if (f.isDirectory()) {
                    return ActionFileTransfer.loopAssetsFiles(f.listFiles(), path);
                }
                if (!f.isFile() || !f.getPath().toLowerCase().endsWith(path)) continue;
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void terminateExecution(ActionTestScript ts) {
        String[] files;
        super.terminateExecution(ts);
        String calculated = this.getFile().getCalculated();
        ArrayList<String> foundFiles = new ArrayList<String>();
        ArrayList<Object> notFoundFiles = new ArrayList<Object>();
        for (String string : files = calculated.split(",")) {
            void var9_11;
            if (string.isEmpty()) continue;
            if (string.startsWith("#FILE_NOT_FOUND#")) {
                notFoundFiles.add(string.substring("#FILE_NOT_FOUND#".length()));
                continue;
            }
            if (string.startsWith("assets://")) {
                String string2 = ts.getAssetsUrl("assets" + string.replace("assets://", ""));
            } else if (!string.startsWith("file:///")) {
                String string3 = "file:///" + string;
            }
            File f2 = null;
            try {
                f2 = new File(new URI((String)var9_11));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (f2 != null && f2.exists()) {
                foundFiles.add(f2.getAbsolutePath());
                continue;
            }
            notFoundFiles.add(var9_11);
        }
        String value = String.join((CharSequence)",", foundFiles);
        String data = String.join((CharSequence)",", notFoundFiles);
        if (this.status.isPassed()) {
            if (this.testElement.isInputFile()) {
                if (calculated.isBlank()) {
                    this.getTestElement().getWebElement().clear();
                } else {
                    ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), value, data);
                    if (notFoundFiles.isEmpty()) {
                        if (this.clear) {
                            this.getTestElement().getWebElement().clear();
                        }
                        WebElement submitInput = null;
                        if (this.autoSubmit) {
                            FoundElement foundElement = this.getTestElement().getFoundElement();
                            this.getCurrentChannel().loadParents(foundElement);
                            FoundElement formParent = this.findFormParent(foundElement);
                            if (formParent == null) {
                                this.status.setError(-28, "Submit element not found (input)");
                                this.terminateExecution(ts, -28, value, data);
                            } else {
                                try {
                                    List submits = formParent.getValue().findElements(By.cssSelector((String)"input[type='submit']"));
                                    if (submits.isEmpty()) {
                                        this.status.setError(-28, "Submit element not found (input)");
                                        this.terminateExecution(ts, -28, value, data);
                                        return;
                                    }
                                    WebElement submitTempInput = (WebElement)submits.getFirst();
                                    if (submitTempInput.isDisplayed() && submitTempInput.isEnabled()) {
                                        submitInput = submitTempInput;
                                    } else {
                                        this.status.setError(-2, "Submit element not visible or enabled (input)");
                                        this.terminateExecution(ts, -2, value, data);
                                    }
                                }
                                catch (NoSuchElementException e) {
                                    this.status.setError(-28, "Submit element not found (input)");
                                    this.terminateExecution(ts, -28, value, data);
                                }
                            }
                        }
                        foundFiles.forEach(f -> this.getTestElement().sendKeys(ts, this.status, (String)f));
                        if (this.autoSubmit && submitInput != null) {
                            try {
                                submitInput.click();
                            }
                            catch (ElementNotInteractableException elementNotInteractableException) {
                                this.status.setError(-3, "Submit element not interactable (input)");
                                this.terminateExecution(ts, -3, value, data);
                            }
                        }
                    } else {
                        this.status.setError(-20, "file(s) not found: " + String.join((CharSequence)",", notFoundFiles));
                        this.terminateExecution(ts, -20, value, data);
                    }
                }
            } else {
                this.status.setError(-27, "element is not an input with 'file' type");
                this.terminateExecution(ts, -27, value, data);
            }
        } else {
            this.terminateExecution(ts, this.status.getCode(), value, data);
        }
    }

    private FoundElement findFormParent(FoundElement element) {
        FoundElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getTag().equals("FORM")) {
            return parent;
        }
        return this.findFormParent(parent);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CalculatedValue getFile() {
        return this.file;
    }

    public void setFile(CalculatedValue value) {
        this.file = value;
    }

    public boolean isClear() {
        return this.clear;
    }

    public void setClear(boolean value) {
        this.clear = value;
    }

    public boolean isAutoSubmit() {
        return this.autoSubmit;
    }

    public void setAutoSubmit(boolean value) {
        this.autoSubmit = value;
    }

    public boolean isSubfolder() {
        return this.subfolder;
    }

    public void setSubfolder(boolean value) {
        this.subfolder = value;
    }
}

