/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionMouse
extends ActionExecuteElement {
    private String type = "over";
    private MouseDirection position;
    private String spareCode = "";
    protected String scripting = "";
    private static final String MOUSE_CLASS = Mouse.class.getSimpleName() + ".";

    public ActionMouse() {
    }

    public ActionMouse(AtsScript script, ExecuteOptions options, int stopPolicy, ArrayList<String> objectArray) {
        super(script, options, stopPolicy, objectArray);
        this.setPosition(new MouseDirection(script, options, true));
        this.setType("undefined");
    }

    public ActionMouse(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, Mouse mouse) {
        super(script, options, stopPolicy, maxTry, delay, element);
        this.setPosition(mouse.getPosition());
        this.setType(mouse.getType());
    }

    public ActionMouse(AtsScript script, ExecuteOptions options, String type, int stopPolicy, ArrayList<String> objectArray) {
        this(script, options, stopPolicy, objectArray);
        this.setType(type);
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            this.getTestElement().over(this.status, this.position, ts.isDesktopDragDrop(), 0, 0);
        }
        ts.getRecorder().updateScreen(this.status, this.getType(), this.position);
        this.getCurrentChannel().updateVisualAction(false);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("type", this.type);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public void setSpareCode(String spare) {
        this.spareCode = spare;
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(", ").append("ms").append("(").append(this.getMouseType()).append(this.spareCode).append(this.position.getPositionJavaCode()).append(")").append(this.scripting).append(")");
        return codeBuilder;
    }

    private String getMouseType() {
        switch (this.type) {
            case "over": {
                return MOUSE_CLASS + "OVER";
            }
            case "click-double": {
                return MOUSE_CLASS + "DOUBLE_CLICK";
            }
            case "click-right": {
                return MOUSE_CLASS + "RIGHT_CLICK";
            }
            case "click-wheel": {
                return MOUSE_CLASS + "WHEEL_CLICK";
            }
            case "drag": {
                return MOUSE_CLASS + "DRAG";
            }
            case "drop": {
                return MOUSE_CLASS + "DROP";
            }
            case "click": {
                return MOUSE_CLASS + "CLICK";
            }
        }
        return "";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public MouseDirection getPosition() {
        return this.position;
    }

    public void setPosition(MouseDirection value) {
        this.position = value;
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("callscript -> ").append(subFolder).append(".MouseClick");
    }
}

