/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.generator.objects.mouse.MouseKey;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionMouse;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.Keys;

public class ActionMouseKey
extends ActionMouse {
    public static final String CTRL_KEY = "ctrl";
    public static final String SHIFT_KEY = "shift";
    public static final String ALT_KEY = "alt";
    private Keys key = null;
    private boolean useScript = false;

    public ActionMouseKey() {
    }

    public ActionMouseKey(AtsScript script, ExecuteOptions options, String type, int stopPolicy, ArrayList<String> objectArray) {
        super(script, options, type, stopPolicy, objectArray);
        this.setUseScript(options.hasScript());
        options.updateMousKeys(this);
    }

    public ActionMouseKey(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, MouseKey mouse) {
        this(script, options, stopPolicy, maxTry, delay, element, mouse, false);
    }

    public ActionMouseKey(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, MouseKey mouse, boolean useScript) {
        super(script, options, stopPolicy, maxTry, delay, element, mouse);
        this.key = mouse.getKey();
        this.setUseScript(useScript);
    }

    public ActionMouseKey(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, Mouse mouse) {
        this(script, options, stopPolicy, maxTry, delay, element, mouse, false);
    }

    public ActionMouseKey(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, Mouse mouse, boolean useScript) {
        super(script, options, stopPolicy, maxTry, delay, element, mouse);
        this.setUseScript(useScript);
    }

    @Override
    public StringBuilder getJavaCode() {
        this.scripting = this.isUseScript() ? ", true" : ", false";
        if (Keys.CONTROL.equals((Object)this.key)) {
            this.setSpareCode(", Keys.CONTROL");
        } else if (Keys.SHIFT.equals((Object)this.key)) {
            this.setSpareCode(", Keys.SHIFT");
        } else if (Keys.ALT.equals((Object)this.key)) {
            this.setSpareCode(", Keys.ALT");
        } else {
            this.setSpareCode("");
        }
        return super.getJavaCode();
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        try {
            super.terminateExecution(ts);
        }
        catch (ElementNotInteractableException e) {
            this.status.setNoError("element not interactable on over, try to finish action anyway");
        }
        if (this.status.isPassed()) {
            if ("click-wheel".equals(this.getType())) {
                this.getTestElement().wheelClick(this.status, this.getPosition());
            } else if ("click-right".equals(this.getType())) {
                this.getTestElement().rightClick();
            } else if ("click-double".equals(this.getType())) {
                this.getTestElement().doubleClick();
            } else if (this.key != null) {
                this.getTestElement().click(this.status, this.getPosition(), this.key);
            } else if (this.useScript) {
                this.getTestElement().executeScript(this.status, "click();", false);
            } else {
                this.getTestElement().click(this.status, this.getPosition());
            }
            this.status.endAction(ts.getRecorder());
        }
        if (this.key != null) {
            ts.getRecorder().updateScreen(this.status, this.getType() + ":" + this.key.toString(), this.getPosition());
        }
        this.getCurrentChannel().sleepLow();
        ts.getRecorder().updateScreen(false);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        if (this.key != null) {
            data.addProperty("key", this.key.toString());
        }
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public String getKey() {
        if (Keys.CONTROL.equals((Object)this.key)) {
            return CTRL_KEY;
        }
        if (Keys.SHIFT.equals((Object)this.key)) {
            return SHIFT_KEY;
        }
        if (Keys.ALT.equals((Object)this.key)) {
            return ALT_KEY;
        }
        return "";
    }

    public void setKey(String value) {
        this.key = CTRL_KEY.equals(value) ? Keys.CONTROL : (SHIFT_KEY.equals(value) ? Keys.SHIFT : (ALT_KEY.equals(value) ? Keys.ALT : null));
    }

    public boolean isUseScript() {
        return this.useScript;
    }

    public void setUseScript(boolean useScript) {
        this.useScript = useScript;
    }
}

